/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.actions.history;

import cc.co.evenprime.bukkit.nocheat.actions.types.Action;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ActionHistory {
    private final Map<Action, ExecutionHistoryEntry> executionHistory = new HashMap<Action, ExecutionHistoryEntry>();

    public boolean executeAction(Action action, long time) {
        ExecutionHistoryEntry entry = this.executionHistory.get(action);
        if (entry == null) {
            entry = new ExecutionHistoryEntry();
            this.executionHistory.put(action, entry);
        }
        entry.addCounter(time);
        if (entry.getCounter() > action.delay && entry.getLastExecution() < time - (long)(action.repeat * 1000)) {
            entry.setLastExecution(time);
            return true;
        }
        return false;
    }

    private class ExecutionHistoryEntry {
        private final LinkedList<Long> executionTimes = new LinkedList();
        private final long monitoredTimeFrame = 60000L;
        private long lastExecution = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCounter(Long time) {
            LinkedList<Long> linkedList = this.executionTimes;
            synchronized (linkedList) {
                while (this.executionTimes.size() > 0 && this.executionTimes.getFirst() < time - 60000L) {
                    this.executionTimes.removeFirst();
                }
                this.executionTimes.add(time);
            }
        }

        public int getCounter() {
            return this.executionTimes.size();
        }

        public long getLastExecution() {
            return this.lastExecution;
        }

        public void setLastExecution(long time) {
            this.lastExecution = time;
        }
    }
}

