/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.checks.moving;

import cc.co.evenprime.bukkit.nocheat.NoCheat;
import cc.co.evenprime.bukkit.nocheat.actions.ActionExecutor;
import cc.co.evenprime.bukkit.nocheat.actions.ActionExecutorWithHistory;
import cc.co.evenprime.bukkit.nocheat.config.cache.ConfigurationCache;
import cc.co.evenprime.bukkit.nocheat.data.MovingData;
import java.util.HashMap;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class FlyingCheck {
    private final ActionExecutor action;

    public FlyingCheck(NoCheat plugin) {
        this.action = new ActionExecutorWithHistory(plugin);
    }

    public Location check(Player player, Location from, Location to, ConfigurationCache cc, MovingData data) {
        if (data.movingsetBackPoint == null) {
            data.movingsetBackPoint = player.getLocation().clone();
        }
        double yDistance = to.getY() - from.getY();
        double xDistance = to.getX() - from.getX();
        double zDistance = to.getZ() - from.getZ();
        double horizontalDistance = Math.sqrt(xDistance * xDistance + zDistance * zDistance);
        double result = 0.0;
        Location newToLocation = null;
        result += Math.max(0.0, yDistance - data.vertFreedom - cc.moving.flyingSpeedLimitVertical);
        result += Math.max(0.0, horizontalDistance - data.horizFreedom - cc.moving.flyingSpeedLimitHorizontal);
        if ((result *= 100.0) > 0.0) {
            data.movingViolationLevel += result;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("\\[distance\\]", String.format(Locale.US, "%.2f,%.2f,%.2f", xDistance, yDistance, zDistance));
            params.put("\\[locationto\\]", String.format(Locale.US, "%.2f,%.2f,%.2f", to.getX(), to.getY(), to.getZ()));
            params.put("\\[check\\]", "flyingspeed");
            boolean cancel = this.action.executeActions(player, cc.moving.flyingActions, (int)data.movingViolationLevel, params, cc);
            if (cancel) {
                newToLocation = data.movingsetBackPoint;
            }
        }
        data.movingViolationLevel *= 0.97;
        if (newToLocation == null) {
            data.movingsetBackPoint = to.clone();
        }
        data.jumpPhase = 0;
        return newToLocation;
    }
}

