/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.checks.moving;

import net.minecraft.server.Block;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;

public class MovingEventHelper {
    private final double magic = 0.45;
    private final double magic2 = 0.55;
    private static final int NONSOLID = 1;
    private static final int SOLID = 2;
    private static final int LIQUID = 5;
    private static final int LADDER = 11;
    private static final int FENCE = 18;
    private static final int INGROUND = 128;
    private static final int ONGROUND = 256;
    public final int[] types = new int[256];

    public MovingEventHelper() {
        int i = 0;
        while (i < this.types.length) {
            this.types[i] = 1;
            if (Block.byId[i] != null) {
                if (Block.byId[i].material.isSolid()) {
                    this.types[i] = 2;
                } else if (Block.byId[i].material.isLiquid()) {
                    this.types[i] = 5;
                }
            }
            ++i;
        }
        this.types[Material.LADDER.getId()] = 11;
        this.types[Material.FENCE.getId()] = 18;
        this.types[Material.WALL_SIGN.getId()] = 1;
        int n = Material.DIODE_BLOCK_ON.getId();
        this.types[n] = this.types[n] | 3;
        int n2 = Material.DIODE_BLOCK_OFF.getId();
        this.types[n2] = this.types[n2] | 3;
        int n3 = Material.WOODEN_DOOR.getId();
        this.types[n3] = this.types[n3] | 3;
        int n4 = Material.IRON_DOOR_BLOCK.getId();
        this.types[n4] = this.types[n4] | 3;
        int n5 = Material.PISTON_EXTENSION.getId();
        this.types[n5] = this.types[n5] | 3;
        int n6 = Material.PISTON_MOVING_PIECE.getId();
        this.types[n6] = this.types[n6] | 3;
        int n7 = Material.TRAP_DOOR.getId();
        this.types[n7] = this.types[n7] | 3;
    }

    public int isLocationOnGround(World world, double x, double y, double z, boolean waterElevatorsAllowed) {
        int lowerX = this.lowerBorder(x);
        int upperX = this.upperBorder(x);
        int Y = (int)Math.floor(y);
        int lowerZ = this.lowerBorder(z);
        int upperZ = this.upperBorder(z);
        int result = 0;
        result |= this.canStand(world, lowerX, Y, lowerZ);
        result |= this.canStand(world, upperX, Y, lowerZ);
        result |= this.canStand(world, upperX, Y, upperZ);
        if (!this.isInGround(result |= this.canStand(world, lowerX, Y, upperZ)) && this.isSolid(this.types[world.getBlockTypeIdAt(Location.locToBlock((double)x), Location.locToBlock((double)y), Location.locToBlock((double)z))])) {
            result |= 0x80;
        }
        if (waterElevatorsAllowed && result == 0 && ((result = this.types[world.getBlockTypeIdAt(lowerX + 1, Y + 1, lowerZ + 1)] | this.types[world.getBlockTypeIdAt(lowerX, Y + 1, lowerZ + 1)] | this.types[world.getBlockTypeIdAt(lowerX + 1, Y + 1, lowerZ)]) & 5) != 0) {
            return 384;
        }
        return result;
    }

    private final int canStand(World world, int x, int y, int z) {
        int standingIn = this.types[world.getBlockTypeIdAt(x, y, z)];
        int headIn = this.types[world.getBlockTypeIdAt(x, y + 1, z)];
        int result = 0;
        if (this.isLiquid(standingIn) || this.isLiquid(headIn)) {
            return 5;
        }
        if (this.isLadder(standingIn) || this.isLadder(headIn)) {
            return 11;
        }
        int standingOn = this.types[world.getBlockTypeIdAt(x, y - 1, z)];
        if ((this.isSolid(standingIn) || standingOn == 18) && this.isNonSolid(headIn) && standingIn != 18) {
            result = 128;
        }
        if (this.isLadder(headIn) || this.isLadder(standingIn) || (this.isSolid(standingOn) || this.types[world.getBlockTypeIdAt(x, y - 2, z)] == 18) && this.isNonSolid(standingIn) && standingOn != 18) {
            result |= 0x100;
        }
        return result;
    }

    public final boolean isSolid(int value) {
        return (value & 2) == 2;
    }

    public final boolean isLiquid(int value) {
        return (value & 5) == 5;
    }

    final boolean isNonSolid(int value) {
        return (value & 1) == 1;
    }

    private final boolean isLadder(int value) {
        return (value & 0xB) == 11;
    }

    public boolean isOnGround(int fromType) {
        return this.isLadder(fromType) || (fromType & 0x100) == 256;
    }

    public boolean isInGround(int fromType) {
        return this.isLadder(fromType) || this.isLiquid(fromType) || (fromType & 0x80) == 128;
    }

    private final int lowerBorder(double d1) {
        double floor = Math.floor(d1);
        double d4 = floor + 0.45;
        d4 = d4 <= d1 ? 0.0 : 1.0;
        return (int)(floor - d4);
    }

    private final int upperBorder(double d1) {
        double floor = Math.floor(d1);
        double d4 = floor + 0.55;
        d4 = d4 < d1 ? -1.0 : 0.0;
        return (int)(floor - d4);
    }
}

