/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.checks.moving;

import cc.co.evenprime.bukkit.nocheat.NoCheat;
import cc.co.evenprime.bukkit.nocheat.actions.ActionExecutor;
import cc.co.evenprime.bukkit.nocheat.actions.ActionExecutorWithHistory;
import cc.co.evenprime.bukkit.nocheat.checks.moving.MovingEventHelper;
import cc.co.evenprime.bukkit.nocheat.config.cache.ConfigurationCache;
import cc.co.evenprime.bukkit.nocheat.data.MovingData;
import java.util.HashMap;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class RunningCheck {
    private static final double maxBonus = 1.0;
    private static final int jumpingLimit = 6;
    private static final double jumpHeight = 1.35;
    private final ActionExecutor action;

    public RunningCheck(NoCheat plugin) {
        this.action = new ActionExecutorWithHistory(plugin);
    }

    public Location check(Player player, Location from, Location to, MovingEventHelper helper, ConfigurationCache cc, MovingData data) {
        double xDistance = to.getX() - from.getX();
        double zDistance = to.getZ() - from.getZ();
        double horizontalDistance = Math.sqrt(xDistance * xDistance + zDistance * zDistance);
        if (data.movingsetBackPoint == null) {
            data.movingsetBackPoint = player.getLocation().clone();
        }
        int fromType = helper.isLocationOnGround(from.getWorld(), from.getX(), from.getY(), from.getZ(), false);
        int toType = helper.isLocationOnGround(to.getWorld(), to.getX(), to.getY(), to.getZ(), false);
        boolean fromOnGround = helper.isOnGround(fromType);
        boolean fromInGround = helper.isInGround(fromType);
        boolean toOnGround = helper.isOnGround(toType);
        boolean toInGround = helper.isInGround(toType);
        Location newToLocation = null;
        double resultHoriz = Math.max(0.0, this.checkHorizontal(player, helper.isLiquid(fromType) && helper.isLiquid(toType), horizontalDistance, cc, data));
        double resultVert = Math.max(0.0, this.checkVertical(from, fromOnGround, to, toOnGround, cc, data));
        double result = (resultHoriz + resultVert) * 100.0;
        data.movingViolationLevel *= 0.97;
        if (result > 0.0) {
            data.movingViolationLevel += result;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("\\[distance\\]", String.format(Locale.US, "%.2f,%.2f,%.2f", xDistance, to.getY() - from.getY(), zDistance));
            params.put("\\[locationto\\]", String.format(Locale.US, "%.2f,%.2f,%.2f", to.getX(), to.getY(), to.getZ()));
            if (resultHoriz > 0.0 && resultVert > 0.0) {
                params.put("\\[check\\]", "running/both");
            } else if (resultHoriz > 0.0) {
                params.put("\\[check\\]", "running/horizontal");
            } else if (resultVert > 0.0) {
                params.put("\\[check\\]", "running/vertical");
            }
            boolean cancel = this.action.executeActions(player, cc.moving.runningActions, (int)data.movingViolationLevel, params, cc);
            if (cancel) {
                newToLocation = data.movingsetBackPoint;
            }
        } else if (toInGround && from.getY() >= to.getY() || helper.isLiquid(toType)) {
            data.movingsetBackPoint = to.clone();
            data.movingsetBackPoint.setY(Math.ceil(data.movingsetBackPoint.getY()));
            data.jumpPhase = 0;
        } else if (toOnGround && (from.getY() >= to.getY() || data.movingsetBackPoint.getY() <= Math.floor(to.getY()))) {
            data.movingsetBackPoint = to.clone();
            data.movingsetBackPoint.setY(Math.floor(data.movingsetBackPoint.getY()));
            data.jumpPhase = 0;
        } else if (fromOnGround || fromInGround || toOnGround || toInGround) {
            data.jumpPhase = 0;
        }
        return newToLocation;
    }

    private double checkHorizontal(Player player, boolean isSwimming, double totalDistance, ConfigurationCache cc, MovingData data) {
        double distanceAboveLimit = 0.0;
        distanceAboveLimit = cc.moving.sneakingCheck && player.isSneaking() && !player.hasPermission("nocheat.checks.moving.sneaking") ? totalDistance - cc.moving.sneakingSpeedLimit - data.horizFreedom : (cc.moving.swimmingCheck && isSwimming && !player.hasPermission("nocheat.checks.moving.swimming") ? totalDistance - cc.moving.swimmingSpeedLimit - data.horizFreedom : totalDistance - cc.moving.runningSpeedLimit - data.horizFreedom);
        if (distanceAboveLimit > 0.0) {
            distanceAboveLimit -= data.horizontalBuffer;
            data.horizontalBuffer = 0.0;
            if (distanceAboveLimit < 0.0) {
                data.horizontalBuffer = -distanceAboveLimit;
            }
        } else {
            data.horizontalBuffer = Math.min(1.0, data.horizontalBuffer - distanceAboveLimit);
        }
        return distanceAboveLimit;
    }

    private double checkVertical(Location from, boolean fromOnGround, Location to, boolean toOnGround, ConfigurationCache cc, MovingData data) {
        double distanceAboveLimit = 0.0;
        double toY = to.getY();
        double fromY = from.getY();
        double limit = data.vertFreedom + 1.35;
        if (fromY - toY > 0.5) {
            distanceAboveLimit = 0.0;
            ++data.jumpPhase;
        } else {
            Location l = data.movingsetBackPoint == null ? from : data.movingsetBackPoint;
            if (data.jumpPhase > 6) {
                limit -= (double)(data.jumpPhase - 6) * 0.15;
            }
            distanceAboveLimit = toY - l.getY() - limit;
        }
        return distanceAboveLimit;
    }
}

