/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.config.tree;

import cc.co.evenprime.bukkit.nocheat.actions.ActionList;
import cc.co.evenprime.bukkit.nocheat.config.Configuration;
import cc.co.evenprime.bukkit.nocheat.config.tree.ActionListOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.ActionOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.BooleanOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.ChildOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.IntegerOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.LogLevelOption;
import cc.co.evenprime.bukkit.nocheat.config.tree.Option;
import cc.co.evenprime.bukkit.nocheat.config.tree.ParentOption;
import cc.co.evenprime.bukkit.nocheat.log.LogLevel;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationTree
implements Configuration {
    private final ParentOption root = new ParentOption("");
    private ConfigurationTree parent = null;

    public void setParent(ConfigurationTree parent) {
        this.parent = parent;
    }

    public ConfigurationTree getParent() {
        return this.parent;
    }

    private Option getOptionRecursive(String fullIdentifier) {
        String[] identifiers = fullIdentifier.split("\\.");
        Option o = this.root;
        int i = 0;
        while (i < identifiers.length) {
            if (!(o instanceof ParentOption)) break;
            for (Option o2 : o.getChildOptions()) {
                if (!o2.getIdentifier().equals(identifiers[i])) continue;
                o = o2;
                break;
            }
            ++i;
        }
        if (o.getFullIdentifier().equals(fullIdentifier) && o.isActive()) {
            return o;
        }
        if (this.parent != null) {
            return this.parent.getOptionRecursive(fullIdentifier);
        }
        return null;
    }

    public Option getOption(String fullIdentifier) {
        String[] identifiers = fullIdentifier.split("\\.");
        Option o = this.root;
        int i = 0;
        while (i < identifiers.length) {
            if (!(o instanceof ParentOption)) break;
            for (Option o2 : o.getChildOptions()) {
                if (!o2.getIdentifier().equals(identifiers[i])) continue;
                o = o2;
                break;
            }
            ++i;
        }
        if (o.getFullIdentifier().equals(fullIdentifier)) {
            return o;
        }
        return null;
    }

    public void add(String parent, Option option) {
        try {
            if (parent == null || parent == "") {
                this.add(option);
            } else {
                ParentOption po = (ParentOption)this.getOption(parent);
                po.add(option);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void add(Option option) {
        this.root.add(option);
    }

    public List<Option> getAllOptions() {
        ArrayList<Option> options = new ArrayList<Option>();
        ParentOption o = this.root;
        for (Option o2 : o.getChildOptions()) {
            if (!o2.isActive()) continue;
            options.addAll(this.getAllOptions(o2));
        }
        return options;
    }

    private List<Option> getAllOptions(Option subtree) {
        ArrayList<Option> options = new ArrayList<Option>();
        options.add(subtree);
        if (subtree instanceof ParentOption) {
            for (Option child : ((ParentOption)subtree).getChildOptions()) {
                options.addAll(this.getAllOptions(child));
            }
        }
        return options;
    }

    @Override
    public boolean getBoolean(String string) {
        return ((BooleanOption)this.getOptionRecursive(string)).getBooleanValue();
    }

    @Override
    public ActionList getActionList(String string) {
        ActionList actionList = new ActionList();
        ActionListOption option = (ActionListOption)this.getOptionRecursive(string);
        for (ActionOption ao : option.getChildOptions()) {
            actionList.addEntry(ao.getTreshold(), ao.getStringValue().split(" "));
        }
        return actionList;
    }

    @Override
    public int getInteger(String string) {
        return ((IntegerOption)this.getOptionRecursive(string)).getIntegerValue();
    }

    @Override
    public String getString(String string) {
        return ((ChildOption)this.getOptionRecursive(string)).getStringValue();
    }

    @Override
    public LogLevel getLogLevel(String string) {
        return ((LogLevelOption)this.getOptionRecursive(string)).getLogLevelValue();
    }
}

