/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.events;

import cc.co.evenprime.bukkit.nocheat.NoCheat;
import cc.co.evenprime.bukkit.nocheat.checks.moving.MovingCheck;
import cc.co.evenprime.bukkit.nocheat.config.ConfigurationManager;
import cc.co.evenprime.bukkit.nocheat.config.cache.ConfigurationCache;
import cc.co.evenprime.bukkit.nocheat.data.DataManager;
import cc.co.evenprime.bukkit.nocheat.data.MovingData;
import cc.co.evenprime.bukkit.nocheat.log.LogManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.util.Vector;

public class PlayerMoveEventManager
extends PlayerListener {
    private final MovingCheck movingCheck;
    private final ConfigurationManager config;
    private final LogManager log;
    private final DataManager data;

    public PlayerMoveEventManager(NoCheat plugin) {
        this.config = plugin.getConfigurationManager();
        this.log = plugin.getLogManager();
        this.data = plugin.getDataManager();
        this.movingCheck = new MovingCheck(plugin);
        PluginManager pm = Bukkit.getServer().getPluginManager();
        pm.registerEvent(Event.Type.PLAYER_MOVE, (Listener)this, Event.Priority.Lowest, (Plugin)plugin);
        pm.registerEvent(Event.Type.PLAYER_VELOCITY, (Listener)this, Event.Priority.Monitor, (Plugin)plugin);
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        ConfigurationCache cc = this.config.getConfigurationCacheForWorld(player.getWorld().getName());
        if (cc.moving.check && !player.hasPermission("nocheat.checks.moving.*")) {
            MovingData data = this.data.getMovingData(player);
            Location from = event.getFrom();
            Location to = event.getTo();
            Location newTo = null;
            newTo = this.movingCheck.check(player, from, to, data, cc);
            if (newTo != null) {
                Location l = new Location(newTo.getWorld(), newTo.getX(), newTo.getY(), newTo.getZ(), to.getYaw(), to.getPitch());
                event.setTo(l);
                data.teleportTo = l;
            }
        }
    }

    public void onPlayerVelocity(PlayerVelocityEvent event) {
        if (!event.isCancelled()) {
            Player player = event.getPlayer();
            MovingData mdata = this.data.getMovingData(player);
            Vector v = event.getVelocity();
            double newVal = v.getY();
            if (newVal >= 0.0) {
                mdata.vertVelocity += newVal;
                mdata.vertFreedom += mdata.vertVelocity;
                mdata.vertVelocityCounter = 50;
            }
            if ((newVal = Math.sqrt(Math.pow(v.getX(), 2.0) + Math.pow(v.getZ(), 2.0))) > 0.0) {
                mdata.horizFreedom += newVal;
                mdata.horizVelocityCounter = 30;
            }
        }
    }
}

