/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.events;

import cc.co.evenprime.bukkit.nocheat.NoCheat;
import cc.co.evenprime.bukkit.nocheat.data.DataManager;
import cc.co.evenprime.bukkit.nocheat.data.MovingData;
import cc.co.evenprime.bukkit.nocheat.log.LogManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class PlayerTeleportEventManager
extends PlayerListener {
    private final LogManager log;
    private final DataManager data;

    public PlayerTeleportEventManager(NoCheat plugin) {
        this.log = plugin.getLogManager();
        this.data = plugin.getDataManager();
        PluginManager pm = Bukkit.getServer().getPluginManager();
        pm.registerEvent(Event.Type.PLAYER_TELEPORT, (Listener)this, Event.Priority.Monitor, (Plugin)plugin);
        pm.registerEvent(Event.Type.PLAYER_PORTAL, (Listener)this, Event.Priority.Monitor, (Plugin)plugin);
        pm.registerEvent(Event.Type.PLAYER_RESPAWN, (Listener)this, Event.Priority.Monitor, (Plugin)plugin);
        pm.registerEvent(Event.Type.PLAYER_TELEPORT, (Listener)new PlayerListener(){

            public void onPlayerTeleport(PlayerTeleportEvent event) {
                MovingData data2 = PlayerTeleportEventManager.this.data.getMovingData(event.getPlayer());
                if (event.isCancelled() && data2.teleportTo != null && data2.teleportTo.equals((Object)event.getTo())) {
                    event.setCancelled(false);
                }
            }
        }, Event.Priority.Highest, (Plugin)plugin);
    }

    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (!event.isCancelled()) {
            this.handleTeleportation(event.getPlayer(), event.getTo());
        }
    }

    public void onPlayerPortal(PlayerPortalEvent event) {
        if (!event.isCancelled()) {
            this.handleTeleportation(event.getPlayer(), event.getTo());
        }
    }

    public void onPlayerRespawn(PlayerRespawnEvent event) {
        this.handleTeleportation(event.getPlayer(), event.getRespawnLocation());
    }

    private void handleTeleportation(Player player, Location newLocation) {
        MovingData data = this.data.getMovingData(player);
        data.movingsetBackPoint = null;
        data.morePacketsCounter = 0;
        data.morePacketsSetbackPoint = null;
        data.jumpPhase = 0;
        data.noclipX = newLocation.getBlockX();
        data.noclipY = Location.locToBlock((double)(newLocation.getY() + 1.1));
        data.noclipZ = newLocation.getBlockZ();
    }
}

