/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class FlatConfigParser {
    private final Map<String, Object> root = new HashMap<String, Object>();

    public void read(File file) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        LinkedList<String> lines = new LinkedList<String>();
        String line = null;
        while ((line = r.readLine()) != null) {
            lines.add(line);
        }
        r.close();
        this.parse(this.root, lines, "");
    }

    private void parse(Map<String, Object> root, LinkedList<String> lines, String prefix) throws IOException {
        String line = null;
        while (!lines.isEmpty()) {
            line = lines.getFirst();
            if (line.trim().startsWith("#")) {
                lines.removeFirst();
                continue;
            }
            if (line.trim().isEmpty()) {
                lines.removeFirst();
                continue;
            }
            lines.removeFirst();
            if (!line.contains("=")) continue;
            String[] pair = line.split("=", 2);
            FlatConfigParser.putString(pair[0].trim(), root, FlatConfigParser.removeQuotationMarks(pair[1].trim()));
        }
    }

    private static String removeQuotationMarks(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public Object getProperty(String path) {
        return FlatConfigParser.getProperty(path, this.root);
    }

    private static Object getProperty(String path, Map<String, Object> node) {
        if (node == null) {
            return null;
        }
        if (!path.contains(".")) {
            return node.get(path);
        }
        String[] parts = path.split("\\.", 2);
        return FlatConfigParser.getProperty(parts[1], (Map)node.get(parts[0]));
    }

    public String getString(String path, String defaultValue) {
        return FlatConfigParser.getString(path, defaultValue, this.root);
    }

    private static void putString(String path, Map<String, Object> node, String property) {
        String[] pathParts = path.split("\\.");
        int i = 0;
        while (i < pathParts.length) {
            if (i == pathParts.length - 1) {
                node.put((String)pathParts[i], (Object)property);
            } else if (node.containsKey(pathParts[i]) && node.get(pathParts[i]) instanceof Map) {
                node = (Map)node.get(pathParts[i]);
            } else {
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                node.put((String)pathParts[i], newMap);
                node = newMap;
            }
            ++i;
        }
    }

    private static String getString(String path, String defaultValue, Map<String, Object> node) {
        try {
            String result = (String)FlatConfigParser.getProperty(path, node);
            if (result == null) {
                return defaultValue;
            }
            return result;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

