/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Listeners;

import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.MobCheck;
import be.Balor.Tools.Type;
import be.Balor.bukkit.AdminCmd.ACHelper;
import belgium.Balor.Workers.InvisibleWorker;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityListener;
import org.bukkit.event.entity.EntityTargetEvent;

public class ACEntityListener
extends EntityListener {
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (ACHelper.getInstance().isValueSet(Type.FLY, player) && event.getCause().equals((Object)EntityDamageEvent.DamageCause.FALL)) {
            event.setCancelled(true);
            event.setDamage(0);
            return;
        }
        if (ACHelper.getInstance().hasGodPowers(player.getName())) {
            if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.FIRE) || event.getCause().equals((Object)EntityDamageEvent.DamageCause.FIRE_TICK)) {
                player.setFireTicks(0);
            }
            event.setCancelled(true);
            event.setDamage(0);
        }
    }

    public void onEntityTarget(EntityTargetEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getTarget() instanceof Player)) {
            return;
        }
        Player p = (Player)event.getTarget();
        if (InvisibleWorker.getInstance().hasInvisiblePowers(p.getName()) && PermissionManager.hasPerm((CommandSender)p, "admincmd.invisible.notatarget", false)) {
            event.setCancelled(true);
        }
    }

    public void onCreatureSpawn(CreatureSpawnEvent event) {
        Entity e = event.getEntity();
        if (!MobCheck.isMonster(e) && !MobCheck.isAnimal(e)) {
            return;
        }
        World world = e.getWorld();
        Integer limit = (Integer)ACHelper.getInstance().getValue(Type.MOB_LIMIT, world.getName());
        if (limit != null && world.getLivingEntities().size() - world.getPlayers().size() >= limit) {
            event.setCancelled(true);
        }
    }
}

