/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Listeners;

import be.Balor.Manager.ACCommand;
import be.Balor.Manager.CommandManager;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.FilesManager;
import be.Balor.Tools.ShootFireball;
import be.Balor.Tools.Type;
import be.Balor.Tools.UpdateInvisible;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.AdminCmd;
import belgium.Balor.Workers.AFKWorker;
import belgium.Balor.Workers.InvisibleWorker;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.bukkit.util.config.Configuration;

public class ACPlayerListener
extends PlayerListener {
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (ACHelper.getInstance().isValueSet(Type.BANNED, event.getPlayer().getName())) {
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, ACHelper.getInstance().getValue(Type.BANNED, event.getPlayer().getName()).toString());
            return;
        }
        if (PermissionManager.hasPerm((CommandSender)event.getPlayer(), "admincmd.player.bypass", false)) {
            event.allow();
        }
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        Player p = event.getPlayer();
        if (((Boolean)ACHelper.getInstance().getConfValue("autoAfk")).booleanValue()) {
            AFKWorker.getInstance().updateTimeStamp(p);
            if (AFKWorker.getInstance().isAfk(p)) {
                AFKWorker.getInstance().setOnline(p);
            }
        }
        if (ACHelper.getInstance().isValueSet(Type.FROZEN, p)) {
            event.setCancelled(true);
            return;
        }
        Float power = (Float)ACHelper.getInstance().getValue(Type.FLY, p.getName());
        if (power != null) {
            if (p.isSneaking()) {
                p.setVelocity(p.getLocation().getDirection().multiply(power.floatValue()));
            } else if (((Boolean)ACHelper.getInstance().getConfValue("glideWhenFallingInFlyMode")).booleanValue()) {
                Vector vel = p.getVelocity();
                vel.add(p.getLocation().getDirection().multiply(ACHelper.getInstance().getFloat("glinding.multiplicator").floatValue()).setY(0));
                if (vel.getY() < (double)ACHelper.getInstance().getFloat("glinding.YvelocityCheckToGlide").floatValue()) {
                    vel.setY(ACHelper.getInstance().getFloat("glinding.newYvelocity").floatValue());
                    p.setVelocity(vel);
                }
            }
        }
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        Configuration conf;
        Player p = event.getPlayer();
        Utils.sParsedLocale(p, "MOTD");
        Utils.sParsedLocale(p, "NEWS");
        if (this.playerRespawnOrJoin(event.getPlayer())) {
            event.setJoinMessage(null);
            Utils.sI18n((CommandSender)event.getPlayer(), "stillInv");
        }
        if ((conf = FilesManager.getInstance().getYml(p.getName(), "home")).getBoolean("infos.firstTime", true)) {
            conf.setProperty("infos.firstTime", (Object)false);
            conf.save();
            if (((Boolean)ACHelper.getInstance().getConfValue("firstConnectionToSpawnPoint")).booleanValue()) {
                ACHelper.getInstance().spawn((CommandSender)p);
            }
        }
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        Player p = event.getPlayer();
        if (InvisibleWorker.getInstance().hasInvisiblePowers(p.getName())) {
            event.setQuitMessage(null);
        }
        if (((Boolean)ACHelper.getInstance().getConfValue("autoAfk")).booleanValue()) {
            AFKWorker.getInstance().removePlayer(p);
        }
    }

    public void onPlayerRespawn(PlayerRespawnEvent event) {
        this.playerRespawnOrJoin(event.getPlayer());
    }

    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Location from = event.getFrom();
        Location to = event.getTo();
        String playername = event.getPlayer().getName();
        if (ACHelper.getInstance().isValueSet(Type.FROZEN, playername)) {
            event.setCancelled(true);
            return;
        }
        if (((Boolean)ACHelper.getInstance().getConfValue("resetPowerWhenTpAnotherWorld")).booleanValue() && !from.getWorld().equals(to.getWorld()) && !PermissionManager.hasPerm((CommandSender)event.getPlayer(), "admincmd.player.noreset", false)) {
            if (ACHelper.getInstance().removeKeyFromValues(playername) || InvisibleWorker.getInstance().hasInvisiblePowers(playername)) {
                InvisibleWorker.getInstance().reappear(event.getPlayer());
                Utils.sI18n((CommandSender)event.getPlayer(), "changedWorld");
            }
        } else {
            this.playerRespawnOrJoin(event.getPlayer());
        }
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        Player p = event.getPlayer();
        if (((Boolean)ACHelper.getInstance().getConfValue("autoAfk")).booleanValue()) {
            AFKWorker.getInstance().updateTimeStamp(p);
            if (AFKWorker.getInstance().isAfk(p)) {
                AFKWorker.getInstance().setOnline(p);
            }
        }
        if (ACHelper.getInstance().isValueSet(Type.FROZEN, p)) {
            event.setCancelled(true);
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_BLOCK || event.getAction() == Action.LEFT_CLICK_AIR) {
            String playerName = p.getName();
            if (ACHelper.getInstance().hasThorPowers(playerName)) {
                p.getWorld().strikeLightning(p.getTargetBlock(null, 600).getLocation());
            }
            Float power = null;
            power = ACHelper.getInstance().getVulcainExplosionPower(playerName);
            if (power != null) {
                p.getWorld().createExplosion(p.getTargetBlock(null, 600).getLocation(), power.floatValue(), true);
            }
            power = null;
            power = (Float)ACHelper.getInstance().getValue(Type.FIREBALL, playerName);
            if (power != null) {
                ShootFireball.shoot(p, power);
            }
            if (ACHelper.getInstance().isValueSet(Type.TP_AT_SEE, playerName)) {
                try {
                    Block toTp = p.getWorld().getBlockAt(p.getTargetBlock(null, ((Integer)ACHelper.getInstance().getConfValue("maxRangeForTpAtSee")).intValue()).getLocation().add(0.0, 1.0, 0.0));
                    if (toTp.getTypeId() == 0) {
                        Location loc = toTp.getLocation().clone();
                        loc.setPitch(p.getLocation().getPitch());
                        loc.setYaw(p.getLocation().getYaw());
                        p.teleport(loc);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private boolean playerRespawnOrJoin(Player newPlayer) {
        AdminCmd.getBukkitServer().getScheduler().scheduleAsyncDelayedTask((Plugin)ACHelper.getInstance().getPluginInstance(), (Runnable)new UpdateInvisibleOnJoin(newPlayer), 25L);
        if (InvisibleWorker.getInstance().hasInvisiblePowers(newPlayer.getName())) {
            AdminCmd.getBukkitServer().getScheduler().scheduleAsyncDelayedTask((Plugin)ACHelper.getInstance().getPluginInstance(), (Runnable)new UpdateInvisible(newPlayer), 25L);
            return true;
        }
        return false;
    }

    public void onPlayerChat(PlayerChatEvent event) {
        Player p = event.getPlayer();
        if (((Boolean)ACHelper.getInstance().getConfValue("autoAfk")).booleanValue()) {
            AFKWorker.getInstance().updateTimeStamp(p);
            if (AFKWorker.getInstance().isAfk(p)) {
                AFKWorker.getInstance().setOnline(p);
            }
        }
        if (ACHelper.getInstance().isValueSet(Type.MUTED, p)) {
            event.setCancelled(true);
            Utils.sI18n((CommandSender)p, "muteEnabled");
        }
    }

    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        if (ACHelper.getInstance().isValueSet(Type.NO_PICKUP, event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String[] split = event.getMessage().split("\\s+");
        if (split.length == 0) {
            return;
        }
        String cmdName = split[0].substring(1).toLowerCase();
        ACCommand cmd = CommandManager.getInstance().getCommand(cmdName);
        if (cmd != null) {
            event.setCancelled(true);
            System.out.print("[AdminCmd] Command " + cmdName + " intercepted.");
            CommandManager.getInstance().executeCommand((CommandSender)event.getPlayer(), cmd, Utils.Arrays_copyOfRange(split, 1, split.length));
            event.setMessage("/AdminCmd took the control");
        }
    }

    protected class UpdateInvisibleOnJoin
    implements Runnable {
        Player newPlayer;

        public UpdateInvisibleOnJoin(Player p) {
            this.newPlayer = p;
        }

        @Override
        public void run() {
            for (Player toVanish : InvisibleWorker.getInstance().getAllInvisiblePlayers()) {
                InvisibleWorker.getInstance().invisible(toVanish, this.newPlayer);
            }
        }
    }
}

