/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager;

import be.Balor.Manager.Exceptions.CommandAlreadyExist;
import be.Balor.Manager.Exceptions.CommandNotFound;
import be.Balor.Manager.Permissions.PermissionManager;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class ACCommand {
    protected String permNode = "";
    protected String cmdName = "";
    protected Permission bukkitPerm = null;
    protected PermissionDefault bukkitDefault = PermissionDefault.OP;
    protected boolean other = false;
    protected PluginCommand pluginCommand;

    public abstract void execute(CommandSender var1, String ... var2);

    public abstract boolean argsCheck(String ... var1);

    public boolean permissionCheck(CommandSender sender) {
        return PermissionManager.hasPerm(sender, this.bukkitPerm);
    }

    public String getCmdName() {
        return this.cmdName;
    }

    public String getPermNode() {
        return this.permNode;
    }

    public void registerBukkitPerm() {
        this.bukkitPerm = PermissionManager.getInstance().addPermChild(this.permNode, this.bukkitDefault);
        if (this.other) {
            PermissionManager.getInstance().addPermChild(this.permNode + ".other", this.bukkitDefault);
        }
    }

    public boolean toOther() {
        return this.other;
    }

    public void initializeCommand(JavaPlugin plugin) throws CommandNotFound, CommandAlreadyExist {
        this.pluginCommand = plugin.getCommand(this.cmdName);
        if (this.pluginCommand == null) {
            throw new CommandNotFound(this.cmdName + " is not loaded in bukkit. Command deactivated");
        }
        if (this.pluginCommand.getAliases().isEmpty()) {
            throw new CommandAlreadyExist(this.cmdName + " has all his alias already registered. Command deactivated");
        }
    }

    public PluginCommand getPluginCommand() {
        return this.pluginCommand;
    }
}

