/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools;

import au.com.bytecode.opencsv.CSVReader;
import be.Balor.Tools.MaterialContainer;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.AdminCmd;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.util.config.Configuration;
import org.bukkit.util.config.ConfigurationNode;

public class FilesManager {
    protected File pathFile;
    private static FilesManager instance = null;

    public static FilesManager getInstance() {
        if (instance == null) {
            instance = new FilesManager();
        }
        return instance;
    }

    public void setPath(String path) {
        File spawn;
        this.pathFile = new File(path);
        if (!this.pathFile.exists()) {
            this.pathFile.mkdir();
        }
        if ((spawn = this.getFile(null, "spawnLocations.yml", false)).exists()) {
            File dir = new File(this.pathFile, "spawn");
            dir.mkdir();
            spawn.renameTo(new File(dir, "spawnLocations.yml.old"));
        }
    }

    public Configuration getYml(String filename, String directory) {
        Configuration config = new Configuration(this.getFile(directory, filename + ".yml"));
        config.load();
        return config;
    }

    public Configuration getYml(String filename) {
        return this.getYml(filename, null);
    }

    public File getFile(String directory, String filename) {
        return this.getFile(directory, filename, true);
    }

    private File getFile(String directory, String filename, boolean create) {
        File file = null;
        if (directory != null) {
            File directoryFile = new File(this.pathFile, directory);
            if (!directoryFile.exists()) {
                directoryFile.mkdir();
            }
            file = new File(directoryFile, filename);
        } else {
            file = new File(this.pathFile, filename);
        }
        if (!file.exists() && create) {
            try {
                file.createNewFile();
            }
            catch (IOException ex) {
                System.out.println("cannot create file " + file.getPath());
            }
        }
        return file;
    }

    public void addAlias(String alias, MaterialContainer mc) {
        Configuration conf = this.getYml("Alias");
        ArrayList aliasList = (ArrayList)conf.getStringList("alias", new ArrayList());
        ArrayList idList = (ArrayList)conf.getStringList("ids", new ArrayList());
        if (aliasList.contains(alias)) {
            int index = aliasList.indexOf(alias);
            aliasList.remove(index);
            idList.remove(index);
        }
        aliasList.add(alias);
        idList.add(mc.toString());
        conf.setProperty("alias", (Object)aliasList);
        conf.setProperty("ids", (Object)idList);
        conf.save();
    }

    public void removeAlias(String alias) {
        Configuration conf = this.getYml("Alias");
        ArrayList aliasList = (ArrayList)conf.getStringList("alias", new ArrayList());
        ArrayList idList = (ArrayList)conf.getStringList("ids", new ArrayList());
        int index = aliasList.indexOf(alias);
        aliasList.remove(index);
        idList.remove(index);
        conf.setProperty("alias", (Object)aliasList);
        conf.setProperty("ids", (Object)idList);
        conf.save();
    }

    public File getInnerFile(String filename) {
        return this.getInnerFile(filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getInnerFile(String filename, String directory) {
        File file;
        if (directory != null) {
            File directoryFile = new File(this.pathFile, directory);
            if (!directoryFile.exists()) {
                directoryFile.mkdir();
            }
            file = new File(directoryFile, filename);
        } else {
            file = new File(this.pathFile, filename);
        }
        if (!file.exists()) {
            InputStream res = this.getClass().getResourceAsStream("/" + filename);
            FileWriter tx = null;
            try {
                tx = new FileWriter(file);
                int i = 0;
                while ((i = res.read()) > 0) {
                    tx.write(i);
                }
                tx.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                File file2 = file;
                return file2;
            }
            finally {
                try {
                    res.close();
                }
                catch (Exception ex) {}
                try {
                    if (tx != null) {
                        tx.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        return file;
    }

    public HashMap<String, MaterialContainer> getAlias() {
        HashMap<String, MaterialContainer> result = new HashMap<String, MaterialContainer>();
        Configuration conf = this.getYml("Alias");
        ArrayList aliasList = (ArrayList)conf.getStringList("alias", new ArrayList());
        ArrayList idList = (ArrayList)conf.getStringList("ids", new ArrayList());
        int i = 0;
        try {
            Object alias;
            CSVReader csv = new CSVReader(new FileReader(this.getInnerFile("items.csv")));
            while ((alias = csv.readNext()) != null) {
                try {
                    result.put(alias[0], new MaterialContainer(alias[1], alias[2]));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    result.put(alias[0], new MaterialContainer(alias[1]));
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Object alias : aliasList) {
            result.put((String)alias, new MaterialContainer((String)idList.get(i)));
            ++i;
        }
        return result;
    }

    public void writeLocationFile(Location loc, String name, String filename, String directory) {
        Configuration conf = this.getYml(filename, directory);
        conf.setProperty(directory + "." + name + ".world", (Object)loc.getWorld().getName());
        conf.setProperty(directory + "." + name + ".x", (Object)loc.getX());
        conf.setProperty(directory + "." + name + ".y", (Object)loc.getY());
        conf.setProperty(directory + "." + name + ".z", (Object)loc.getZ());
        conf.setProperty(directory + "." + name + ".yaw", (Object)Float.valueOf(loc.getYaw()));
        conf.setProperty(directory + "." + name + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        conf.save();
    }

    public Location getLocationFile(String property, String filename, String directory) {
        Configuration conf = this.getYml(filename, directory);
        if (conf.getProperty(directory + "." + property + ".world") == null) {
            return this.parseLocation(property, conf, directory);
        }
        return new Location(AdminCmd.getBukkitServer().getWorld(conf.getString(directory + "." + property + ".world")), conf.getDouble(directory + "." + property + ".x", 0.0), conf.getDouble(directory + "." + property + ".y", 0.0), conf.getDouble(directory + "." + property + ".z", 0.0), Float.parseFloat(conf.getString(directory + "." + property + ".yaw")), Float.parseFloat(conf.getString(directory + "." + property + ".pitch")));
    }

    public void removeLocationFromFile(String property, String filename, String directory) {
        Configuration conf = this.getYml(filename, directory);
        conf.removeProperty(directory + "." + property);
        conf.save();
    }

    public List<String> getYmlKeyFromFile(String filename, String directory) {
        return this.getYml(filename, directory).getKeys(directory);
    }

    private Location parseLocation(String property, Configuration conf, String parentProperty) {
        int i;
        String toParse = conf.getString(parentProperty + "." + property, null);
        if (toParse == null) {
            return null;
        }
        if (toParse.isEmpty()) {
            return null;
        }
        String[] infos = new String[5];
        Double[] coords = new Double[3];
        Float[] direction = new Float[2];
        infos = toParse.split(";");
        for (i = 0; i < coords.length; ++i) {
            try {
                coords[i] = Double.parseDouble(infos[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        for (i = 3; i < infos.length - 1; ++i) {
            try {
                direction[i - 3] = Float.valueOf(Float.parseFloat(infos[i]));
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return new Location(AdminCmd.getBukkitServer().getWorld(infos[5]), coords[0].doubleValue(), coords[1].doubleValue(), coords[2].doubleValue(), direction[0].floatValue(), direction[1].floatValue());
    }

    public Map<String, Object> loadMap(Type type, String directory, String filename) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Configuration conf = this.getYml(filename, directory);
        if (conf.getKeys(type.toString()) != null) {
            for (String key : conf.getKeys(type.toString())) {
                result.put(key, conf.getProperty((Object)((Object)type) + "." + key));
            }
        }
        return result;
    }

    public Map<String, List<MaterialContainer>> loadKits() {
        HashMap<String, List<MaterialContainer>> result = new HashMap<String, List<MaterialContainer>>();
        ArrayList<MaterialContainer> items = new ArrayList<MaterialContainer>();
        Configuration conf = this.getYml("kits");
        if (conf.getKeys("kits") != null) {
            ConfigurationNode nodes = conf.getNode("kits");
            for (String key : nodes.getKeys()) {
                ConfigurationNode itemsNode = nodes.getNode(key);
                for (String item : itemsNode.getKeys()) {
                    MaterialContainer m = Utils.checkMaterial(item);
                    m.setAmount(itemsNode.getInt(item, 1));
                    if (m.isNull()) continue;
                    items.add(m);
                }
                result.put(key, new ArrayList(items));
                items.clear();
            }
        }
        return result;
    }
}

