/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.Channel;
import com.herocraftonline.dthielke.herochat.channels.ChannelManager;
import com.herocraftonline.dthielke.herochat.channels.ConversationManager;
import com.herocraftonline.dthielke.herochat.util.Messaging;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerQuitEvent;

public class HeroChatPlayerListener
extends PlayerListener {
    private HeroChat plugin;

    public HeroChatPlayerListener(HeroChat plugin) {
        this.plugin = plugin;
    }

    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String input = event.getMessage().substring(1);
        String[] args = input.split(" ");
        Channel c = this.plugin.getChannelManager().getChannel(args[0]);
        if (c != null && c.isQuickMessagable()) {
            event.setCancelled(true);
            this.plugin.getCommandManager().dispatch((CommandSender)event.getPlayer(), null, "qm", args);
        }
    }

    public void onPlayerChat(PlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player sender = event.getPlayer();
        String senderName = sender.getName();
        ConversationManager convos = this.plugin.getConversationManager();
        if (convos.hasActive(sender)) {
            Player receiver = convos.getTellee(sender);
            String receiverName = receiver.getName();
            if (!this.plugin.getChannelManager().isIgnoring(receiverName, senderName)) {
                String message = event.getMessage();
                String outgoing = Messaging.format(this.plugin, null, this.plugin.getOutgoingTellFormat(), senderName, receiverName, message, true, this.plugin.getPermissionManager().isAllowedColor(sender));
                String incoming = Messaging.format(this.plugin, null, this.plugin.getIncomingTellFormat(), senderName, receiverName, message, true, this.plugin.getPermissionManager().isAllowedColor(sender));
                receiver.sendMessage(incoming);
                sender.sendMessage(outgoing);
                this.plugin.log(Level.INFO, String.valueOf(senderName) + " -> " + receiverName + ": " + message);
            } else {
                sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7c" + receiverName + " is ignoring you");
            }
        } else {
            ChannelManager cm = this.plugin.getChannelManager();
            Channel c = cm.getActiveChannel(senderName);
            if (c != null) {
                if (!c.getPlayers().contains(senderName)) {
                    c.addPlayer(senderName);
                }
                c.sendMessage(senderName, event.getMessage());
            }
        }
        event.setCancelled(true);
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        Player joiner = event.getPlayer();
        String name = joiner.getName();
        try {
            this.plugin.getConfigManager().loadPlayer(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        Player quitter = event.getPlayer();
        String quitterName = quitter.getName();
        this.plugin.getConfigManager().savePlayer(quitterName);
        this.plugin.getChannelManager().removeFromAll(quitterName);
        this.plugin.getChannelManager().setActiveChannel(quitterName, null);
        ConversationManager convos = this.plugin.getConversationManager();
        if (convos.hasActive(quitter)) {
            Player tellee = convos.getTellee(quitter);
            if (convos.isActive(tellee, quitter)) {
                convos.end(tellee);
                tellee.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cEnded your conversation (Player logged out)");
            }
            convos.end(quitter);
        }
    }
}

