/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.command.commands;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.Channel;
import com.herocraftonline.dthielke.herochat.channels.ChannelManager;
import com.herocraftonline.dthielke.herochat.command.BaseCommand;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BanCommand
extends BaseCommand {
    public BanCommand(HeroChat plugin) {
        super(plugin);
        this.name = "Ban";
        this.description = "Bans a player from a channel";
        this.usage = "\u00a7e/ch ban \u00a79<channel> <player>";
        this.minArgs = 1;
        this.maxArgs = 2;
        this.identifiers.add("ch ban");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        ChannelManager cm = this.plugin.getChannelManager();
        Channel channel = cm.getChannel(args[0]);
        if (channel != null) {
            if (args.length == 1) {
                this.displayBanList(sender, channel);
            } else if (sender instanceof Player) {
                Player banner = (Player)sender;
                if (this.plugin.getPermissionManager().isAdmin(banner) || channel.getModerators().contains(banner.getName())) {
                    Player banee = this.plugin.getServer().getPlayer(args[1]);
                    if (banee != null) {
                        String name = banee.getName();
                        if (!this.plugin.getPermissionManager().isAdmin(banee) && !channel.getModerators().contains(name)) {
                            if (channel.getBlacklist().contains(name)) {
                                channel.getBlacklist().remove(name);
                                banner.sendMessage(String.valueOf(this.plugin.getTag()) + name + "\u00a7c has been unbanned from " + channel.getCName());
                                banee.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou have been unbanned from " + channel.getCName());
                            } else {
                                channel.getBlacklist().add(name);
                                channel.removePlayer(name);
                                banner.sendMessage(String.valueOf(this.plugin.getTag()) + name + "\u00a7c has been banned from " + channel.getCName());
                                banee.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou have been banned from " + channel.getCName());
                                if (cm.getActiveChannel(name).equals(channel)) {
                                    List<Channel> joined = cm.getJoinedChannels(name);
                                    cm.setActiveChannel(name, joined.get(0).getName());
                                    banee.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cSet active channel to " + cm.getActiveChannel(name).getCName());
                                }
                            }
                        } else {
                            banner.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou cannot ban " + name + " from " + channel.getCName());
                        }
                    } else {
                        banner.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cPlayer not found");
                    }
                } else {
                    banner.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou do not have sufficient permission");
                }
            } else {
                sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou must be a player to use this command");
            }
        } else {
            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cChannel not found");
        }
    }

    private void displayBanList(CommandSender sender, Channel channel) {
        String banListMsg;
        List<String> bans = channel.getBlacklist();
        if (bans.isEmpty()) {
            banListMsg = String.valueOf(this.plugin.getTag()) + "\u00a7cNo one is currently banned from " + channel.getCName();
        } else {
            banListMsg = "Currently banned from " + channel.getCName() + "\u00a7f: ";
            for (String s : bans) {
                banListMsg = String.valueOf(banListMsg) + s + ",";
            }
            banListMsg = banListMsg.substring(0, banListMsg.length() - 1);
        }
        sender.sendMessage(banListMsg);
    }
}

