/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.command.commands;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.Channel;
import com.herocraftonline.dthielke.herochat.channels.ChannelManager;
import com.herocraftonline.dthielke.herochat.channels.ConversationManager;
import com.herocraftonline.dthielke.herochat.command.BaseCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FocusCommand
extends BaseCommand {
    public FocusCommand(HeroChat plugin) {
        super(plugin);
        this.name = "Focus";
        this.description = "Directs all future messages to a channel";
        this.usage = "\u00a7e/ch \u00a79<channel> \u00a78[pass]";
        this.minArgs = 1;
        this.maxArgs = 2;
        this.identifiers.add("ch");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            String name = player.getName();
            ChannelManager cm = this.plugin.getChannelManager();
            Channel c = cm.getChannel(args[0]);
            if (c != null) {
                if (!c.getBlacklist().contains(name)) {
                    ConversationManager convos;
                    if (!c.getWhitelist().isEmpty()) {
                        String group = this.plugin.getPermissionManager().getGroup(player);
                        if (!c.getWhitelist().contains(group) && !group.isEmpty()) {
                            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou cannot join this channel");
                            return;
                        }
                    }
                    if (!c.getPlayers().contains(name)) {
                        String password = c.getPassword();
                        if (password.isEmpty() || args.length == 2 && args[1].equals(password) || this.plugin.getPermissionManager().isAdmin(player)) {
                            c.addPlayer(name);
                            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cJoined channel " + c.getCName());
                        } else {
                            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cWrong password for " + c.getCName());
                            return;
                        }
                    }
                    if ((convos = this.plugin.getConversationManager()).hasActive(player)) {
                        convos.end(player);
                        sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cEnded your conversation");
                    }
                    cm.setActiveChannel(name, c.getName());
                    sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cSet focus on " + c.getCName());
                } else {
                    sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou are banned from " + c.getCName());
                }
            } else {
                sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cChannel not found");
            }
        } else {
            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou must be a player to use this command");
        }
    }
}

