/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.command.commands;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.ChannelManager;
import com.herocraftonline.dthielke.herochat.command.BaseCommand;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GMuteCommand
extends BaseCommand {
    public GMuteCommand(HeroChat plugin) {
        super(plugin);
        this.name = "Global Mute";
        this.description = "Prevents a player from speaking in any channel";
        this.usage = "\u00a7e/ch gmute \u00a78[player] \u00a7eOR /gmute \u00a78[player]";
        this.minArgs = 0;
        this.maxArgs = 1;
        this.identifiers.add("ch gmute");
        this.identifiers.add("gmute");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        ChannelManager cm = this.plugin.getChannelManager();
        if (args.length == 0) {
            this.displayMuteList(sender);
        } else if (sender instanceof Player) {
            Player muter = (Player)sender;
            if (this.plugin.getPermissionManager().isAdmin(muter)) {
                Player mutee = this.plugin.getServer().getPlayer(args[0]);
                if (mutee != null) {
                    String name = mutee.getName();
                    if (!this.plugin.getPermissionManager().isAdmin(mutee)) {
                        if (cm.getMutelist().contains(name)) {
                            cm.getMutelist().remove(name);
                            muter.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7c" + name + " has been globally unmuted");
                            mutee.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou have been globally unmuted");
                        } else {
                            cm.getMutelist().add(name);
                            muter.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7c" + name + " has been globally muted");
                            mutee.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou have been globally muted");
                        }
                    } else {
                        muter.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou cannot globally mute " + name);
                    }
                } else {
                    muter.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cPlayer not found");
                }
            } else {
                muter.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou do not have sufficient permission");
            }
        } else {
            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou must be a player to use this command");
        }
    }

    private void displayMuteList(CommandSender sender) {
        String muteListMsg;
        List<String> mutes = this.plugin.getChannelManager().getMutelist();
        if (mutes.isEmpty()) {
            muteListMsg = String.valueOf(this.plugin.getTag()) + "\u00a7cNo one is currently muted";
        } else {
            muteListMsg = "Currently muted: ";
            for (String s : mutes) {
                muteListMsg = String.valueOf(muteListMsg) + s + ",";
            }
            muteListMsg = muteListMsg.substring(0, muteListMsg.length() - 1);
        }
        sender.sendMessage(muteListMsg);
    }
}

