/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.command.commands;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.command.BaseCommand;
import java.util.List;
import org.bukkit.command.CommandSender;

public class HelpCommand
extends BaseCommand {
    private static final int CMDS_PER_PAGE = 8;

    public HelpCommand(HeroChat plugin) {
        super(plugin);
        this.name = "Help";
        this.description = "Displays the help menu";
        this.usage = "\u00a7e/ch help \u00a78[page#]";
        this.minArgs = 0;
        this.maxArgs = 1;
        this.identifiers.add("ch help");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        int page = 0;
        if (args.length != 0) {
            try {
                page = Integer.parseInt(args[0]) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        List<BaseCommand> commands = this.plugin.getCommandManager().getCommands();
        int numPages = commands.size() / 8;
        if (commands.size() % 8 != 0) {
            ++numPages;
        }
        if (page >= numPages || page < 0) {
            page = 0;
        }
        sender.sendMessage("\u00a7c-----[ \u00a7f" + this.plugin.getTag().replace("[", "").replace("]", "") + "Help <" + (page + 1) + "/" + numPages + ">\u00a7c ]-----");
        int start = page * 8;
        int end = start + 8;
        if (end > commands.size()) {
            end = commands.size();
        }
        int c = start;
        while (c < end) {
            BaseCommand cmd = commands.get(c);
            sender.sendMessage("  \u00a7a" + cmd.getUsage());
            ++c;
        }
        sender.sendMessage("\u00a7cFor more info on a particular command, type '/<command> ?'");
    }
}

