/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.command.commands;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.ChannelManager;
import com.herocraftonline.dthielke.herochat.command.BaseCommand;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class IgnoreCommand
extends BaseCommand {
    public IgnoreCommand(HeroChat plugin) {
        super(plugin);
        this.name = "Ignore";
        this.description = "Ignores all messages from a player";
        this.usage = "\u00a7e/ch ignore \u00a78[player] \u00a7eOR /ignore \u00a78[player]";
        this.minArgs = 0;
        this.maxArgs = 1;
        this.identifiers.add("ch ignore");
        this.identifiers.add("ignore");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player ignorer = (Player)sender;
            if (args.length == 0) {
                this.displayIgnoreList(ignorer, this.plugin.getChannelManager().getIgnoreList(ignorer.getName()));
            } else {
                Player ignoree = this.plugin.getServer().getPlayer(args[0]);
                if (ignoree != null) {
                    this.toggleIgnore(ignorer, ignoree);
                } else {
                    sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cPlayer not found");
                }
            }
        } else {
            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou must be a player to use this command");
        }
    }

    private void displayIgnoreList(Player player, List<String> ignoreList) {
        String ignoreListMsg;
        if (ignoreList.isEmpty()) {
            ignoreListMsg = String.valueOf(this.plugin.getTag()) + "\u00a7cCurrently ignoring no one.";
        } else {
            ignoreListMsg = "Currently ignoring: ";
            for (String s : ignoreList) {
                ignoreListMsg = String.valueOf(ignoreListMsg) + s + ",";
            }
            ignoreListMsg = ignoreListMsg.substring(0, ignoreListMsg.length() - 1);
        }
        player.sendMessage(ignoreListMsg);
    }

    private void toggleIgnore(Player ignorer, Player ignoree) {
        if (this.plugin.getPermissionManager().isAdmin(ignoree)) {
            ignorer.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou can't ignore admins");
            return;
        }
        if (ignorer.getName().equals(ignoree.getName())) {
            ignorer.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou cannot ignore yourself");
            return;
        }
        ChannelManager cm = this.plugin.getChannelManager();
        if (cm.isIgnoring(ignorer.getName(), ignoree.getName())) {
            cm.removeIgnore(ignorer.getName(), ignoree.getName());
            ignorer.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cNo longer ignoring " + ignoree.getName());
        } else {
            cm.addIgnore(ignorer.getName(), ignoree.getName());
            ignorer.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cNow ignoring " + ignoree.getName());
        }
    }
}

