/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.command.commands;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.Channel;
import com.herocraftonline.dthielke.herochat.channels.ChannelManager;
import com.herocraftonline.dthielke.herochat.command.BaseCommand;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MuteCommand
extends BaseCommand {
    public MuteCommand(HeroChat plugin) {
        super(plugin);
        this.name = "Mute";
        this.description = "Prevents a player from speaking in a channel";
        this.usage = "\u00a7e/ch mute \u00a79<channel> \u00a78[player] \u00a7eOR /mute \u00a79<channel> \u00a78[player]";
        this.minArgs = 1;
        this.maxArgs = 2;
        this.identifiers.add("ch mute");
        this.identifiers.add("mute");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        ChannelManager cm = this.plugin.getChannelManager();
        Channel channel = cm.getChannel(args[0]);
        if (channel != null) {
            if (args.length == 1) {
                this.displayMuteList(sender, channel);
            } else if (sender instanceof Player) {
                Player muter = (Player)sender;
                if (this.plugin.getPermissionManager().isAdmin(muter) || channel.getModerators().contains(muter.getName())) {
                    Player mutee = this.plugin.getServer().getPlayer(args[1]);
                    if (mutee != null) {
                        String name = mutee.getName();
                        if (!this.plugin.getPermissionManager().isAdmin(mutee) && !channel.getModerators().contains(name)) {
                            if (channel.getMutelist().contains(name)) {
                                channel.getMutelist().remove(name);
                                muter.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7c" + name + " has been unmuted in " + channel.getCName());
                                mutee.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou have been unmuted in " + channel.getCName());
                            } else {
                                channel.getMutelist().add(name);
                                muter.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7c" + name + " has been muted in " + channel.getCName());
                                mutee.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou have been muted in " + channel.getCName());
                            }
                        } else {
                            muter.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou cannot mute " + name + " in " + channel.getCName());
                        }
                    } else {
                        muter.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cPlayer not found");
                    }
                } else {
                    muter.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou do not have sufficient permission");
                }
            } else {
                sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou must be a player to use this command");
            }
        } else {
            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cChannel not found");
        }
    }

    private void displayMuteList(CommandSender sender, Channel channel) {
        String muteListMsg;
        List<String> mutes = channel.getMutelist();
        if (mutes.isEmpty()) {
            muteListMsg = String.valueOf(this.plugin.getTag()) + "\u00a7cNo one is currently muted in " + channel.getCName();
        } else {
            muteListMsg = "\u00a7cCurrently muted in " + channel.getCName() + "\u00a7f: ";
            for (String s : mutes) {
                muteListMsg = String.valueOf(muteListMsg) + s + ",";
            }
            muteListMsg = muteListMsg.substring(0, muteListMsg.length() - 1);
        }
        sender.sendMessage(muteListMsg);
    }
}

