/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.command.commands;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.Channel;
import com.herocraftonline.dthielke.herochat.channels.ChannelManager;
import com.herocraftonline.dthielke.herochat.command.BaseCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ToggleCommand
extends BaseCommand {
    private boolean allEnabled = true;

    public ToggleCommand(HeroChat plugin) {
        super(plugin);
        this.name = "Toggle";
        this.description = "Temporarily enables or disables a channel";
        this.usage = "\u00a7e/ch toggle \u00a78[channel]";
        this.minArgs = 0;
        this.maxArgs = 1;
        this.identifiers.add("ch toggle");
        this.notes.add("\u00a7cNote: \u00a7eIf no channel is provided, all channels are toggled");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        ChannelManager cm = this.plugin.getChannelManager();
        if (args.length == 0) {
            if (sender instanceof Player) {
                Player muter = (Player)sender;
                if (muter == null || this.plugin.getPermissionManager().isAdmin(muter)) {
                    if (this.allEnabled) {
                        for (Channel c : cm.getChannels()) {
                            c.setEnabled(false);
                        }
                        this.allEnabled = false;
                        sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cDisabled all channels");
                    } else {
                        for (Channel c : cm.getChannels()) {
                            c.setEnabled(true);
                        }
                        this.allEnabled = true;
                        sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cEnabled all channels");
                    }
                } else {
                    muter.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou do not have sufficient permission");
                }
            } else {
                sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou must be a player to use this command");
            }
        } else {
            Channel channel = cm.getChannel(args[0]);
            if (channel != null) {
                if (sender instanceof Player) {
                    Player muter = (Player)sender;
                    if (muter == null || this.plugin.getPermissionManager().isAdmin(muter) || channel.getModerators().contains(muter.getName())) {
                        if (channel.isEnabled()) {
                            channel.setEnabled(false);
                            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cDisabled " + channel.getCName());
                        } else {
                            channel.setEnabled(true);
                            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cEnabled " + channel.getCName());
                        }
                    } else {
                        muter.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou do not have sufficient permission");
                    }
                } else {
                    sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou must be a player to use this command");
                }
            } else {
                sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cChannel not found");
            }
        }
    }
}

