/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.util;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.Channel;
import com.herocraftonline.dthielke.herochat.channels.ChannelManager;
import com.herocraftonline.dthielke.herochat.channels.LocalChannel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.util.config.Configuration;

public class ConfigManager {
    protected HeroChat plugin;
    protected File primaryConfigFile;
    protected File usersConfigFolder;

    public ConfigManager(HeroChat plugin) {
        this.plugin = plugin;
        this.primaryConfigFile = new File(plugin.getDataFolder(), "config.yml");
        this.usersConfigFolder = new File(plugin.getDataFolder(), "users/");
        this.usersConfigFolder.mkdirs();
    }

    public void reload() throws Exception {
        this.load();
    }

    public void load() throws Exception {
        this.checkConfig();
        Configuration config = new Configuration(this.primaryConfigFile);
        config.load();
        this.loadChannels(config);
        this.loadGlobals(config);
    }

    private void checkConfig() {
        if (!this.primaryConfigFile.exists()) {
            try {
                int length;
                this.primaryConfigFile.getParentFile().mkdir();
                this.primaryConfigFile.createNewFile();
                FileOutputStream output = new FileOutputStream(this.primaryConfigFile, false);
                InputStream input = ConfigManager.class.getResourceAsStream("config.yml");
                byte[] buf = new byte[8192];
                while ((length = input.read(buf)) >= 0) {
                    ((OutputStream)output).write(buf, 0, length);
                }
                input.close();
                ((OutputStream)output).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadGlobals(Configuration config) {
        String globals = "globals.";
        ChannelManager cm = this.plugin.getChannelManager();
        String pluginTag = config.getString(String.valueOf(globals) + "plugin-tag", "[HeroChat] ").replace("&", "\u00a7");
        String ircTag = config.getString(String.valueOf(globals) + "craftIRC-prefix", "#");
        String ircMessageFormat = config.getString(String.valueOf(globals) + "craftIRC-message-format", "[{nick}] {player}: ");
        String defaultChannel = config.getString(String.valueOf(globals) + "default-channel", cm.getChannels().get(0).getName());
        String defaultMsgFormat = config.getString(String.valueOf(globals) + "default-message-format", "{player}: ");
        String incomingTellFormat = config.getString(String.valueOf(globals) + "incoming-tell-format", "{prefix}{player} &8->&d ");
        String outgoingTellFormat = config.getString(String.valueOf(globals) + "outgoing-tell-format", "{prefix}{player} &8->&d ");
        List censors = config.getStringList(String.valueOf(globals) + "censors", null);
        boolean separateChatLog = config.getBoolean(String.valueOf(globals) + "separate-chat-log", false);
        this.plugin.setTag(pluginTag);
        this.plugin.setIrcTag(ircTag);
        this.plugin.setIrcMessageFormat(ircMessageFormat);
        this.plugin.setCensors(censors);
        this.plugin.setIncomingTellFormat(incomingTellFormat);
        this.plugin.setOutgoingTellFormat(outgoingTellFormat);
        cm.setDefaultChannel(cm.getChannel(defaultChannel));
        cm.setDefaultMsgFormat(defaultMsgFormat);
        this.plugin.setSeparateChatLog(separateChatLog);
    }

    private void loadChannels(Configuration config) {
        ArrayList<Channel> list = new ArrayList<Channel>();
        for (String s : config.getKeys("channels")) {
            Channel c;
            String root = "channels." + s + ".";
            if (config.getBoolean(String.valueOf(root) + "options.local", false)) {
                c = new LocalChannel(this.plugin);
                ((LocalChannel)c).setDistance(config.getInt(String.valueOf(root) + "local-distance", 100));
            } else {
                c = new Channel(this.plugin);
            }
            c.setName(s);
            c.setNick(config.getString(String.valueOf(root) + "nickname", "DEFAULT-NICK"));
            c.setPassword(config.getString(String.valueOf(root) + "password", ""));
            c.setColor(HeroChat.ChatColor.valueOf(config.getString(String.valueOf(root) + "color", "WHITE")));
            c.setMsgFormat(config.getString(String.valueOf(root) + "message-format", "{default}"));
            c.setWorlds(config.getStringList(String.valueOf(root) + "worlds", null));
            String craftIRC = String.valueOf(root) + "craftIRC.";
            c.setIRCToGameTags(config.getStringList(String.valueOf(craftIRC) + "IRC-to-game", null));
            c.setGameToIRCTags(config.getStringList(String.valueOf(craftIRC) + "game-to-IRC", null));
            String options = String.valueOf(root) + "options.";
            c.setVerbose(config.getBoolean(String.valueOf(options) + "join-messages", true));
            c.setQuickMessagable(config.getBoolean(String.valueOf(options) + "shortcut-allowed", false));
            c.setHidden(config.getBoolean(String.valueOf(options) + "hidden", false));
            c.setAutoJoined(config.getBoolean(String.valueOf(options) + "auto-join", false));
            c.setForced(config.getBoolean(String.valueOf(options) + "forced", false));
            c.setCrossWorld(config.getBoolean(String.valueOf(options) + "cross-world-chat", true));
            String lists = String.valueOf(root) + "lists.";
            c.setBlacklist(config.getStringList(String.valueOf(lists) + "bans", null));
            c.setModerators(config.getStringList(String.valueOf(lists) + "moderators", null));
            String permissions = String.valueOf(root) + "permissions.";
            c.setWhitelist(config.getStringList(String.valueOf(permissions) + "join", null));
            c.setVoicelist(config.getStringList(String.valueOf(permissions) + "speak", null));
            list.add(c);
        }
        this.plugin.getChannelManager().setChannels(list);
    }

    public void loadPlayer(String name) {
        File userConfigFile = new File(this.usersConfigFolder, String.valueOf(name) + ".yml");
        try {
            Configuration config = new Configuration(userConfigFile);
            config.load();
            ChannelManager channelManager = this.plugin.getChannelManager();
            try {
                String activeChannelName = config.getString("active-channel", channelManager.getDefaultChannel().getName());
                Channel activeChannel = channelManager.getChannel(activeChannelName);
                if (activeChannel != null) {
                    channelManager.setActiveChannel(name, activeChannelName);
                } else {
                    channelManager.setActiveChannel(name, channelManager.getDefaultChannel().getName());
                }
                List joinedChannels = config.getStringList("joined-channels", null);
                if (joinedChannels.isEmpty()) {
                    channelManager.joinAutoChannels(name);
                } else {
                    for (String s : joinedChannels) {
                        Channel c = channelManager.getChannel(s);
                        if (c == null) continue;
                        List<String> whitelist = c.getWhitelist();
                        String group = this.plugin.getPermissionManager().getGroup(this.plugin.getServer().getPlayer(name));
                        if (c.getBlacklist().contains(name) || !whitelist.isEmpty() && !group.isEmpty() && !whitelist.contains(group)) continue;
                        c.addPlayer(name);
                    }
                }
            }
            catch (Exception e) {
                channelManager.setActiveChannel(name, channelManager.getDefaultChannel().getName());
                channelManager.joinAutoChannels(name);
                this.plugin.log(Level.INFO, "Loaded default settings for " + name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() throws Exception {
        Configuration config = new Configuration(this.primaryConfigFile);
        this.saveGlobals(config);
        this.saveChannels(config);
        config.save();
        Player[] playerArray = this.plugin.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            this.savePlayer(player.getName());
            ++n2;
        }
    }

    private void saveGlobals(Configuration config) throws Exception {
        ChannelManager cm = this.plugin.getChannelManager();
        String globals = "globals.";
        config.setProperty(String.valueOf(globals) + "plugin-tag", (Object)this.plugin.getTag());
        config.setProperty(String.valueOf(globals) + "craftIRC-prefix", (Object)this.plugin.getIrcTag());
        config.setProperty(String.valueOf(globals) + "craftIRC-message-format", (Object)this.plugin.getIrcMessageFormat());
        config.setProperty(String.valueOf(globals) + "incoming-tell-format", (Object)this.plugin.getIncomingTellFormat());
        config.setProperty(String.valueOf(globals) + "outgoing-tell-format", (Object)this.plugin.getOutgoingTellFormat());
        config.setProperty(String.valueOf(globals) + "default-channel", (Object)cm.getDefaultChannel().getName());
        config.setProperty(String.valueOf(globals) + "default-message-format", (Object)cm.getDefaultMsgFormat());
        config.setProperty(String.valueOf(globals) + "censors", this.plugin.getCensors());
        config.setProperty(String.valueOf(globals) + "separate-chat-log", (Object)this.plugin.hasSeparateChatLog());
    }

    private void saveChannels(Configuration config) throws Exception {
        Channel[] channels;
        Channel[] channelArray = channels = this.plugin.getChannelManager().getChannels().toArray(new Channel[0]);
        int n = channels.length;
        int n2 = 0;
        while (n2 < n) {
            Channel c = channelArray[n2];
            String root = "channels." + c.getName() + ".";
            config.setProperty(String.valueOf(root) + "nickname", (Object)c.getNick());
            config.setProperty(String.valueOf(root) + "password", (Object)c.getPassword());
            config.setProperty(String.valueOf(root) + "color", (Object)c.getColor().toString());
            config.setProperty(String.valueOf(root) + "message-format", (Object)c.getMsgFormat());
            config.setProperty(String.valueOf(root) + "worlds", c.getWorlds());
            if (c instanceof LocalChannel) {
                config.setProperty(String.valueOf(root) + "local-distance", (Object)((LocalChannel)c).getDistance());
            }
            String craftIRC = String.valueOf(root) + "craftIRC.";
            config.setProperty(String.valueOf(craftIRC) + "IRC-to-game", c.getIRCToGameTags());
            config.setProperty(String.valueOf(craftIRC) + "game-to-IRC", c.getGameToIRCTags());
            String options = String.valueOf(root) + "options.";
            config.setProperty(String.valueOf(options) + "join-messages", (Object)c.isVerbose());
            config.setProperty(String.valueOf(options) + "shortcut-allowed", (Object)c.isQuickMessagable());
            config.setProperty(String.valueOf(options) + "hidden", (Object)c.isHidden());
            config.setProperty(String.valueOf(options) + "auto-join", (Object)c.isAutoJoined());
            config.setProperty(String.valueOf(options) + "local", (Object)(c instanceof LocalChannel));
            config.setProperty(String.valueOf(options) + "forced", (Object)c.isForced());
            config.setProperty(String.valueOf(options) + "cross-world-chat", (Object)c.isCrossWorld());
            String lists = String.valueOf(root) + "lists.";
            config.setProperty(String.valueOf(lists) + "bans", c.getBlacklist());
            config.setProperty(String.valueOf(lists) + "moderators", c.getModerators());
            String permissions = String.valueOf(root) + "permissions.";
            config.setProperty(String.valueOf(permissions) + "join", c.getWhitelist());
            config.setProperty(String.valueOf(permissions) + "speak", c.getVoicelist());
            ++n2;
        }
    }

    public void savePlayer(String name) {
        File userConfigFile = new File(this.usersConfigFolder, String.valueOf(name) + ".yml");
        try {
            Configuration config = new Configuration(userConfigFile);
            ChannelManager configManager = this.plugin.getChannelManager();
            Channel active = configManager.getActiveChannel(name);
            List<Channel> joinedChannels = configManager.getJoinedChannels(name);
            ArrayList<String> joinedChannelNames = new ArrayList<String>();
            for (Channel channel : joinedChannels) {
                joinedChannelNames.add(channel.getName());
            }
            config.setProperty("active-channel", (Object)active.getName());
            config.setProperty("joined-channels", joinedChannelNames);
            config.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

