/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.util;

import com.nijiko.permissions.PermissionHandler;
import org.bukkit.entity.Player;

public class PermissionManager {
    private PermissionHandler security;

    public PermissionManager(PermissionHandler security) {
        this.security = security;
    }

    public String getGroup(Player p) {
        if (this.security != null) {
            try {
                String world = p.getWorld().getName();
                String name = p.getName();
                String group = this.security.getGroup(world, name);
                if (group == null) {
                    group = "";
                }
                return group;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                return "";
            }
        }
        return "";
    }

    public String getGroupPrefix(Player p) {
        if (this.security != null) {
            try {
                String world = p.getWorld().getName();
                String name = p.getName();
                String group = this.security.getGroup(world, name);
                String prefix = this.security.getGroupPrefix(world, group);
                if (prefix == null) {
                    prefix = "";
                }
                return prefix.replaceAll("&([0-9a-f])", "\u00a7$1");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                return "";
            }
        }
        return "";
    }

    public String getGroupSuffix(Player p) {
        if (this.security != null) {
            try {
                String world = p.getWorld().getName();
                String name = p.getName();
                String group = this.security.getGroup(world, name);
                String suffix = this.security.getGroupSuffix(world, group);
                if (suffix == null) {
                    suffix = "";
                }
                return suffix.replaceAll("&([0-9a-f])", "\u00a7$1");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                return "";
            }
        }
        return "";
    }

    public String getPrefix(Player p) {
        if (this.security != null) {
            try {
                String group;
                String world = p.getWorld().getName();
                String name = p.getName();
                String prefix = this.security.getUserPermissionString(world, name, "prefix");
                if ((prefix == null || prefix.isEmpty()) && (prefix = this.security.getGroupPrefix(world, group = this.security.getGroup(world, name))) == null) {
                    prefix = "";
                }
                return prefix.replaceAll("&([0-9a-f])", "\u00a7$1");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                return "";
            }
        }
        return "";
    }

    public String getSuffix(Player p) {
        if (this.security != null) {
            try {
                String group;
                String world = p.getWorld().getName();
                String name = p.getName();
                String suffix = this.security.getUserPermissionString(world, name, "suffix");
                if ((suffix == null || suffix.isEmpty()) && (suffix = this.security.getGroupSuffix(world, group = this.security.getGroup(world, name))) == null) {
                    suffix = "";
                }
                return suffix.replaceAll("&([0-9a-f])", "\u00a7$1");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                return "";
            }
        }
        return "";
    }

    public boolean isAdmin(Player p) {
        if (this.security != null) {
            return this.security.has(p, "herochat.admin");
        }
        return true;
    }

    public boolean isAllowedColor(Player p) {
        if (this.security != null) {
            return this.security.has(p, "herochat.color");
        }
        return true;
    }

    public boolean canCreate(Player p) {
        if (this.security != null) {
            boolean admin = this.security.has(p, "herochat.admin");
            boolean create = this.security.has(p, "herochat.create");
            return admin || create;
        }
        return true;
    }
}

