/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother;

import java.io.File;
import java.sql.Connection;
import java.util.List;
import me.taylorkelly.bigbrother.BBHelp;
import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.BBPermissions;
import me.taylorkelly.bigbrother.BBSettings;
import me.taylorkelly.bigbrother.Cleanser;
import me.taylorkelly.bigbrother.StickListener;
import me.taylorkelly.bigbrother.Updatr;
import me.taylorkelly.bigbrother.Watcher;
import me.taylorkelly.bigbrother.WorldManager;
import me.taylorkelly.bigbrother.datasource.ConnectionManager;
import me.taylorkelly.bigbrother.datasource.DataBlockSender;
import me.taylorkelly.bigbrother.finder.Finder;
import me.taylorkelly.bigbrother.finder.Sticker;
import me.taylorkelly.bigbrother.fixes.Fix;
import me.taylorkelly.bigbrother.fixes.Fix1;
import me.taylorkelly.bigbrother.fixes.Fix2;
import me.taylorkelly.bigbrother.fixes.Fix3;
import me.taylorkelly.bigbrother.fixes.Fix4;
import me.taylorkelly.bigbrother.griefcraft.util.Updater;
import me.taylorkelly.bigbrother.listeners.BBBlockListener;
import me.taylorkelly.bigbrother.listeners.BBEntityListener;
import me.taylorkelly.bigbrother.listeners.BBPlayerListener;
import me.taylorkelly.bigbrother.rollback.Rollback;
import me.taylorkelly.bigbrother.rollback.RollbackConfirmation;
import me.taylorkelly.bigbrother.rollback.RollbackInterpreter;
import me.taylorkelly.bigbrother.tablemgrs.BBDataTable;
import me.taylorkelly.util.Numbers;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BigBrother
extends JavaPlugin {
    private BBPlayerListener playerListener;
    private BBBlockListener blockListener;
    private BBEntityListener entityListener;
    private StickListener stickListener;
    private Watcher watcher;
    private Sticker sticker;
    private WorldManager worldManager;
    public static String name;
    public static String version;
    public static final String premessage;
    private Updater updater;

    public void onLoad() {
    }

    public void onDisable() {
        DataBlockSender.disable(this);
    }

    public void onEnable() {
        BBLogging.debug("Debug Mode enabled");
        name = this.getDescription().getName();
        version = this.getDescription().getVersion();
        BBSettings.initialize(this.getDataFolder());
        if (BBSettings.libraryAutoDownload) {
            this.updater = new Updater();
            try {
                this.updater.check();
                this.updater.update();
            }
            catch (Throwable e) {
                BBLogging.severe("Could not download dependencies", e);
            }
        } else {
            BBLogging.debug("Downloading libraries was skipped");
        }
        if (!ConnectionManager.createConnection(this)) {
            BBLogging.severe("Error getting a connection, disabling BigBrother...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Connection conn = ConnectionManager.getConnection();
        if (conn == null) {
            BBLogging.severe("Could not establish SQL connection. Disabling BigBrother");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        ConnectionManager.cleanup("onEnable", conn, null, null);
        BBLogging.info(BBDataTable.getInstance().toString() + " loaded!");
        this.worldManager = new WorldManager();
        this.playerListener = new BBPlayerListener(this);
        this.blockListener = new BBBlockListener(this);
        this.entityListener = new BBEntityListener(this);
        this.stickListener = new StickListener(this);
        this.sticker = new Sticker(this.getServer(), this.worldManager);
        if (new File("BigBrother").exists()) {
            this.updateSettings(this.getDataFolder());
        } else if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        Fix1 fix = new Fix1(this.getDataFolder());
        ((Fix)fix).apply();
        Fix2 fix2 = new Fix2(this.getDataFolder());
        ((Fix)fix2).apply();
        Fix3 fix3 = new Fix3(this.getDataFolder());
        ((Fix)fix3).apply();
        Fix4 fix4 = new Fix4(this.getDataFolder());
        ((Fix)fix4).apply();
        BBPermissions.initialize(this.getServer());
        BBHelp.initialize((Plugin)this);
        this.registerEvents();
        this.watcher = BBSettings.getWatcher(this.getServer(), this.getDataFolder());
        DataBlockSender.initialize(this, this.getDataFolder(), this.worldManager);
        Cleanser.initialize(this);
        BBLogging.info(name + " " + version + " enabled");
    }

    private void updateSettings(File dataFolder) {
        File oldDirectory = new File("BigBrother");
        dataFolder.getParentFile().mkdirs();
        oldDirectory.renameTo(dataFolder);
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_COMMAND_PREPROCESS, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_JOIN, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_QUIT, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_ITEM, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_CHAT, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_TELEPORT, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.BLOCK_PLACED, (Listener)this.blockListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.BLOCK_BREAK, (Listener)this.blockListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.BLOCK_DAMAGED, (Listener)this.blockListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.BLOCK_IGNITE, (Listener)this.blockListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.BLOCK_INTERACT, (Listener)this.blockListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.LEAVES_DECAY, (Listener)this.blockListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.BLOCK_BURN, (Listener)this.blockListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.BLOCK_FLOW, (Listener)this.blockListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.SIGN_CHANGE, (Listener)this.blockListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.ENTITY_EXPLODE, (Listener)this.entityListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.BLOCK_RIGHTCLICKED, (Listener)this.stickListener, Event.Priority.Low, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.BLOCK_PLACED, (Listener)this.stickListener, Event.Priority.Low, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.BLOCK_INTERACT, (Listener)this.stickListener, Event.Priority.Low, (Plugin)this);
    }

    public boolean watching(Player player) {
        return this.watcher.watching(player);
    }

    public boolean toggleWatch(String player) {
        return this.watcher.toggleWatch(player);
    }

    public String getWatchedPlayers() {
        return this.watcher.getWatchedPlayers();
    }

    public boolean haveSeen(Player player) {
        return this.watcher.haveSeen(player);
    }

    public void markSeen(Player player) {
        this.watcher.markSeen(player);
    }

    public void watchPlayer(Player player) {
        this.watcher.watchPlayer(player);
    }

    public String getUnwatchedPlayers() {
        return this.watcher.getUnwatchedPlayers();
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        String[] split = args;
        String commandName = command.getName().toLowerCase();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (commandName.equals("bb")) {
                if (split.length == 0) {
                    return false;
                }
                if (split[0].equalsIgnoreCase("version")) {
                    player.sendMessage("You're running: " + ChatColor.AQUA.toString() + name + " " + version);
                } else if (split[0].equalsIgnoreCase("update")) {
                    Updatr.updateAvailable(player);
                } else if (split[0].equalsIgnoreCase("watch") && BBPermissions.watch(player)) {
                    if (split.length == 2) {
                        String playerName;
                        List targets = this.getServer().matchPlayer(split[1]);
                        Player watchee = null;
                        if (targets.size() == 1) {
                            watchee = (Player)targets.get(0);
                        }
                        String string = playerName = watchee == null ? split[1] : watchee.getName();
                        if (this.toggleWatch(playerName)) {
                            String status = watchee == null ? " (offline)" : " (online)";
                            player.sendMessage(premessage + "Now watching " + playerName + status);
                        } else {
                            String status = watchee == null ? " (offline)" : " (online)";
                            player.sendMessage(premessage + "No longer watching " + playerName + status);
                        }
                    } else {
                        player.sendMessage(premessage + "usage is " + ChatColor.RED + "/bb watch <player>");
                    }
                } else if (split[0].equalsIgnoreCase("watched") && BBPermissions.info(player)) {
                    String watchedPlayers = this.getWatchedPlayers();
                    if (watchedPlayers.equals("")) {
                        player.sendMessage(premessage + "Not watching anyone.");
                    } else {
                        player.sendMessage(premessage + "Now watching:");
                        player.sendMessage(watchedPlayers);
                    }
                } else if (split[0].equalsIgnoreCase("unwatched") && BBPermissions.info(player)) {
                    String unwatchedPlayers = this.getUnwatchedPlayers();
                    if (unwatchedPlayers.equals("")) {
                        player.sendMessage(premessage + "Everyone on is being watched.");
                    } else {
                        player.sendMessage(premessage + "Currently not watching:");
                        player.sendMessage(unwatchedPlayers);
                    }
                } else if (split[0].equalsIgnoreCase("cleanse") && BBPermissions.cleanse(player)) {
                    if (Cleanser.needsCleaning()) {
                        Cleanser.clean(player);
                    } else {
                        player.sendMessage(ChatColor.RED + "No need to cleanse. Check your settings.");
                    }
                } else if (split[0].equalsIgnoreCase("rollback") && BBPermissions.rollback(player)) {
                    if (split.length > 1) {
                        RollbackInterpreter interpreter = new RollbackInterpreter(player, split, this.getServer(), this.worldManager, (Plugin)this);
                        Boolean passed = interpreter.interpret();
                        if (passed != null) {
                            if (passed.booleanValue()) {
                                interpreter.send();
                            } else {
                                player.sendMessage(premessage + ChatColor.RED + "Warning: " + ChatColor.WHITE + "You are rolling back without a time or radius argument.");
                                player.sendMessage("Use " + ChatColor.RED + "/bb confirm" + ChatColor.WHITE + " to confirm the rollback.");
                                player.sendMessage("Use " + ChatColor.RED + "/bb delete" + ChatColor.WHITE + " to delete it.");
                                RollbackConfirmation.setRI(player, interpreter);
                            }
                        }
                    } else {
                        player.sendMessage(premessage + "Usage is: " + ChatColor.RED + "/bb rollback name1 [name2] [options]");
                        player.sendMessage(premessage + "Please read the full command documentation at https://github.com/tkelly910/BigBrother/wiki/Commands");
                    }
                } else if (split[0].equalsIgnoreCase("confirm") && BBPermissions.rollback(player)) {
                    if (split.length == 1) {
                        if (RollbackConfirmation.hasRI(player)) {
                            RollbackInterpreter interpret = RollbackConfirmation.getRI(player);
                            interpret.send();
                        } else {
                            player.sendMessage(premessage + "You have no rollback to confirm.");
                        }
                    } else {
                        player.sendMessage(premessage + "usage is " + ChatColor.RED + "/bb confirm");
                    }
                } else if (split[0].equalsIgnoreCase("delete") && BBPermissions.rollback(player)) {
                    if (split.length == 1) {
                        if (RollbackConfirmation.hasRI(player)) {
                            RollbackConfirmation.deleteRI(player);
                            player.sendMessage(premessage + "You have deleted your rollback.");
                        } else {
                            player.sendMessage(premessage + "You have no rollback to delete.");
                        }
                    } else {
                        player.sendMessage(premessage + "usage is " + ChatColor.RED + "/bb delete");
                    }
                } else if (split[0].equalsIgnoreCase("undo") && BBPermissions.rollback(player)) {
                    if (split.length == 1) {
                        if (Rollback.canUndo()) {
                            int size = Rollback.undoSize();
                            player.sendMessage(premessage + "Undo-ing last rollback of " + size + " blocks");
                            Rollback.undo(this.getServer(), player);
                            player.sendMessage(premessage + "Undo successful");
                        } else {
                            player.sendMessage(premessage + "No rollback to undo");
                        }
                    } else {
                        player.sendMessage(premessage + "Usage is " + ChatColor.RED + "/bb undo");
                    }
                } else if (split[0].equalsIgnoreCase("stick") && BBPermissions.info(player)) {
                    if (split.length == 1) {
                        this.sticker.setMode(player, 1);
                        this.reportStickMode(player, 1);
                    } else if (split.length == 2 && Numbers.isInteger(split[1])) {
                        this.sticker.setMode(player, Integer.parseInt(split[1]));
                        this.reportStickMode(player, Integer.parseInt(split[1]));
                    } else {
                        player.sendMessage(premessage + "Usage is " + ChatColor.RED + "/bb stick [#]");
                    }
                } else if (split[0].equalsIgnoreCase("log") && BBPermissions.info(player)) {
                    if (split.length == 1) {
                        this.sticker.setMode(player, 2);
                        this.reportStickMode(player, 2);
                    } else {
                        player.sendMessage(premessage + "Usage is " + ChatColor.RED + "/bb log");
                    }
                } else if (split[0].equalsIgnoreCase("here") && BBPermissions.info(player)) {
                    if (split.length == 1) {
                        Finder finder = new Finder(player.getLocation(), this.getServer().getWorlds(), this.worldManager);
                        finder.addReciever(player);
                        finder.find();
                    } else if (Numbers.isNumber(split[1]) && split.length == 2) {
                        Finder finder = new Finder(player.getLocation(), this.getServer().getWorlds(), this.worldManager);
                        finder.setRadius(Double.parseDouble(split[1]));
                        finder.addReciever(player);
                        finder.find();
                    } else if (split.length == 2) {
                        Finder finder = new Finder(player.getLocation(), this.getServer().getWorlds(), this.worldManager);
                        finder.addReciever(player);
                        List targets = this.getServer().matchPlayer(split[1]);
                        Player findee = null;
                        if (targets.size() == 1) {
                            findee = (Player)targets.get(0);
                        }
                        finder.find(findee == null ? split[1] : findee.getName());
                    } else if (Numbers.isNumber(split[2]) && split.length == 3) {
                        Finder finder = new Finder(player.getLocation(), this.getServer().getWorlds(), this.worldManager);
                        finder.setRadius(Double.parseDouble(split[2]));
                        finder.addReciever(player);
                        List targets = this.getServer().matchPlayer(split[1]);
                        Player findee = null;
                        if (targets.size() == 1) {
                            findee = (Player)targets.get(0);
                        }
                        finder.find(findee == null ? split[1] : findee.getName());
                    } else {
                        player.sendMessage(premessage + "usage is " + ChatColor.RED + "/bb here");
                        player.sendMessage("or " + ChatColor.RED + "/bb here <radius>");
                        player.sendMessage("or " + ChatColor.RED + "/bb here <name>");
                        player.sendMessage("or " + ChatColor.RED + "/bb here <name> <radius>");
                    }
                } else if (split[0].equalsIgnoreCase("find") && BBPermissions.info(player)) {
                    if (split.length == 4 && Numbers.isNumber(split[1]) && Numbers.isNumber(split[2]) && Numbers.isNumber(split[3])) {
                        World currentWorld = player.getWorld();
                        Location loc = new Location(currentWorld, Double.parseDouble(split[1]), Double.parseDouble(split[2]), Double.parseDouble(split[3]));
                        Finder finder = new Finder(loc, this.getServer().getWorlds(), this.worldManager);
                        finder.addReciever(player);
                        finder.find();
                    } else if (split.length == 5 && Numbers.isNumber(split[1]) && Numbers.isNumber(split[2]) && Numbers.isNumber(split[3]) && Numbers.isNumber(split[4])) {
                        World currentWorld = player.getWorld();
                        Location loc = new Location(currentWorld, Double.parseDouble(split[1]), Double.parseDouble(split[2]), Double.parseDouble(split[3]));
                        Finder finder = new Finder(loc, this.getServer().getWorlds(), this.worldManager);
                        finder.setRadius(Double.parseDouble(split[4]));
                        finder.addReciever(player);
                        finder.find();
                    } else if (split.length == 5 && Numbers.isNumber(split[1]) && Numbers.isNumber(split[2]) && Numbers.isNumber(split[3])) {
                        World currentWorld = player.getWorld();
                        Location loc = new Location(currentWorld, Double.parseDouble(split[1]), Double.parseDouble(split[2]), Double.parseDouble(split[3]));
                        Finder finder = new Finder(loc, this.getServer().getWorlds(), this.worldManager);
                        finder.addReciever(player);
                        List targets = this.getServer().matchPlayer(split[4]);
                        Player findee = null;
                        if (targets.size() == 1) {
                            findee = (Player)targets.get(0);
                        }
                        finder.find(findee == null ? split[4] : findee.getName());
                    } else if (split.length == 6 && Numbers.isNumber(split[1]) && Numbers.isNumber(split[2]) && Numbers.isNumber(split[3]) && Numbers.isNumber(split[5])) {
                        World currentWorld = player.getWorld();
                        Location loc = new Location(currentWorld, Double.parseDouble(split[1]), Double.parseDouble(split[2]), Double.parseDouble(split[3]));
                        Finder finder = new Finder(loc, this.getServer().getWorlds(), this.worldManager);
                        finder.setRadius(Double.parseDouble(split[5]));
                        finder.addReciever(player);
                        List targets = this.getServer().matchPlayer(split[4]);
                        Player findee = null;
                        if (targets.size() == 1) {
                            findee = (Player)targets.get(0);
                        }
                        finder.find(findee == null ? split[4] : findee.getName());
                    } else {
                        player.sendMessage(premessage + "usage is " + ChatColor.RED + "/bb find <x> <y> <z>");
                        player.sendMessage("or " + ChatColor.RED + "/bb find <x> <y> <z> <radius>");
                        player.sendMessage("or " + ChatColor.RED + "/bb find <x> <y> <z> <name>");
                        player.sendMessage("or " + ChatColor.RED + "/bb find <x> <y> <z> <name> <radius>");
                    }
                } else if (split[0].equalsIgnoreCase("help")) {
                    player.sendMessage(premessage + "BigBrother version " + version + " help");
                    player.sendMessage(premessage + " " + ChatColor.RED + "/bb watch (name)" + ChatColor.WHITE + " - Toggles the whether BB is watching (name)");
                    player.sendMessage(premessage + " " + ChatColor.RED + "/bb watched" + ChatColor.WHITE + " - Shows which users are being watched by BB");
                    player.sendMessage(premessage + " " + ChatColor.RED + "/bb unwatched" + ChatColor.WHITE + " - Shows which users that are logged in are unwatched");
                    player.sendMessage(premessage + " " + ChatColor.RED + "/bb stick (0|1|2)" + ChatColor.WHITE + " - Gives you a stick (1), a log you can place (2), or disables either (0).");
                    player.sendMessage(premessage + " " + ChatColor.RED + "/bb here" + ChatColor.WHITE + " - See changes that took place in the area you are standing in.");
                    player.sendMessage(premessage + " " + ChatColor.RED + "/bb find x y z" + ChatColor.WHITE + " - Get the history of an area at a specific coordinate");
                    player.sendMessage(premessage + " " + ChatColor.RED + "/bb rollback (name1) [name2] [options]" + ChatColor.WHITE + " - A command you should study in length via our helpful online wiki.");
                    player.sendMessage(premessage + " " + ChatColor.RED + "/bb undo" + ChatColor.WHITE + " - Great for fixing bad rollbacks. It's like it never happened!");
                    player.sendMessage(premessage + " " + ChatColor.RED + "/bb confirm" + ChatColor.WHITE + " - Confirms your rollback (if applicable).");
                    player.sendMessage(premessage + " " + ChatColor.RED + "/bb delete" + ChatColor.WHITE + " - Delete your rollback (if applicable).");
                } else {
                    return false;
                }
                return true;
            }
        } else if (sender instanceof ConsoleCommandSender) {
            if (commandName.equals("bb")) {
                ConsoleCommandSender console = (ConsoleCommandSender)sender;
                if (split.length == 0) {
                    return false;
                }
                if (split[0].equalsIgnoreCase("version")) {
                    console.sendMessage("You're running: " + ChatColor.AQUA.toString() + name + " " + version);
                } else if (split[0].equalsIgnoreCase("update")) {
                    Updatr.updateAvailable(console);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void reportStickMode(Player player, int stickLevel) {
        if (stickLevel > 0) {
            player.sendMessage(premessage + "Your current stick mode is " + this.sticker.descMode(player));
            player.sendMessage("Use " + ChatColor.RED + "/bb stick 0" + ChatColor.WHITE + " to turn it off");
        }
    }

    public boolean hasStick(Player player, ItemStack itemStack) {
        return this.sticker.hasStick(player, itemStack);
    }

    public void stick(Player player, Block block) {
        this.sticker.stick(player, block);
    }

    public boolean rightClickStick(Player player) {
        return this.sticker.rightClickStick(player);
    }

    static {
        premessage = ChatColor.AQUA + "[BBROTHER]: " + ChatColor.WHITE;
    }
}

