/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.datablock;

import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.datablock.BBDataBlock;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class CreateSignText
extends BBDataBlock {
    public CreateSignText(String player, Sign sign, String world) {
        super(player, BBDataBlock.Action.CREATE_SIGN_TEXT, world, sign.getX(), sign.getY(), sign.getZ(), 323, CreateSignText.getText(sign));
    }

    public CreateSignText(String player, String[] lines, Block block) {
        super(player, BBDataBlock.Action.CREATE_SIGN_TEXT, block.getWorld().getName(), block.getX(), block.getY(), block.getZ(), 323, CreateSignText.getText(lines));
    }

    private static String getText(Sign sign) {
        String[] lines = sign.getLines();
        return CreateSignText.getText(lines);
    }

    private static String getText(String[] lines) {
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            message.append(lines[i]);
            if (i >= lines.length - 1) continue;
            message.append("`");
        }
        return message.toString();
    }

    public static BBDataBlock getBBDataBlock(String player, String world, int x, int y, int z, int type, String data) {
        return new CreateSignText(player, world, x, y, z, type, data);
    }

    private CreateSignText(String player, String world, int x, int y, int z, int type, String data) {
        super(player, BBDataBlock.Action.CREATE_SIGN_TEXT, world, x, y, z, type, data);
    }

    @Override
    public void redo(Server server) {
        World currWorld = server.getWorld(this.world);
        if (!currWorld.isChunkLoaded(this.x >> 4, this.z >> 4)) {
            currWorld.loadChunk(this.x >> 4, this.z >> 4);
        }
        String[] lines = this.data.split("`");
        Block block = currWorld.getBlockAt(this.x, this.y, this.z);
        if (block.getState() instanceof Sign) {
            Sign sign = (Sign)block.getState();
            for (int i = 0; i < lines.length; ++i) {
                sign.setLine(i, lines[i]);
            }
        } else {
            BBLogging.warning("Error when restoring sign");
        }
    }

    @Override
    public void rollback(Server server) {
        Block block;
        World currWorld = server.getWorld(this.world);
        if (!currWorld.isChunkLoaded(this.x >> 4, this.z >> 4)) {
            currWorld.loadChunk(this.x >> 4, this.z >> 4);
        }
        if ((block = currWorld.getBlockAt(this.x, this.y, this.z)).getState() instanceof Sign) {
            Sign sign = (Sign)block.getState();
            for (int i = 0; i < sign.getLines().length; ++i) {
                sign.setLine(i, "");
            }
        } else {
            BBLogging.warning("Error when restoring sign");
        }
    }
}

