/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.datablock;

import java.util.ArrayList;
import me.taylorkelly.bigbrother.datablock.BBDataBlock;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;

public class LavaFlow
extends BBDataBlock {
    private ArrayList<BBDataBlock> bystanders;

    public LavaFlow(String player, Block block, String world) {
        super(player, BBDataBlock.Action.LAVA_FLOW, world, block.getX(), block.getY(), block.getZ(), block.getTypeId(), Byte.toString(block.getData()));
        this.bystanders = new ArrayList();
    }

    public LavaFlow(String player, String world, int x, int y, int z, int type, byte data) {
        super(player, BBDataBlock.Action.LAVA_FLOW, world, x, y, z, type, Byte.toString(data));
        this.bystanders = new ArrayList();
    }

    @Override
    public void send() {
        for (BBDataBlock block : this.bystanders) {
            block.send();
        }
        super.send();
    }

    private LavaFlow(String player, String world, int x, int y, int z, int type, String data) {
        super(player, BBDataBlock.Action.LAVA_FLOW, world, x, y, z, type, data);
    }

    @Override
    public void rollback(Server server) {
        World currWorld = server.getWorld(this.world);
        if (!currWorld.isChunkLoaded(this.x >> 4, this.z >> 4)) {
            currWorld.loadChunk(this.x >> 4, this.z >> 4);
        }
        currWorld.getBlockAt(this.x, this.y, this.z).setTypeId(0);
    }

    @Override
    public void redo(Server server) {
    }

    public static BBDataBlock getBBDataBlock(String player, String world, int x, int y, int z, int type, String data) {
        return new LavaFlow(player, world, x, y, z, type, data);
    }
}

