/*
 * Decompiled with CFR 0.152.
 */
package com.iConomy;

import com.iConomy.entity.Players;
import com.iConomy.net.Database;
import com.iConomy.system.Account;
import com.iConomy.system.Accounts;
import com.iConomy.system.Bank;
import com.iConomy.system.Banks;
import com.iConomy.system.Interest;
import com.iConomy.system.Transactions;
import com.iConomy.util.Constants;
import com.iConomy.util.Downloader;
import com.iConomy.util.FileManager;
import com.iConomy.util.Misc;
import com.nijiko.permissions.PermissionHandler;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.server.ServerListener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.config.Configuration;

public class iConomy
extends JavaPlugin {
    public static Banks Banks = null;
    public static Accounts Accounts = null;
    private static Server Server = null;
    private static Database Database = null;
    private static Transactions Transactions = null;
    private static PermissionHandler Permissions = null;
    private static Players playerListener = null;
    private static Timer Interest_Timer = null;

    public void onEnable() {
        Locale.setDefault(Locale.US);
        Server = this.getServer();
        new File("lib" + File.separator).mkdir();
        new File("lib" + File.separator).setWritable(true);
        new File("lib" + File.separator).setExecutable(true);
        this.getDataFolder().mkdir();
        this.getDataFolder().setWritable(true);
        this.getDataFolder().setExecutable(true);
        Constants.Plugin_Directory = this.getDataFolder().getPath();
        PluginDescriptionFile pdfFile = this.getDescription();
        FileManager file = new FileManager(this.getDataFolder().getPath(), "VERSION", false);
        this.extract("Config.yml");
        this.extract("Template.yml");
        try {
            Constants.load(new Configuration(new File(this.getDataFolder(), "Config.yml")));
        }
        catch (Exception e) {
            Server.getPluginManager().disablePlugin((Plugin)this);
            System.out.println("[iConomy] Failed to retrieve configuration from directory.");
            System.out.println("[iConomy] Please back up your current settings and let iConomy recreate it.");
            return;
        }
        if (Misc.is(Constants.DatabaseType, new String[]{"sqlite", "h2", "h2sql", "h2db"})) {
            if (!new File("lib" + File.separator, "h2.jar").exists()) {
                Downloader.install(Constants.H2_Jar_Location, "h2.jar");
            }
        } else if (!new File("lib" + File.separator, "mysql-connector-java-bin.jar").exists()) {
            Downloader.install(Constants.MySQL_Jar_Location, "mysql-connector-java-bin.jar");
        }
        try {
            Database = new Database();
            Database.setupAccountTable();
            if (Constants.Banking) {
                Database.setupBankTable();
                Database.setupBankRelationTable();
            }
        }
        catch (Exception e) {
            System.out.println("[iConomy] Database initialization failed: " + e);
            Server.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            Transactions = new Transactions();
            Database.setupTransactionTable();
        }
        catch (Exception e) {
            System.out.println("[iConomy] Could not load transaction logger: " + e);
        }
        this.update(file, Double.valueOf(pdfFile.getVersion()));
        Accounts = new Accounts();
        if (Constants.Banking) {
            Banks = new Banks();
        }
        try {
            if (Constants.Interest) {
                long time = (long)Constants.InterestSeconds * 1000L;
                Interest_Timer = new Timer();
                Interest_Timer.scheduleAtFixedRate((TimerTask)new Interest(this.getDataFolder().getPath()), time, time);
            }
        }
        catch (Exception e) {
            System.out.println("[iConomy] Failed to start interest system: " + e);
            Server.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        playerListener = new Players(this.getDataFolder().getPath());
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_JOIN, (org.bukkit.event.Listener)playerListener, Event.Priority.Normal, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLUGIN_ENABLE, (org.bukkit.event.Listener)new Listener(this), Event.Priority.Monitor, (Plugin)this);
        System.out.println("[iConomy] v" + pdfFile.getVersion() + " (" + "Eruanna" + ") loaded.");
        System.out.println("[iConomy] Developed by: " + pdfFile.getAuthors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisable() {
        try {
            if (Misc.is(Constants.DatabaseType, new String[]{"sqlite", "h2", "h2sql", "h2db"})) {
                Database.connectionPool().dispose();
            }
            System.out.println("[iConomy] Plugin disabled.");
        }
        catch (Exception e) {
            System.out.println("[iConomy] Plugin disabled.");
        }
        finally {
            if (Interest_Timer != null) {
                Interest_Timer.cancel();
            }
            Server = null;
            Banks = null;
            Accounts = null;
            Database = null;
            Permissions = null;
            Transactions = null;
            playerListener = null;
            Interest_Timer = null;
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        String[] split = new String[args.length + 1];
        split[0] = cmd.getName().toLowerCase();
        System.arraycopy(args, 0, split, 1, args.length);
        playerListener.onPlayerCommand(sender, split);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(FileManager file, double version) {
        block50: {
            if (file.exists()) {
                file.read();
                try {
                    double current = Double.parseDouble(file.getSource());
                    LinkedList<String> MySQL = new LinkedList<String>();
                    LinkedList<String> GENERIC = new LinkedList<String>();
                    LinkedList SQL = new LinkedList();
                    if (current != version) {
                        if (current < 4.64) {
                            MySQL.add("ALTER TABLE " + Constants.SQLTable + " ADD hidden boolean DEFAULT '0';");
                            GENERIC.add("ALTER TABLE " + Constants.SQLTable + " ADD HIDDEN BOOLEAN DEFAULT '0';");
                        }
                        if (current < 4.62) {
                            MySQL.add("ALTER IGNORE TABLE " + Constants.SQLTable + " ADD UNIQUE INDEX(username(32));");
                            GENERIC.add("ALTER TABLE " + Constants.SQLTable + " ADD UNIQUE(username);");
                        }
                        if (MySQL.isEmpty() || GENERIC.isEmpty()) break block50;
                        Connection conn = null;
                        ResultSet rs = null;
                        Statement stmt = null;
                        try {
                            conn = iConomy.getiCoDatabase().getConnection();
                            stmt = null;
                            System.out.println(" - Updating " + Constants.DatabaseType + " Database for latest iConomy");
                            int i = 1;
                            SQL = Constants.DatabaseType.equalsIgnoreCase("mysql") ? MySQL : GENERIC;
                            for (String Query : SQL) {
                                stmt = conn.createStatement();
                                stmt.execute(Query);
                                System.out.println("   Executing SQL Query #" + i + " of " + SQL.size());
                                ++i;
                            }
                            file.write(version);
                            System.out.println(" + Database Update Complete.");
                            break block50;
                        }
                        catch (SQLException e) {
                            System.out.println("[iConomy] Error updating database: " + e);
                            break block50;
                        }
                        finally {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (SQLException ex) {}
                            }
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (SQLException ex) {}
                            }
                            iConomy.getiCoDatabase().close(conn);
                        }
                    }
                    file.write(version);
                }
                catch (Exception e) {
                    System.out.println("[iConomy] Error on version check: ");
                    e.printStackTrace();
                    file.delete();
                }
            } else {
                if (!Constants.DatabaseType.equalsIgnoreCase("flatfile")) {
                    String[] SQL = new String[]{};
                    String[] MySQL = new String[]{"DROP TABLE " + Constants.SQLTable + ";", "RENAME TABLE ibalances TO " + Constants.SQLTable + ";", "ALTER TABLE " + Constants.SQLTable + " CHANGE  player  username TEXT NOT NULL, CHANGE balance balance DECIMAL(64, 2) NOT NULL;"};
                    String[] SQLite = new String[]{"DROP TABLE " + Constants.SQLTable + ";", "CREATE TABLE '" + Constants.SQLTable + "' ('id' INT ( 10 ) PRIMARY KEY , 'username' TEXT , 'balance' DECIMAL ( 64 , 2 ));", "INSERT INTO " + Constants.SQLTable + "(id, username, balance) SELECT id, player, balance FROM ibalances;", "DROP TABLE ibalances;"};
                    Connection conn = null;
                    ResultSet rs = null;
                    Statement ps = null;
                    try {
                        conn = iConomy.getiCoDatabase().getConnection();
                        DatabaseMetaData dbm = conn.getMetaData();
                        rs = dbm.getTables(null, null, "ibalances", null);
                        ps = null;
                        if (rs.next()) {
                            System.out.println(" - Updating " + Constants.DatabaseType + " Database for latest iConomy");
                            int i = 1;
                            for (String Query : SQL = Constants.DatabaseType.equalsIgnoreCase("mysql") ? MySQL : SQLite) {
                                ps = conn.prepareStatement(Query);
                                ps.executeQuery(Query);
                                System.out.println("   Executing SQL Query #" + i + " of " + SQL.length);
                                ++i;
                            }
                            System.out.println(" + Database Update Complete.");
                        }
                        file.write(version);
                    }
                    catch (SQLException e) {
                        System.out.println("[iConomy] Error updating database: " + e);
                    }
                    finally {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (SQLException ex) {}
                        }
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException ex) {}
                        }
                        if (conn != null) {
                            iConomy.getiCoDatabase().close(conn);
                        }
                    }
                }
                file.create();
                file.write(version);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extract(String name) {
        InputStream input;
        File actual = new File(this.getDataFolder(), name);
        if (!actual.exists() && (input = ((Object)((Object)this)).getClass().getResourceAsStream("/default/" + name)) != null) {
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(actual);
                byte[] buf = new byte[8192];
                int length = 0;
                while ((length = input.read(buf)) > 0) {
                    output.write(buf, 0, length);
                }
                System.out.println("[iConomy] Default setup file written: " + name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    public static String format(String account) {
        return iConomy.getAccount(account).getHoldings().toString();
    }

    public static String format(String bank, String account) {
        return new Bank(bank).getAccount(account).getHoldings().toString();
    }

    public static String format(double amount) {
        DecimalFormat formatter = new DecimalFormat("#,##0.00");
        String formatted = formatter.format(amount);
        if (formatted.endsWith(".")) {
            formatted = formatted.substring(0, formatted.length() - 1);
        }
        return Misc.formatted(formatted, Constants.Major, Constants.Minor);
    }

    public static Account getAccount(String name) {
        return Accounts.get(name);
    }

    public static boolean hasAccount(String name) {
        return Accounts.exists(name);
    }

    public static Bank getBank(String name) {
        return Banks.get(name);
    }

    public static Bank getBank(int id) {
        return Banks.get(id);
    }

    public static Database getiCoDatabase() {
        return Database;
    }

    public static Transactions getTransactions() {
        return Transactions;
    }

    public static PermissionHandler getPermissions() {
        return Permissions;
    }

    public static boolean hasPermissions(CommandSender sender, String node) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (Permissions != null) {
                return Permissions.permission(player, node);
            }
            return player.isOp();
        }
        return true;
    }

    public static Server getBukkitServer() {
        return Server;
    }

    private class Listener
    extends ServerListener {
        private iConomy plugin;

        public Listener(iConomy thisPlugin) {
            this.plugin = thisPlugin;
        }

        public void onPluginEnable(PluginEnableEvent event) {
            Plugin Permissions2;
            Listener listener = this;
            if (Permissions == null && (Permissions2 = this.plugin.getServer().getPluginManager().getPlugin("Permissions")) != null && Permissions2.isEnabled()) {
                Permissions = ((Permissions)Permissions2).getHandler();
                System.out.println("[iConomy] hooked into Permissions.");
            }
        }
    }
}

