/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.data;

import com.nijiko.data.GroupWorld;
import com.nijiko.data.Storage;
import com.nijiko.permissions.EntryType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class CachedStorage
implements Storage {
    private final Map<String, Set<String>> permissions = new HashMap<String, Set<String>>();
    private final Map<String, LinkedHashSet<GroupWorld>> parents = new HashMap<String, LinkedHashSet<GroupWorld>>();
    private final Map<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();

    public CachedStorage(Storage wrapped) {
        if (wrapped instanceof CachedStorage) {
            throw new RuntimeException("No Cacheception, please.");
        }
    }

    public Set<String> getPermissions(String name) {
        Set perms = this.permissions.get(name);
        if (perms == null) {
            perms = this.getWrapped().getPermissions(name);
            this.permissions.put(name, perms);
        }
        return perms;
    }

    public void addPermission(String name, String permission) {
        if (this.permissions.get(name) == null) {
            this.permissions.put(name, new HashSet());
        }
        this.permissions.get(name).add(permission);
        this.getWrapped().addPermission(name, permission);
    }

    public void removePermission(String name, String permission) {
        if (this.permissions.get(name) == null) {
            this.permissions.put(name, new HashSet());
        }
        this.permissions.get(name).remove(permission);
        this.getWrapped().removePermission(name, permission);
    }

    public LinkedHashSet<GroupWorld> getParents(String name) {
        LinkedHashSet entryParents = this.parents.get(name);
        if (entryParents == null) {
            entryParents = this.getWrapped().getParents(name);
            this.parents.put(name, entryParents);
        }
        return entryParents;
    }

    public void addParent(String name, String groupWorld, String groupName) {
        GroupWorld gw = new GroupWorld(groupWorld, groupName);
        if (this.parents.get(name) == null) {
            this.parents.put(name, new LinkedHashSet());
        }
        this.parents.get(name).add(gw);
        this.getWrapped().addParent(name, groupWorld, groupName);
    }

    public void removeParent(String name, String groupWorld, String groupName) {
        GroupWorld gw = new GroupWorld(groupWorld, groupName);
        if (this.parents.get(name) == null) {
            this.parents.put(name, new LinkedHashSet());
        }
        this.parents.get(name).remove(gw);
        this.getWrapped().removeParent(name, groupWorld, groupName);
    }

    public Set<String> getEntries() {
        return this.getWrapped().getEntries();
    }

    public EntryType getType() {
        return this.getWrapped().getType();
    }

    public boolean create(String name) {
        return this.getWrapped().create(name);
    }

    public boolean delete(String name) {
        this.permissions.remove(name);
        this.parents.remove(name);
        this.data.remove(name);
        return this.getWrapped().delete(name);
    }

    public String getWorld() {
        return this.getWrapped().getWorld();
    }

    public void forceSave() {
        this.getWrapped().forceSave();
    }

    public void save() {
        this.getWrapped().save();
    }

    public void reload() {
        this.getWrapped().reload();
        this.permissions.clear();
        this.parents.clear();
        this.data.clear();
    }

    public boolean isAutoSave() {
        return this.getWrapped().isAutoSave();
    }

    public void setAutoSave(boolean autoSave) {
        this.getWrapped().setAutoSave(autoSave);
    }

    public String getString(String name, String path) {
        if (this.data.get(name) == null) {
            this.data.put(name, new HashMap());
        } else {
            Object o = this.data.get(name).get(path);
            if (this.data.get(name).containsKey(path) && o == null) {
                return null;
            }
            if (o != null) {
                return o.toString();
            }
        }
        String str = this.getWrapped().getString(name, path);
        this.data.get(name).put(path, str);
        return str;
    }

    public Integer getInt(String name, String path) {
        if (this.data.get(name) == null) {
            this.data.put(name, new HashMap());
        } else {
            Object o = this.data.get(name).get(path);
            if (this.data.get(name).containsKey(path) && o == null) {
                return null;
            }
            if (o instanceof Integer) {
                return (Integer)o;
            }
        }
        Integer val = this.getWrapped().getInt(name, path);
        this.data.get(name).put(path, val);
        return val;
    }

    public Double getDouble(String name, String path) {
        if (this.data.get(name) == null) {
            this.data.put(name, new HashMap());
        } else {
            Object o = this.data.get(name).get(path);
            if (this.data.get(name).containsKey(path) && o == null) {
                return null;
            }
            if (o instanceof Double) {
                return (Double)o;
            }
        }
        Double val = this.getWrapped().getDouble(name, path);
        this.data.get(name).put(path, val);
        return val;
    }

    public Boolean getBool(String name, String path) {
        if (this.data.get(name) == null) {
            this.data.put(name, new HashMap());
        } else {
            Object o = this.data.get(name).get(path);
            if (this.data.get(name).containsKey(path) && o == null) {
                return null;
            }
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
        }
        Boolean val = this.getWrapped().getBool(name, path);
        this.data.get(name).put(path, val);
        return val;
    }

    public void setData(String name, String path, Object o) {
        if (!(o instanceof Integer || o instanceof Boolean || o instanceof Double || o instanceof String)) {
            throw new IllegalArgumentException("Only ints, bools, doubles and Strings are allowed!");
        }
        if (this.data.get(name) == null) {
            this.data.put(name, new HashMap());
        }
        this.data.get(name).put(path, o);
        this.getWrapped().setData(name, path, o);
    }

    public void removeData(String name, String path) {
        if (this.data.get(name) != null) {
            this.data.get(name).remove(path);
        }
        this.getWrapped().removeData(name, path);
    }

    protected abstract Storage getWrapped();
}

