/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.data;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import javax.sql.DataSource;
import org.sqlite.SQLiteDataSource;

enum Dbms {
    SQLITE("org.sqlite.JDBC"),
    MYSQL("com.mysql.jdbc.Driver");

    private final String driver;

    private Dbms(String driverClass) {
        this.driver = driverClass;
    }

    public String getDriver() {
        return this.driver;
    }

    public DataSource getSource(String username, String password, String url) {
        switch (this) {
            case MYSQL: {
                MysqlDataSource mds = new MysqlDataSource();
                mds.setUser(username);
                mds.setPassword(password);
                mds.setUrl(url);
                mds.setCachePreparedStatements(true);
                mds.setPreparedStatementCacheSize(21);
                return mds;
            }
        }
        SQLiteDataSource sds = new SQLiteDataSource();
        sds.setUrl(url);
        sds.setEnforceForeinKeys(true);
        return sds;
    }
}

