/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.data;

import com.nijiko.data.CachedGroupStorage;
import com.nijiko.data.CachedUserStorage;
import com.nijiko.data.GroupStorage;
import com.nijiko.data.SqlGroupStorage;
import com.nijiko.data.SqlStorage;
import com.nijiko.data.SqlUserStorage;
import com.nijiko.data.StorageCreator;
import com.nijiko.data.UserStorage;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.io.File;
import org.bukkit.util.config.Configuration;

public class SqlCreator
implements StorageCreator {
    public UserStorage getUserStorage(String world, int reload, boolean autosave, Configuration config) throws Exception {
        String dbms = config.getString("permissions.storage.dbms", "SQLITE");
        String uri = config.getString("permissions.storage.uri", "jdbc:sqlite:" + Permissions.instance.getDataFolder() + File.separator + "permissions.db");
        String username = config.getString("permissions.storage.username");
        String password = config.getString("permissions.storage.password");
        boolean cached = config.getBoolean("permissions.storage.cache", true);
        SqlStorage.init(dbms, uri, username, password, reload);
        SqlUserStorage sus = SqlStorage.getUserStorage(world);
        if (cached) {
            return new CachedUserStorage(sus);
        }
        return sus;
    }

    public GroupStorage getGroupStorage(String world, int reload, boolean autosave, Configuration config) throws Exception {
        String dbms = config.getString("permissions.storage.dbms", "SQLITE");
        String uri = config.getString("permissions.storage.uri", "jdbc:sqlite:" + Permissions.instance.getDataFolder() + File.separator + "permissions.db");
        String username = config.getString("permissions.storage.username");
        String password = config.getString("permissions.storage.password");
        boolean cached = config.getBoolean("permissions.storage.cache", true);
        SqlStorage.init(dbms, uri, username, password, reload);
        SqlGroupStorage sgs = SqlStorage.getGroupStorage(world);
        if (cached) {
            return new CachedGroupStorage(sgs);
        }
        return sgs;
    }
}

