/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.data;

import com.nijiko.data.GroupWorld;
import com.nijiko.data.SqlStorage;
import com.nijiko.data.Storage;
import com.nijiko.permissions.EntryType;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SqlEntryStorage
implements Storage {
    protected static final int max = 5;
    protected final String world;
    protected int worldId;
    protected Map<String, Integer> idCache = new HashMap<String, Integer>();
    protected static final String permGetText = "SELECT permstring FROM PrPermissions WHERE entryid = ?;";
    protected static final String parentGetText = "SELECT parentid FROM PrInheritance WHERE childid = ? ORDER BY parentorder;";
    protected static final String permAddText = "INSERT IGNORE INTO PrPermissions (entryid, permstring) VALUES (?,?);";
    protected static final String permRemText = "DELETE FROM PrPermissions WHERE entryid = ? AND permstring = ?;";
    protected static final String maxParentText = "SELECT MAX(parentorder) FROM PrInheritance WHERE childid = ?;";
    protected static final String parentAddText = "INSERT IGNORE INTO PrInheritance (childid, parentid, parentorder) VALUES (?,?,?);";
    protected static final String parentRemText = "DELETE FROM PrInheritance WHERE childid = ? AND parentid = ?;";
    protected static final String entryListText = "SELECT name, entryid FROM PrEntries WHERE worldid = ? AND type = ?;";
    protected static final String entryDelText = "DELETE FROM PrEntries WHERE worldid = ? AND entryid = ?;";
    protected static final String dataGetText = "SELECT data FROM PrData WHERE entryid = ? AND path = ?;";
    protected static final String dataModText = "REPLACE INTO PrData (data, entryid, path) VALUES (?,?,?);";
    protected static final String dataDelText = "DELETE FROM PrData WHERE entryid = ? AND path = ?;";

    public SqlEntryStorage(String world, int id) {
        this.worldId = id;
        this.world = world;
        this.reload();
    }

    public Set<String> getPermissions(String name) {
        HashSet<String> permissions = new HashSet<String>();
        if (name != null) {
            int id;
            try {
                id = this.getId(name);
            }
            catch (SQLException e) {
                e.printStackTrace();
                return permissions;
            }
            List<Map<Integer, Object>> results = SqlStorage.runQuery(permGetText, new Object[]{id}, false, 1);
            if (results != null) {
                for (Map<Integer, Object> row : results) {
                    Object o = row.get(1);
                    if (!(o instanceof String)) continue;
                    permissions.add((String)o);
                }
            }
        }
        return permissions;
    }

    public LinkedHashSet<GroupWorld> getParents(String name) {
        LinkedHashSet<GroupWorld> parents = new LinkedHashSet<GroupWorld>();
        if (name != null) {
            int uid;
            try {
                uid = this.getId(name);
            }
            catch (SQLException e) {
                e.printStackTrace();
                return parents;
            }
            List<Map<Integer, Object>> results = SqlStorage.runQuery(parentGetText, new Object[]{uid}, false, 1);
            if (results != null) {
                for (Map<Integer, Object> row : results) {
                    Object o = row.get(1);
                    if (!(o instanceof Integer)) continue;
                    int groupid = (Integer)o;
                    SqlStorage.NameWorldId nw = SqlStorage.getEntryName(groupid);
                    String worldName = SqlStorage.getWorldName(nw.worldid);
                    GroupWorld gw = new GroupWorld(worldName, nw.name);
                    parents.add(gw);
                }
            }
        }
        return parents;
    }

    public void addPermission(String name, String permission) {
        int uid;
        try {
            uid = this.getId(name);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
        SqlStorage.runUpdate(permAddText, new Object[]{uid, permission});
    }

    public void removePermission(String name, String permission) {
        int uid;
        try {
            uid = this.getId(name);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
        SqlStorage.runUpdate(permRemText, new Object[]{uid, permission});
    }

    public void addParent(String name, String groupWorld, String groupName) {
        Object o;
        int uid;
        int gid;
        try {
            gid = SqlStorage.getEntry(groupWorld, groupName, true);
            uid = this.getId(name);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
        int parentOrder = 0;
        List<Map<Integer, Object>> results = SqlStorage.runQuery(maxParentText, new Object[]{uid}, true, 1);
        if (results != null && !results.isEmpty() && (o = results.get(0).get(1)) instanceof Integer) {
            parentOrder = (Integer)o;
        }
        SqlStorage.runUpdate(parentAddText, new Object[]{uid, gid, ++parentOrder});
    }

    public void removeParent(String name, String groupWorld, String groupName) {
        int uid;
        int gid;
        try {
            gid = SqlStorage.getEntry(groupWorld, groupName, true);
            uid = this.getId(name);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
        SqlStorage.runUpdate(parentRemText, new Object[]{uid, gid});
    }

    public Set<String> getEntries() {
        if (this.idCache.isEmpty()) {
            List<Map<Integer, Object>> results = SqlStorage.runQuery(entryListText, new Object[]{this.worldId, (byte)(this.getType() == EntryType.GROUP ? 1 : 0)}, false, 1, 2);
            for (Map<Integer, Object> row : results) {
                Object oName = row.get(1);
                Object oId = row.get(2);
                if (!(oName instanceof String) || !(oId instanceof Integer)) continue;
                this.idCache.put((String)oName, (Integer)oId);
            }
        }
        return this.idCache.keySet();
    }

    public String getWorld() {
        return this.world;
    }

    public void forceSave() {
    }

    public void save() {
    }

    public void reload() {
        this.idCache.clear();
    }

    public boolean isAutoSave() {
        return true;
    }

    public void setAutoSave(boolean autoSave) {
    }

    public boolean create(String name) {
        if (!this.idCache.containsKey(name)) {
            int id = SqlStorage.getEntry(this.world, name, this.getType() == EntryType.GROUP);
            this.idCache.put(name, id);
            return true;
        }
        return false;
    }

    public boolean delete(String name) {
        int id = this.idCache.remove(name);
        int val = SqlStorage.runUpdate(entryDelText, new Object[]{this.worldId, id});
        return val != 0;
    }

    public String getString(String name, String path) {
        int uid;
        String data = null;
        try {
            uid = this.getId(name);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return data;
        }
        List<Map<Integer, Object>> results = SqlStorage.runQuery(dataGetText, new Object[]{uid, path}, true, 1);
        for (Map<Integer, Object> row : results) {
            Object o = row.get(1);
            if (!(o instanceof String)) continue;
            data = (String)o;
        }
        return data;
    }

    public Integer getInt(String name, String path) {
        Integer value;
        String raw = this.getString(name, path);
        if (raw == null) {
            return null;
        }
        try {
            value = Integer.valueOf(raw);
        }
        catch (NumberFormatException e) {
            value = null;
        }
        return value;
    }

    public Double getDouble(String name, String path) {
        Double value;
        String raw = this.getString(name, path);
        if (raw == null) {
            return null;
        }
        try {
            value = Double.valueOf(raw);
        }
        catch (NumberFormatException e) {
            value = null;
        }
        return value;
    }

    public Boolean getBool(String name, String path) {
        String raw = this.getString(name, path);
        if (raw == null) {
            return null;
        }
        if (raw.equalsIgnoreCase("true")) {
            return true;
        }
        if (raw.equalsIgnoreCase("false")) {
            return false;
        }
        return null;
    }

    public void setData(String name, String path, Object data) {
        int uid;
        String szForm = "";
        if (data instanceof Integer) {
            szForm = ((Integer)data).toString();
        } else if (data instanceof Boolean) {
            szForm = ((Boolean)data).toString();
        } else if (data instanceof Double) {
            szForm = ((Double)data).toString();
        } else if (data instanceof String) {
            szForm = (String)data;
        } else {
            throw new IllegalArgumentException("Only ints, bools, doubles and Strings are allowed!");
        }
        try {
            uid = this.getId(name);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
        SqlStorage.runUpdate(dataModText, new Object[]{szForm, uid, path});
    }

    public void removeData(String name, String path) {
        int uid;
        try {
            uid = this.getId(name);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
        SqlStorage.runUpdate(dataDelText, new Object[]{uid, path});
    }

    public Integer getCachedId(String name) {
        return this.idCache.get(name);
    }

    protected abstract int getId(String var1) throws SQLException;
}

