/*
 * Decompiled with CFR 0.152.
 */
package com.enigmasm.serverbot;

import com.enigmasm.serverbot.Bot;
import com.enigmasm.serverbot.Rank;
import com.enigmasm.serverbot.ServerBotListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ServerBot
extends JavaPlugin {
    private ServerBotListener serverBotListener;
    private final String TIME_FORMAT = "hh:mm a";
    private final String DATE_FORMAT = "MM-dd-yyyy";
    Bot botInfo;

    public void onDisable() {
        this.botInfo.saveUsers(this.getConfiguration());
        System.out.println(String.valueOf(this.getDescription().getName()) + " V" + this.getDescription().getVersion() + " disabled. By Enigma-SM.");
    }

    public void onEnable() {
        this.serverBotListener = new ServerBotListener(this);
        System.out.println(String.valueOf(this.getDescription().getName()) + " V" + this.getDescription().getVersion() + " enabled. By Enigma-SM.");
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_CHAT, (Listener)this.serverBotListener, Event.Priority.Highest, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_LOGIN, (Listener)this.serverBotListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_QUIT, (Listener)this.serverBotListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_JOIN, (Listener)this.serverBotListener, Event.Priority.Monitor, (Plugin)this);
        this.loadBotInformation();
    }

    private void loadBotInformation() {
        this.getConfiguration().load();
        if (this.botInfo == null) {
            this.botInfo = new Bot();
        }
        this.botInfo.setName(this.getConfiguration().getString("bot.name"));
        this.botInfo.setColor(this.getConfiguration().getString("bot.color"));
        this.botInfo.loadCatches(this.getConfiguration());
        this.botInfo.loadUsers(this.getConfiguration());
    }

    public Bot getBot() {
        return this.botInfo;
    }

    private String botParse(String caught, Player player) {
        caught = caught.replace("{P}", player.getName());
        caught = caught.replace("{B}", this.getBot().getName());
        caught = caught.replace("{T}", this.getTime());
        caught = caught.replace("{D}", this.getDate());
        caught = caught.replace("{ST}", "" + player.getWorld().getTime());
        caught = caught.replace("{DT}", this.getTimeDecription());
        caught = caught.replace("{SDT}", this.getTimeDescription(player.getWorld()));
        caught = "<" + this.getBot().getDisplayName() + "\u00a7f> " + caught;
        return caught;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (cmd.getName().toLowerCase().equals("bot")) {
            if (args.length == 0) {
                return false;
            }
            return this.botCommand(sender, cmd, commandLabel, args);
        }
        if (cmd.getName().toLowerCase().equals("breload") && sender.isOp()) {
            this.loadBotInformation();
            return true;
        }
        if (cmd.getName().toLowerCase().equals("me") && sender instanceof Player) {
            Player player = (Player)sender;
            String outText = "";
            int i = 0;
            while (i < args.length - 1) {
                outText = String.valueOf(outText) + args[i] + " ";
                ++i;
            }
            outText = String.valueOf(outText) + args[i];
            String caught = this.getBot().getActionCatch(outText);
            if (caught != null) {
                String response = this.botParse(caught, player);
                this.getServer().broadcastMessage("* " + player.getDisplayName() + "\u00a7f " + outText);
                this.getServer().broadcastMessage(response);
            } else {
                this.getServer().broadcastMessage("* " + player.getDisplayName() + "\u00a7f " + outText);
            }
            return true;
        }
        return false;
    }

    private boolean botCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (args[0].equalsIgnoreCase("-friend") || args[0].equalsIgnoreCase("-fr")) {
            int newValue;
            if (args.length != 3) {
                sender.sendMessage("Missing command parameters.");
                return false;
            }
            try {
                newValue = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("That's not a number.");
                return false;
            }
            if (newValue < 0 || newValue > 4) {
                sender.sendMessage("Not within 0 or 4");
                return false;
            }
            Player p = this.getServer().getPlayer(args[1]);
            if (p == null) {
                sender.sendMessage("No such player in server.");
                return false;
            }
            String name = p.getName();
            sender.sendMessage("Adding " + name + " at " + newValue);
            Integer result = this.botInfo.modifyPlayer(name, newValue);
            if (result == null) {
                sender.sendMessage("New user " + name + " in bot's known users added at rank " + (Object)((Object)Rank.intToRank(newValue)));
            } else {
                sender.sendMessage("User " + name + "'s value modified from " + (Object)((Object)Rank.intToRank(result)) + " to " + (Object)((Object)Rank.intToRank(newValue)));
            }
            return true;
        }
        return false;
    }

    private String getTimeDescription(World world) {
        long time = world.getTime();
        if (time < 6000L) {
            return "Morning";
        }
        if (time < 12000L) {
            return "Afternoon";
        }
        return "Evening";
    }

    private String getTimeDecription() {
        SimpleDateFormat sdf = new SimpleDateFormat("HH");
        Calendar cal = Calendar.getInstance();
        String n = sdf.format(cal.getTime());
        int i = Integer.parseInt(n);
        if (i < 6 || i > 18) {
            return "Evening";
        }
        if (i > 6 && i < 12) {
            return "Morning";
        }
        return "Afternoon";
    }

    private String getTime() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm a");
        return sdf.format(cal.getTime());
    }

    private String getDate() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yyyy");
        return sdf.format(cal.getTime());
    }
}

