/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat;

import com.ensifera.animosity.craftirc.CraftIRC;
import com.herocraftonline.dthielke.herochat.HeroChatCraftIRCListener;
import com.herocraftonline.dthielke.herochat.HeroChatPlayerListener;
import com.herocraftonline.dthielke.herochat.HeroChatServerListener;
import com.herocraftonline.dthielke.herochat.channels.Channel;
import com.herocraftonline.dthielke.herochat.channels.ChannelManager;
import com.herocraftonline.dthielke.herochat.channels.ConversationManager;
import com.herocraftonline.dthielke.herochat.command.CommandManager;
import com.herocraftonline.dthielke.herochat.command.commands.BanCommand;
import com.herocraftonline.dthielke.herochat.command.commands.CreateCommand;
import com.herocraftonline.dthielke.herochat.command.commands.FocusCommand;
import com.herocraftonline.dthielke.herochat.command.commands.GMuteCommand;
import com.herocraftonline.dthielke.herochat.command.commands.HelpCommand;
import com.herocraftonline.dthielke.herochat.command.commands.IgnoreCommand;
import com.herocraftonline.dthielke.herochat.command.commands.JoinCommand;
import com.herocraftonline.dthielke.herochat.command.commands.KickCommand;
import com.herocraftonline.dthielke.herochat.command.commands.LeaveCommand;
import com.herocraftonline.dthielke.herochat.command.commands.ListCommand;
import com.herocraftonline.dthielke.herochat.command.commands.ModCommand;
import com.herocraftonline.dthielke.herochat.command.commands.MuteCommand;
import com.herocraftonline.dthielke.herochat.command.commands.QuickMsgCommand;
import com.herocraftonline.dthielke.herochat.command.commands.ReloadCommand;
import com.herocraftonline.dthielke.herochat.command.commands.RemoveCommand;
import com.herocraftonline.dthielke.herochat.command.commands.TellCommand;
import com.herocraftonline.dthielke.herochat.command.commands.ToggleCommand;
import com.herocraftonline.dthielke.herochat.command.commands.WhoCommand;
import com.herocraftonline.dthielke.herochat.util.ConfigManager;
import com.herocraftonline.dthielke.herochat.util.PermissionManager;
import com.nijiko.permissions.PermissionHandler;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class HeroChat
extends JavaPlugin {
    private static Logger log = Logger.getLogger("Minecraft");
    private static Logger chatLog = Logger.getLogger("HeroChat");
    private boolean separateChatLog;
    private ChannelManager channelManager;
    private CommandManager commandManager;
    private ConversationManager conversationManager;
    private ConfigManager configManager;
    private PermissionManager permissionManager;
    private CraftIRC craftIRC;
    private String ircMessageFormat;
    private String ircTag;
    private String tag;
    private String outgoingTellFormat;
    private String incomingTellFormat;
    private List<String> censors;
    private HeroChatServerListener serverListener;
    private HeroChatPlayerListener playerListener;
    private HeroChatCraftIRCListener craftIRCListener;
    private boolean eventsRegistered = false;

    public void onDisable() {
        try {
            Player[] playerArray = this.getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player player = playerArray[n2];
                this.configManager.savePlayer(player.getName());
                ++n2;
            }
            this.configManager.save();
        }
        catch (Exception player) {
            // empty catch block
        }
        PluginDescriptionFile desc = this.getDescription();
        this.log(Level.INFO, String.valueOf(desc.getName()) + " version " + desc.getVersion() + " disabled.");
    }

    public void onEnable() {
        this.channelManager = new ChannelManager(this);
        this.conversationManager = new ConversationManager();
        this.permissionManager = new PermissionManager(null);
        this.registerEvents();
        this.registerCommands();
        try {
            this.configManager = new ConfigManager(this);
            this.configManager.load();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(Level.WARNING, "Error encountered while loading data. Check your config.yml and users.yml. Disabling HeroChat.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Player[] playerArray = this.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            this.playerListener.onPlayerJoin(new PlayerJoinEvent(player, ""));
            ++n2;
        }
        try {
            this.configManager.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(Level.WARNING, "Error encountered while saving data. Disabling HeroChat.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.separateChatLog) {
            this.separateChatLog();
        }
        PluginDescriptionFile desc = this.getDescription();
        this.log(Level.INFO, String.valueOf(desc.getName()) + " version " + desc.getVersion() + " enabled.");
        this.loadPermissions();
        this.loadCraftIRC();
        this.checkConflict("iChat");
        this.checkConflict("EssentialsChat");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return this.commandManager.dispatch(sender, command, label, args);
    }

    private void registerEvents() {
        if (!this.eventsRegistered) {
            this.playerListener = new HeroChatPlayerListener(this);
            this.serverListener = new HeroChatServerListener(this);
            PluginManager pluginManager = this.getServer().getPluginManager();
            pluginManager.registerEvent(Event.Type.PLAYER_CHAT, (Listener)this.playerListener, Event.Priority.High, (Plugin)this);
            pluginManager.registerEvent(Event.Type.PLAYER_JOIN, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
            pluginManager.registerEvent(Event.Type.PLAYER_QUIT, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
            pluginManager.registerEvent(Event.Type.PLAYER_COMMAND_PREPROCESS, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
            pluginManager.registerEvent(Event.Type.PLUGIN_ENABLE, (Listener)this.serverListener, Event.Priority.Normal, (Plugin)this);
            this.eventsRegistered = true;
        }
    }

    private void registerCommands() {
        this.commandManager = new CommandManager();
        this.commandManager.addCommand(new ListCommand(this));
        this.commandManager.addCommand(new WhoCommand(this));
        this.commandManager.addCommand(new FocusCommand(this));
        this.commandManager.addCommand(new JoinCommand(this));
        this.commandManager.addCommand(new LeaveCommand(this));
        this.commandManager.addCommand(new QuickMsgCommand(this));
        this.commandManager.addCommand(new IgnoreCommand(this));
        this.commandManager.addCommand(new TellCommand(this));
        this.commandManager.addCommand(new CreateCommand(this));
        this.commandManager.addCommand(new RemoveCommand(this));
        this.commandManager.addCommand(new ModCommand(this));
        this.commandManager.addCommand(new KickCommand(this));
        this.commandManager.addCommand(new BanCommand(this));
        this.commandManager.addCommand(new MuteCommand(this));
        this.commandManager.addCommand(new GMuteCommand(this));
        this.commandManager.addCommand(new ReloadCommand(this));
        this.commandManager.addCommand(new ToggleCommand(this));
        this.commandManager.addCommand(new HelpCommand(this));
    }

    public void loadPermissions() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("Permissions");
        if (plugin != null && plugin.isEnabled()) {
            PermissionManager ph;
            Permissions permissions = (Permissions)plugin;
            PermissionHandler security = permissions.getHandler();
            this.permissionManager = ph = new PermissionManager(security);
            this.log(Level.INFO, "Permissions " + permissions.getDescription().getVersion() + " found.");
            Player[] playerArray = this.getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player player = playerArray[n2];
                String name = player.getName();
                String group = this.permissionManager.getGroup(player);
                List<Channel> joinedChannels = this.channelManager.getJoinedChannels(name);
                for (Channel channel : joinedChannels) {
                    if (group.isEmpty() || channel.getWhitelist().contains(group) || channel.getWhitelist().isEmpty()) continue;
                    channel.removePlayer(name);
                }
                ++n2;
            }
        }
    }

    public void loadCraftIRC() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("CraftIRC");
        if (plugin != null && plugin.isEnabled()) {
            try {
                this.craftIRC = (CraftIRC)plugin;
                this.craftIRCListener = new HeroChatCraftIRCListener(this);
                this.getServer().getPluginManager().registerEvent(Event.Type.CUSTOM_EVENT, (Listener)this.craftIRCListener, Event.Priority.Normal, (Plugin)this);
                this.log(Level.INFO, "CraftIRC " + this.craftIRC.getDescription().getVersion() + " found.");
            }
            catch (ClassCastException ex) {
                ex.printStackTrace();
                this.log(Level.WARNING, "Error encountered while connecting to CraftIRC!");
                this.craftIRC = null;
                this.craftIRCListener = null;
            }
        }
    }

    private void checkConflict(String pluginName) {
        Plugin plugin = this.getServer().getPluginManager().getPlugin(pluginName);
        if (plugin != null && plugin.isEnabled()) {
            this.issueConflictWarning(plugin);
        }
    }

    public void issueConflictWarning(Plugin conflict) {
        this.log(Level.WARNING, "Conflicting plugin detected: " + conflict.getDescription().getName() + ". If you experience issues, please try disabling this plugin.");
    }

    private void separateChatLog() {
        try {
            chatLog.setUseParentHandlers(false);
            FileHandler fh = new FileHandler(String.valueOf(this.getDataFolder().getAbsolutePath()) + "/chat.log", true);
            fh.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return String.valueOf(new SimpleDateFormat("HH:mm:ss").format(new Date(record.getMillis()))) + " " + record.getMessage() + "\n";
                }
            });
            chatLog.addHandler(fh);
        }
        catch (SecurityException e1) {
            chatLog.setUseParentHandlers(true);
        }
        catch (IOException e1) {
            chatLog.setUseParentHandlers(true);
        }
    }

    public void log(Level level, String msg) {
        log.log(level, "[HeroChat] " + msg.replaceAll("\u00a7[0-9a-f]", ""));
    }

    public void logChat(String msg) {
        chatLog.info(msg.replaceAll("\u00a7[0-9a-f]", ""));
    }

    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public CraftIRC getCraftIRC() {
        return this.craftIRC == null ? null : this.craftIRC;
    }

    public void setIrcTag(String ircTag) {
        this.ircTag = ircTag;
    }

    public String getIrcTag() {
        return this.ircTag;
    }

    public void setIrcMessageFormat(String ircMessageFormat) {
        this.ircMessageFormat = ircMessageFormat;
    }

    public String getIrcMessageFormat() {
        return this.ircMessageFormat;
    }

    public void setCensors(List<String> censors) {
        this.censors = censors;
    }

    public List<String> getCensors() {
        return this.censors;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public void setOutgoingTellFormat(String outgoingTellFormat) {
        this.outgoingTellFormat = outgoingTellFormat;
    }

    public String getOutgoingTellFormat() {
        return this.outgoingTellFormat;
    }

    public void setIncomingTellFormat(String incomingTellFormat) {
        this.incomingTellFormat = incomingTellFormat;
    }

    public String getIncomingTellFormat() {
        return this.incomingTellFormat;
    }

    public void setSeparateChatLog(boolean separateChatLog) {
        this.separateChatLog = separateChatLog;
    }

    public boolean hasSeparateChatLog() {
        return this.separateChatLog;
    }

    public static enum ChatColor {
        BLACK("\u00a70"),
        NAVY("\u00a71"),
        GREEN("\u00a72"),
        BLUE("\u00a73"),
        RED("\u00a74"),
        PURPLE("\u00a75"),
        GOLD("\u00a76"),
        LIGHT_GRAY("\u00a77"),
        GRAY("\u00a78"),
        DARK_PURPLE("\u00a79"),
        LIGHT_GREEN("\u00a7a"),
        LIGHT_BLUE("\u00a7b"),
        ROSE("\u00a7c"),
        LIGHT_PURPLE("\u00a7d"),
        YELLOW("\u00a7e"),
        WHITE("\u00a7f");

        public final String str;

        private ChatColor(String str) {
            this.str = str;
        }
    }
}

