/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.channels;

import com.ensifera.animosity.craftirc.CraftIRC;
import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.ChannelManager;
import com.herocraftonline.dthielke.herochat.event.ChannelChatEvent;
import com.herocraftonline.dthielke.herochat.util.Messaging;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Channel {
    public static final String joinFormat = "{color}[{nick}] ";
    protected HeroChat plugin;
    protected String name;
    protected String nick;
    protected String password;
    protected String msgFormat;
    protected HeroChat.ChatColor color;
    protected boolean enabled;
    protected boolean verbose;
    protected boolean hidden;
    protected boolean forced;
    protected boolean autoJoined;
    protected boolean quickMessagable;
    protected boolean crossWorld;
    protected List<String> players;
    protected List<String> moderators;
    protected List<String> blacklist;
    protected List<String> whitelist;
    protected List<String> voicelist;
    protected List<String> mutelist;
    protected List<String> worlds;
    protected List<String> gameToIRCTags;
    protected List<String> IRCToGameTags;

    public Channel(HeroChat plugin) {
        this.plugin = plugin;
        this.name = "DefaultName";
        this.nick = "DefaultNick";
        this.password = "";
        this.msgFormat = "{default}";
        this.color = HeroChat.ChatColor.WHITE;
        this.enabled = true;
        this.verbose = false;
        this.hidden = false;
        this.forced = false;
        this.autoJoined = false;
        this.quickMessagable = false;
        this.crossWorld = true;
        this.players = new ArrayList<String>();
        this.moderators = new ArrayList<String>();
        this.blacklist = new ArrayList<String>();
        this.whitelist = new ArrayList<String>();
        this.voicelist = new ArrayList<String>();
        this.mutelist = new ArrayList<String>();
        this.worlds = new ArrayList<String>();
        this.IRCToGameTags = new ArrayList<String>();
        this.gameToIRCTags = new ArrayList<String>();
    }

    public void sendMessage(String source, String msg, String format, boolean sentByPlayer) {
        this.sendMessage(source, msg, format, this.players, sentByPlayer, true);
    }

    public void sendMessage(String source, String msg, String format, boolean sentByPlayer, boolean includeSender) {
        this.sendMessage(source, msg, format, this.players, sentByPlayer, includeSender);
    }

    public void sendMessage(String source, String msg, String format, List<String> recipients, boolean sentByPlayer, boolean includeSender) {
        ChannelChatEvent event = new ChannelChatEvent(Event.Type.CUSTOM_EVENT, this, source, msg, format, sentByPlayer);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        source = event.getSource();
        msg = event.getMessage();
        format = event.getFormat();
        sentByPlayer = event.isSentByPlayer();
        if (!event.isCancelled()) {
            if (sentByPlayer) {
                Player sender = this.plugin.getServer().getPlayer(source);
                if (sender != null) {
                    if (this.enabled || this.plugin.getPermissionManager().isAdmin(sender) || this.moderators.contains(source)) {
                        String group = this.plugin.getPermissionManager().getGroup(sender);
                        if (group == null || this.voicelist.contains(group) || this.voicelist.isEmpty()) {
                            if (!this.plugin.getChannelManager().getMutelist().contains(sender.getName())) {
                                if (!this.mutelist.contains(sender.getName())) {
                                    if (this.worlds.isEmpty() || this.worlds.contains(sender.getWorld().getName())) {
                                        boolean color = this.plugin.getPermissionManager().isAllowedColor(sender);
                                        this.sendUncheckedMessage(source, msg, format, sentByPlayer, this.players, includeSender, color);
                                    } else {
                                        sender.sendMessage(String.valueOf(this.plugin.getTag()) + "You are not in the correct world for " + this.getCName());
                                    }
                                } else {
                                    sender.sendMessage(String.valueOf(this.plugin.getTag()) + "You are muted in " + this.getCName());
                                }
                            } else {
                                sender.sendMessage(String.valueOf(this.plugin.getTag()) + "You are globally muted");
                            }
                        } else {
                            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "You cannot speak in " + this.getCName());
                        }
                    } else {
                        sender.sendMessage(String.valueOf(this.plugin.getTag()) + "This channel is disabled");
                    }
                }
            } else if (this.enabled) {
                this.sendUncheckedMessage(source, msg, format, sentByPlayer, this.players, includeSender, true);
            }
        }
    }

    public void sendMessage(String name, String msg) {
        this.sendMessage(name, msg, this.msgFormat, true);
    }

    protected void sendUncheckedMessage(String source, String msg, String format, boolean sentByPlayer, List<String> recipients, boolean includeSender, boolean color) {
        String formattedMsg = Messaging.format(this.plugin, this, format, source, "", msg, sentByPlayer, color);
        ChannelManager cm = this.plugin.getChannelManager();
        for (String recipientName : recipients) {
            Player recipient;
            if (!this.players.contains(recipientName) || cm.isIgnoring(recipientName, source) || (recipient = this.plugin.getServer().getPlayer(recipientName)) == null || !includeSender && recipient.getName().equals(source)) continue;
            String world = recipient.getWorld().getName();
            if (!this.worlds.isEmpty() && !this.worlds.contains(world) || !this.crossWorld && sentByPlayer && !this.plugin.getServer().getPlayer(source).getWorld().getName().equals(world)) continue;
            recipient.sendMessage(formattedMsg);
        }
        if (sentByPlayer) {
            this.sendIRCMessage(source, msg);
        }
        this.plugin.logChat(formattedMsg);
    }

    protected void sendIRCMessage(String source, String msg) {
        CraftIRC irc = this.plugin.getCraftIRC();
        if (irc != null) {
            String ircMsg = Messaging.format(this.plugin, this, this.plugin.getIrcMessageFormat(), source, "", msg, true, false);
            for (String tag : this.gameToIRCTags) {
                this.plugin.getCraftIRC().sendMessageToTag(ircMsg, tag);
            }
        }
    }

    public void addPlayer(String name) {
        if (!this.players.contains(name) && !this.blacklist.contains(name)) {
            this.players.add(name);
            if (this.verbose) {
                String displayName = name;
                Player p = this.plugin.getServer().getPlayer(name);
                if (p != null) {
                    displayName = p.getDisplayName();
                }
                String msg = "\u00a7f" + displayName + this.color.str + " has joined the channel";
                this.sendMessage(name, msg, joinFormat, this.players, false, false);
            }
        }
    }

    public void removePlayer(String name) {
        if (this.players.contains(name)) {
            this.players.remove(name);
            if (this.verbose) {
                String displayName = name;
                Player p = this.plugin.getServer().getPlayer(name);
                if (p != null) {
                    displayName = p.getDisplayName();
                }
                String msg = "\u00a7f" + displayName + this.color.str + " has left the channel";
                this.sendMessage(name, msg, joinFormat, this.players, false, false);
            }
        }
    }

    public String getCName() {
        return String.valueOf(this.color.str) + this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNick() {
        return this.nick;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public HeroChat.ChatColor getColor() {
        return this.color;
    }

    public void setColor(HeroChat.ChatColor color) {
        this.color = color;
    }

    public List<String> getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(List<String> blacklist) {
        this.blacklist = blacklist;
    }

    public List<String> getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(List<String> whitelist) {
        this.whitelist = whitelist;
    }

    public List<String> getVoicelist() {
        return this.voicelist;
    }

    public void setVoicelist(List<String> voicelist) {
        this.voicelist = voicelist;
    }

    public List<String> getPlayers() {
        return this.players;
    }

    public String getMsgFormat() {
        return this.msgFormat;
    }

    public void setMsgFormat(String msgFormat) {
        this.msgFormat = msgFormat;
    }

    public List<String> getModerators() {
        return this.moderators;
    }

    public void setModerators(List<String> moderators) {
        this.moderators = moderators;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public boolean isAutoJoined() {
        return this.autoJoined;
    }

    public void setAutoJoined(boolean autoJoined) {
        this.autoJoined = autoJoined;
    }

    public boolean isQuickMessagable() {
        return this.quickMessagable;
    }

    public void setQuickMessagable(boolean quickMessagable) {
        this.quickMessagable = quickMessagable;
    }

    public List<String> getWorlds() {
        return this.worlds;
    }

    public void setWorlds(List<String> worlds) {
        this.worlds = worlds;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<String> getMutelist() {
        return this.mutelist;
    }

    public void setMutelist(List<String> mutelist) {
        this.mutelist = mutelist;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isCrossWorld() {
        return this.crossWorld;
    }

    public void setCrossWorld(boolean crossWorld) {
        this.crossWorld = crossWorld;
    }

    public List<String> getGameToIRCTags() {
        return this.gameToIRCTags;
    }

    public void setGameToIRCTags(List<String> gameToIRCTags) {
        this.gameToIRCTags = gameToIRCTags;
    }

    public List<String> getIRCToGameTags() {
        return this.IRCToGameTags;
    }

    public void setIRCToGameTags(List<String> iRCToGameTags) {
        this.IRCToGameTags = iRCToGameTags;
    }
}

