/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.channels;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.Channel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.entity.Player;

public class ChannelManager {
    private HeroChat plugin;
    private List<Channel> channels;
    private Channel defaultChannel;
    private String defaultMsgFormat;
    private HashMap<String, String> activeChannels;
    private HashMap<String, List<String>> ignoreLists;
    private List<String> mutelist;

    public ChannelManager(HeroChat plugin) {
        this.plugin = plugin;
        this.activeChannels = new HashMap();
        this.ignoreLists = new HashMap();
        this.mutelist = new ArrayList<String>();
    }

    public String[] getPlayerList() {
        return this.activeChannels.keySet().toArray(new String[0]);
    }

    public void removeFromAll(String name) {
        for (Channel c : this.channels) {
            c.removePlayer(name);
        }
    }

    public void joinAutoChannels(String name) {
        Player player = this.plugin.getServer().getPlayer(name);
        if (player != null) {
            String group = this.plugin.getPermissionManager().getGroup(player);
            for (Channel c : this.channels) {
                if (!c.isAutoJoined() || !c.getWhitelist().isEmpty() && !c.getWhitelist().contains(group)) continue;
                c.addPlayer(name);
            }
        }
    }

    public List<Channel> getJoinedChannels(String name) {
        ArrayList<Channel> list = new ArrayList<Channel>();
        for (Channel c : this.channels) {
            if (!c.getPlayers().contains(name)) continue;
            list.add(c);
        }
        if (list.isEmpty()) {
            this.defaultChannel.addPlayer(name);
            list.add(this.defaultChannel);
        }
        return list;
    }

    public Channel getActiveChannel(String name) {
        String active = this.activeChannels.get(name);
        if (active == null) {
            this.activeChannels.put(name, this.defaultChannel.getName());
            return this.defaultChannel;
        }
        return this.getChannel(active);
    }

    public void setActiveChannel(String player, String channel) {
        if (channel != null) {
            this.activeChannels.put(player, channel);
        } else {
            this.activeChannels.remove(player);
        }
    }

    public boolean isIgnoring(String ignorer, String ignoree) {
        List<String> ignoreList = this.ignoreLists.get(ignorer);
        if (ignoreList != null) {
            return ignoreList.contains(ignoree);
        }
        return false;
    }

    public void addIgnore(String ignorer, String ignoree) {
        List<String> ignoreList = this.ignoreLists.get(ignorer);
        if (ignoreList == null) {
            ignoreList = new ArrayList<String>();
        }
        ignoreList.add(ignoree);
        this.ignoreLists.put(ignorer, ignoreList);
    }

    public void removeIgnore(String ignorer, String ignoree) {
        List<String> ignoreList = this.ignoreLists.get(ignorer);
        if (ignoreList != null) {
            ignoreList.remove(ignoree);
        }
    }

    public List<String> getIgnoreList(String name) {
        List<String> ignoreList = this.ignoreLists.get(name);
        if (ignoreList == null) {
            ignoreList = new ArrayList<String>();
        }
        return ignoreList;
    }

    public void setIgnoreList(String name, List<String> ignoreList) {
        this.ignoreLists.put(name, ignoreList);
    }

    public Channel getChannel(String name) {
        for (Channel c : this.channels) {
            if (!c.getName().equalsIgnoreCase(name) && !c.getNick().equalsIgnoreCase(name)) continue;
            return c;
        }
        return null;
    }

    public void addChannel(Channel c) {
        this.channels.add(c);
    }

    public void removeChannel(Channel c) {
        this.channels.remove(c);
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    public void setDefaultChannel(Channel defaultChannel) {
        this.defaultChannel = defaultChannel;
    }

    public Channel getDefaultChannel() {
        return this.defaultChannel;
    }

    public void setDefaultMsgFormat(String defaultMsgFormat) {
        this.defaultMsgFormat = defaultMsgFormat;
    }

    public String getDefaultMsgFormat() {
        return this.defaultMsgFormat;
    }

    public void setMutelist(List<String> mutelist) {
        this.mutelist = mutelist;
    }

    public List<String> getMutelist() {
        return this.mutelist;
    }
}

