/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.channels;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.Channel;
import com.herocraftonline.dthielke.herochat.event.ChannelChatEvent;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class LocalChannel
extends Channel {
    protected int distance = 100;

    public LocalChannel(HeroChat plugin) {
        super(plugin);
    }

    @Override
    public void sendMessage(String name, String msg) {
        Player sender;
        ChannelChatEvent event = new ChannelChatEvent(Event.Type.CUSTOM_EVENT, this, name, msg, this.msgFormat, true);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        name = event.getSource();
        msg = event.getMessage();
        String format = event.getFormat();
        boolean sentByPlayer = event.isSentByPlayer();
        if (!event.isCancelled() && (sender = this.plugin.getServer().getPlayer(name)) != null) {
            if (this.enabled || this.plugin.getPermissionManager().isAdmin(sender) || this.moderators.contains(name)) {
                String group = this.plugin.getPermissionManager().getGroup(sender);
                if (group == null || this.voicelist.contains(group) || this.voicelist.isEmpty()) {
                    if (!this.plugin.getChannelManager().getMutelist().contains(sender.getName())) {
                        if (!this.mutelist.contains(sender.getName())) {
                            if (this.worlds.isEmpty() || this.worlds.contains(sender.getWorld().getName())) {
                                List<String> recipients = this.getListeners(sender);
                                boolean color = this.plugin.getPermissionManager().isAllowedColor(sender);
                                this.sendUncheckedMessage(name, msg, format, sentByPlayer, recipients, true, color);
                                if (recipients.size() == 1) {
                                    sender.sendMessage("\u00a78No one hears you.");
                                }
                            } else {
                                sender.sendMessage(String.valueOf(this.plugin.getTag()) + "You are not in the correct world for " + this.getCName());
                            }
                        } else {
                            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "You are muted in " + this.getCName());
                        }
                    } else {
                        sender.sendMessage(String.valueOf(this.plugin.getTag()) + "You are globally muted");
                    }
                } else {
                    sender.sendMessage(String.valueOf(this.plugin.getTag()) + "You cannot speak in " + this.getCName());
                }
            } else {
                sender.sendMessage(String.valueOf(this.plugin.getTag()) + "This channel is disabled");
            }
        }
    }

    private List<String> getListeners(Player origin) {
        ArrayList<String> list = new ArrayList<String>();
        Location sLoc = origin.getLocation();
        String sWorld = sLoc.getWorld().getName();
        for (String name : this.players) {
            int d;
            Location pLoc;
            Player player = this.plugin.getServer().getPlayer(name);
            if (player == null || this.plugin.getChannelManager().isIgnoring(name, origin.getName()) || !sWorld.equals((pLoc = player.getLocation()).getWorld().getName())) continue;
            int dx = sLoc.getBlockX() - pLoc.getBlockX();
            int dz = sLoc.getBlockZ() - pLoc.getBlockZ();
            if ((d = (int)Math.sqrt((dx *= dx) + (dz *= dz))) > this.distance) continue;
            list.add(player.getName());
        }
        return list;
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }
}

