/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.command;

import com.herocraftonline.dthielke.herochat.HeroChat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;

public abstract class BaseCommand {
    protected HeroChat plugin;
    protected String name;
    protected String description;
    protected String usage;
    protected int minArgs;
    protected int maxArgs;
    protected List<String> identifiers;
    protected List<String> notes;

    public BaseCommand(HeroChat plugin) {
        this.plugin = plugin;
        this.identifiers = new ArrayList<String>();
        this.notes = new ArrayList<String>();
    }

    public abstract void execute(CommandSender var1, String[] var2);

    public String[] validate(String input, StringBuilder identifier) {
        String match = this.matchIdentifier(input);
        if (match != null) {
            int l;
            int i = (identifier = identifier.append(match)).length();
            String[] args = input.substring(i).trim().split(" ");
            if (args[0].isEmpty()) {
                args = new String[]{};
            }
            if ((l = args.length) >= this.minArgs && l <= this.maxArgs) {
                return args;
            }
        }
        return null;
    }

    public String matchIdentifier(String input) {
        String lower = input.toLowerCase();
        int index = -1;
        int n = this.identifiers.size();
        int i = 0;
        while (i < n) {
            String identifier = this.identifiers.get(i).toLowerCase();
            if (lower.matches(String.valueOf(identifier) + "(\\s+.*|\\s*)") && (index == -1 || identifier.length() > this.identifiers.get(index).length())) {
                index = i;
            }
            ++i;
        }
        if (index != -1) {
            return this.identifiers.get(index);
        }
        return null;
    }

    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<String> identifiers) {
        this.identifiers = identifiers;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }

    public List<String> getNotes() {
        return this.notes;
    }
}

