/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.command.commands;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.Channel;
import com.herocraftonline.dthielke.herochat.channels.ChannelManager;
import com.herocraftonline.dthielke.herochat.command.BaseCommand;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CreateCommand
extends BaseCommand {
    private static final String[] RESERVED_NAMES = new String[]{"ch", "join", "leave", "ignore", "help", "ban", "create", "kick", "list", "mod", "qm", "reload", "remove", "who"};

    public CreateCommand(HeroChat plugin) {
        super(plugin);
        this.name = "Create";
        this.description = "Creates a channel";
        this.usage = "\u00a7e/ch create \u00a79<name> <nick> \u00a78[p:pass] [color:#] [-options]";
        this.minArgs = 2;
        this.maxArgs = 5;
        this.identifiers.add("ch create");
        this.notes.add("\u00a7cOptions (combinable, ie. -hsqf):");
        this.notes.add("-h   Hidden from /ch channels list");
        this.notes.add("-j   Show join and leave messages");
        this.notes.add("\u00a7cAdmin-only options:");
        this.notes.add("-a   Automatically joined by new users");
        this.notes.add("-q   Allow quick message shortcut");
        this.notes.add("-f   Force users to stay in this channel");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        ChannelManager cm = this.plugin.getChannelManager();
        if (sender instanceof Player) {
            Player creator = (Player)sender;
            if (this.plugin.getPermissionManager().canCreate(creator)) {
                String[] stringArray = RESERVED_NAMES;
                int n = RESERVED_NAMES.length;
                int n2 = 0;
                while (n2 < n) {
                    String reserved = stringArray[n2];
                    if (args[0].equalsIgnoreCase(reserved)) {
                        sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cThat name is reserved");
                        return;
                    }
                    if (args[1].equalsIgnoreCase(reserved)) {
                        sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cThat nick is reserved");
                        return;
                    }
                    ++n2;
                }
                if (cm.getChannel(args[0]) != null) {
                    sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cThat name is taken");
                    return;
                }
                if (cm.getChannel(args[1]) != null) {
                    sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cThat nick is taken");
                    return;
                }
                Channel c = this.createChannel(args, this.plugin.getPermissionManager().isAdmin(creator));
                if (c != null) {
                    String name = creator.getName();
                    c.getModerators().add(name);
                    c.addPlayer(name);
                    cm.addChannel(c);
                    cm.setActiveChannel(name, c.getName());
                    sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cCreated channel " + c.getCName());
                    try {
                        this.plugin.getConfigManager().save();
                    }
                    catch (Exception e) {
                        this.plugin.log(Level.WARNING, "Error encountered while saving data. Disabling HeroChat.");
                        this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
                        return;
                    }
                } else {
                    sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cInvalid syntax. Type /ch create ? for info");
                }
            } else {
                sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou cannot create channels");
            }
        } else {
            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou must be a player to create channels");
        }
    }

    private Channel createChannel(String[] args, boolean full) {
        Channel c = new Channel(this.plugin);
        c.setName(args[0]);
        c.setNick(args[1]);
        c.setMsgFormat("{default}");
        int i = 2;
        while (i < args.length) {
            String tmp = args[i].toLowerCase();
            if (tmp.startsWith("p:")) {
                c.setPassword(tmp.substring(2));
            } else if (tmp.startsWith("color:")) {
                try {
                    int color = Integer.parseInt(tmp.substring(6), 16);
                    c.setColor(HeroChat.ChatColor.values()[color]);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            } else if (tmp.startsWith("-")) {
                tmp = tmp.substring(1);
                this.applyOptions(c, tmp.toCharArray(), full);
            }
            ++i;
        }
        return c;
    }

    private void applyOptions(Channel c, char[] args, boolean full) {
        char[] cArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            char option = cArray[n2];
            switch (option) {
                case 'h': {
                    c.setHidden(true);
                    break;
                }
                case 'j': {
                    c.setVerbose(true);
                    break;
                }
                case 'a': {
                    if (!full) break;
                    c.setAutoJoined(true);
                    break;
                }
                case 'q': {
                    if (!full) break;
                    c.setQuickMessagable(true);
                    break;
                }
                case 'f': {
                    if (!full) break;
                    c.setForced(true);
                }
            }
            ++n2;
        }
    }
}

