/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.command.commands;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.Channel;
import com.herocraftonline.dthielke.herochat.channels.ChannelManager;
import com.herocraftonline.dthielke.herochat.command.BaseCommand;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KickCommand
extends BaseCommand {
    public KickCommand(HeroChat plugin) {
        super(plugin);
        this.name = "Kick";
        this.description = "Removes a player from a channel";
        this.usage = "\u00a7e/ch kick \u00a79<channel> <player>";
        this.minArgs = 2;
        this.maxArgs = 2;
        this.identifiers.add("ch kick");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        ChannelManager cm = this.plugin.getChannelManager();
        Channel channel = cm.getChannel(args[0]);
        if (channel != null) {
            if (sender instanceof Player) {
                Player kicker = (Player)sender;
                if (this.plugin.getPermissionManager().isAdmin(kicker) || channel.getModerators().contains(kicker.getName())) {
                    Player kickee = this.plugin.getServer().getPlayer(args[1]);
                    if (kickee != null) {
                        String name = kickee.getName();
                        if (!this.plugin.getPermissionManager().isAdmin(kickee) && !channel.getModerators().contains(name)) {
                            if (channel.getPlayers().contains(name)) {
                                channel.removePlayer(name);
                                kicker.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7c" + name + " has been kicked from " + channel.getCName());
                                kickee.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou have been kicked from " + channel.getCName());
                                if (cm.getActiveChannel(name).equals(channel)) {
                                    List<Channel> joined = cm.getJoinedChannels(name);
                                    cm.setActiveChannel(name, joined.get(0).getName());
                                    kickee.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cSet active channel to " + cm.getActiveChannel(name).getCName());
                                }
                            } else {
                                kicker.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7c" + name + " is not in " + channel.getCName());
                            }
                        } else {
                            kicker.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou cannot kick " + name + " from " + channel.getCName());
                        }
                    } else {
                        kicker.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cPlayer not found");
                    }
                } else {
                    kicker.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou do not have sufficient permission");
                }
            } else {
                sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou must be a player to use this command");
            }
        } else {
            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cChannel not found");
        }
    }
}

