/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.command.commands;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.Channel;
import com.herocraftonline.dthielke.herochat.command.BaseCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ListCommand
extends BaseCommand {
    private static final int CHANNELS_PER_PAGE = 9;

    public ListCommand(HeroChat plugin) {
        super(plugin);
        this.name = "List";
        this.description = "Lists all publicly available channels";
        this.usage = "\u00a7e/ch list \u00a78[page#]";
        this.minArgs = 0;
        this.maxArgs = 1;
        this.identifiers.add("ch list");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        int p;
        String name = sender instanceof Player ? ((Player)sender).getName() : "";
        List<Channel> visible = this.getVisibleChannels(this.plugin.getChannelManager().getChannels(), name);
        int pages = (int)Math.ceil((double)visible.size() / 9.0);
        if (args.length == 0) {
            p = 1;
        } else {
            try {
                p = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7c" + this.usage);
                return;
            }
        }
        if (p > pages) {
            p = pages;
        }
        sender.sendMessage("\u00a7c-----[ \u00a7fChannel List <" + p + "/" + pages + ">\u00a7c ]-----");
        int i = 0;
        while (i < 9) {
            int index = (p - 1) * 9 + i;
            if (index >= visible.size()) break;
            Channel c = visible.get(index);
            String msg = "  " + c.getColor().str + "[" + c.getNick() + "] " + c.getName();
            if (c.getPlayers().contains(name)) {
                msg = msg.concat(" *");
            }
            sender.sendMessage(msg);
            ++i;
        }
    }

    private List<Channel> getVisibleChannels(List<Channel> channels, String name) {
        ArrayList<Channel> visible = new ArrayList<Channel>();
        for (Channel c : channels) {
            if (c.isHidden() && !c.getPlayers().contains(name)) continue;
            visible.add(c);
        }
        return visible;
    }
}

