/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.command.commands;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.ConversationManager;
import com.herocraftonline.dthielke.herochat.command.BaseCommand;
import com.herocraftonline.dthielke.herochat.util.Messaging;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TellCommand
extends BaseCommand {
    public TellCommand(HeroChat plugin) {
        super(plugin);
        this.name = "Tell";
        this.description = "Starts or ends a private conversation";
        this.usage = "\u00a7e/ch tell \u00a79<player> \u00a78[msg] \u00a7eOR /tell \u00a79<player> \u00a78[msg]";
        this.minArgs = 0;
        this.maxArgs = 100000;
        this.identifiers.add("tell");
        this.identifiers.add("ch tell");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player teller = (Player)sender;
            ConversationManager cm = this.plugin.getConversationManager();
            if (args.length == 1) {
                Player tellee = this.plugin.getServer().getPlayer(args[0]);
                if (tellee != null) {
                    if (tellee != teller) {
                        cm.start(teller, tellee);
                        teller.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cStarted conversation with " + tellee.getName());
                    }
                } else {
                    teller.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cPlayer not found");
                }
            } else if (args.length == 0) {
                if (cm.hasActive(teller)) {
                    cm.end(teller);
                    teller.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cEnded your conversation");
                }
            } else {
                Player tellee = this.plugin.getServer().getPlayer(args[0]);
                if (tellee != null) {
                    if (tellee != teller) {
                        String msg = "";
                        int i = 1;
                        while (i < args.length) {
                            msg = String.valueOf(msg) + args[i] + " ";
                            ++i;
                        }
                        String outgoing = Messaging.format(this.plugin, null, this.plugin.getOutgoingTellFormat(), teller.getName(), tellee.getName(), msg, true, this.plugin.getPermissionManager().isAllowedColor(teller));
                        String incoming = Messaging.format(this.plugin, null, this.plugin.getIncomingTellFormat(), teller.getName(), tellee.getName(), msg, true, this.plugin.getPermissionManager().isAllowedColor(teller));
                        tellee.sendMessage(incoming);
                        teller.sendMessage(outgoing);
                        this.plugin.log(Level.INFO, String.valueOf(teller.getName()) + " -> " + tellee.getName() + ": " + msg);
                    }
                } else {
                    teller.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cPlayer not found");
                }
            }
        }
    }
}

