/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.command.commands;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.Channel;
import com.herocraftonline.dthielke.herochat.command.BaseCommand;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WhoCommand
extends BaseCommand {
    public WhoCommand(HeroChat plugin) {
        super(plugin);
        this.name = "Who";
        this.description = "Lists all users in your active channel";
        this.usage = "\u00a7e/ch who";
        this.minArgs = 0;
        this.maxArgs = 0;
        this.identifiers.add("ch who");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            String name = player.getName();
            Channel c = this.plugin.getChannelManager().getActiveChannel(name);
            if (c != null) {
                List<String> players = c.getPlayers();
                String playerList = "\u00a7cCurrently in " + c.getCName() + "\u00a7f: ";
                for (String pName : players) {
                    Player p = this.plugin.getServer().getPlayer(pName);
                    if (p == null) continue;
                    if (this.plugin.getPermissionManager().isAdmin(p)) {
                        pName = "@" + pName;
                    } else if (c.getModerators().contains(pName)) {
                        pName = String.valueOf(pName) + "*";
                    }
                    pName = String.valueOf(pName) + ", ";
                    playerList = String.valueOf(playerList) + pName;
                }
                playerList = playerList.substring(0, playerList.length() - 2);
                sender.sendMessage(playerList);
            }
        } else {
            sender.sendMessage(String.valueOf(this.plugin.getTag()) + "\u00a7cYou must be a player to use this command");
        }
    }
}

