/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.dthielke.herochat.util;

import com.herocraftonline.dthielke.herochat.HeroChat;
import com.herocraftonline.dthielke.herochat.channels.Channel;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;

public class Messaging {
    private static final String[] HEALTH_COLORS = new String[]{"\u00a70", "\u00a74", "\u00a76", "\u00a7e", "\u00a72"};

    public static String format(HeroChat plugin, Channel channel, String format, String sender, String receiver, String msg, boolean sentByPlayer, boolean allowColor) {
        msg = allowColor ? msg.replaceAll("&([0-9a-f])", "\u00a7$1") : msg.replaceAll("\u00a7[0-9a-f]", "");
        List<String> censors = plugin.getCensors();
        for (String censor : censors) {
            String[] split = censor.split(";", 2);
            msg = split.length == 1 ? Messaging.censorMsg(msg, censor, false, "") : Messaging.censorMsg(msg, split[0], true, split[1]);
        }
        String leader = Messaging.createLeader(plugin, channel, format, sender, receiver, msg, sentByPlayer);
        return String.valueOf(leader) + msg;
    }

    private static String censorMsg(String msg, String censor, boolean customReplacement, String replacement) {
        Pattern pattern = Pattern.compile(censor, 2);
        Matcher matcher = pattern.matcher(msg);
        StringBuilder censoredMsg = new StringBuilder();
        while (matcher.find()) {
            String match = matcher.group();
            if (!customReplacement) {
                char[] replaceChars = new char[match.length()];
                Arrays.fill(replaceChars, '*');
                replacement = new String(replaceChars);
            }
            censoredMsg.append(String.valueOf(msg.substring(0, matcher.start())) + replacement);
            msg = msg.substring(matcher.end());
            matcher = pattern.matcher(msg);
        }
        censoredMsg.append(msg);
        return censoredMsg.toString();
    }

    private static String createLeader(HeroChat plugin, Channel channel, String format, String senderName, String receiverName, String msg, boolean sentByPlayer) {
        String prefix = "";
        String suffix = "";
        String group = "";
        String groupPrefix = "";
        String groupSuffix = "";
        String world = "";
        String healthBar = "";
        if (sentByPlayer) {
            try {
                Player sender = plugin.getServer().getPlayer(senderName);
                if (sender != null) {
                    prefix = plugin.getPermissionManager().getPrefix(sender);
                    suffix = plugin.getPermissionManager().getSuffix(sender);
                    group = plugin.getPermissionManager().getGroup(sender);
                    groupPrefix = plugin.getPermissionManager().getGroupPrefix(sender);
                    groupSuffix = plugin.getPermissionManager().getGroupSuffix(sender);
                    world = sender.getWorld().getName();
                    senderName = sender.getDisplayName();
                    healthBar = Messaging.createHealthBar(sender);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                plugin.log(Level.WARNING, "Error encountered while fetching prefixes/suffixes from Permissions. Is Permissions properly configured and up to date?");
            }
        }
        String leader = format;
        leader = leader.replace("{default}", plugin.getChannelManager().getDefaultMsgFormat());
        leader = leader.replaceAll("&([0-9a-f])", "\u00a7$1");
        leader = leader.replace("{prefix}", prefix);
        leader = leader.replace("{suffix}", suffix);
        leader = leader.replace("{group}", group);
        leader = leader.replace("{groupprefix}", groupPrefix);
        leader = leader.replace("{groupSuffix}", groupSuffix);
        if (channel != null) {
            leader = leader.replace("{nick}", channel.getNick());
            leader = leader.replace("{name}", channel.getName());
            leader = leader.replace("{color}", channel.getColor().str);
            leader = leader.replace("{color.CHANNEL}", channel.getColor().str);
        }
        leader = leader.replace("{player}", senderName);
        leader = leader.replace("{receiver}", receiverName);
        leader = leader.replace("{healthbar}", healthBar);
        leader = leader.replace("{world}", world);
        Matcher matcher = Pattern.compile("\\{color.[a-zA-Z_]+\\}").matcher(leader);
        while (matcher.find()) {
            String match = matcher.group();
            String colorString = match.substring(7, match.length() - 1);
            leader = leader.replaceAll("\\Q" + match + "\\E", HeroChat.ChatColor.valueOf((String)colorString).str);
        }
        return leader;
    }

    private static String createHealthBar(Player player) {
        int health = player.getHealth();
        if (health < 0) {
            health = 0;
        }
        int fullBars = health / 4;
        int remainder = health % 4;
        String healthBar = "";
        int i = 0;
        while (i < fullBars) {
            healthBar = String.valueOf(healthBar) + HEALTH_COLORS[4] + "|";
            ++i;
        }
        int barsLeft = 5 - fullBars;
        if (barsLeft > 0) {
            healthBar = String.valueOf(healthBar) + HEALTH_COLORS[remainder] + "|";
            --barsLeft;
            int i2 = 0;
            while (i2 < barsLeft) {
                healthBar = String.valueOf(healthBar) + HEALTH_COLORS[0] + "|";
                ++i2;
            }
        }
        return healthBar;
    }
}

