/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50;

import com.gmail.nossr50.config.LoadProperties;
import com.gmail.nossr50.datatypes.PlayerStat;
import com.gmail.nossr50.datatypes.SkillType;
import com.gmail.nossr50.datatypes.Tree;
import com.gmail.nossr50.m;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Leaderboard {
    static String location = "plugins/mcMMO/FlatFileStuff/mcmmo.users";
    protected static final Logger log = Logger.getLogger("Minecraft");

    public static void makeLeaderboards() {
        Tree Mining2 = new Tree();
        Tree WoodCutting2 = new Tree();
        Tree Herbalism2 = new Tree();
        Tree Excavation2 = new Tree();
        Tree Acrobatics2 = new Tree();
        Tree Repair2 = new Tree();
        Tree Swords2 = new Tree();
        Tree Axes2 = new Tree();
        Tree Archery2 = new Tree();
        Tree Unarmed2 = new Tree();
        Tree Taming2 = new Tree();
        Tree PowerLevel = new Tree();
        try {
            FileReader file = new FileReader(location);
            BufferedReader in = new BufferedReader(file);
            String line = "";
            while ((line = in.readLine()) != null) {
                String[] character = line.split(":");
                String p = character[0];
                int Plvl = 0;
                if (character.length > 1 && m.isInt(character[1])) {
                    Mining2.add(p, Integer.valueOf(character[1]));
                    Plvl += Integer.valueOf(character[1]).intValue();
                }
                if (character.length > 5 && m.isInt(character[5])) {
                    WoodCutting2.add(p, Integer.valueOf(character[5]));
                    Plvl += Integer.valueOf(character[5]).intValue();
                }
                if (character.length > 7 && m.isInt(character[7])) {
                    Repair2.add(p, Integer.valueOf(character[7]));
                    Plvl += Integer.valueOf(character[7]).intValue();
                }
                if (character.length > 8 && m.isInt(character[8])) {
                    Unarmed2.add(p, Integer.valueOf(character[8]));
                    Plvl += Integer.valueOf(character[8]).intValue();
                }
                if (character.length > 9 && m.isInt(character[9])) {
                    Herbalism2.add(p, Integer.valueOf(character[9]));
                    Plvl += Integer.valueOf(character[9]).intValue();
                }
                if (character.length > 10 && m.isInt(character[10])) {
                    Excavation2.add(p, Integer.valueOf(character[10]));
                    Plvl += Integer.valueOf(character[10]).intValue();
                }
                if (character.length > 11 && m.isInt(character[11])) {
                    Archery2.add(p, Integer.valueOf(character[11]));
                    Plvl += Integer.valueOf(character[11]).intValue();
                }
                if (character.length > 12 && m.isInt(character[12])) {
                    Swords2.add(p, Integer.valueOf(character[12]));
                    Plvl += Integer.valueOf(character[12]).intValue();
                }
                if (character.length > 13 && m.isInt(character[13])) {
                    Axes2.add(p, Integer.valueOf(character[13]));
                    Plvl += Integer.valueOf(character[13]).intValue();
                }
                if (character.length > 14 && m.isInt(character[14])) {
                    Acrobatics2.add(p, Integer.valueOf(character[14]));
                    Plvl += Integer.valueOf(character[14]).intValue();
                }
                if (character.length > 24 && m.isInt(character[24])) {
                    Taming2.add(p, Integer.valueOf(character[24]));
                    Plvl += Integer.valueOf(character[24]).intValue();
                }
                PowerLevel.add(p, Plvl);
            }
            in.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception while reading " + location + " (Are you sure you formatted it correctly?)", e);
        }
        Leaderboard.leaderWrite(Mining2.inOrder(), SkillType.MINING);
        Leaderboard.leaderWrite(WoodCutting2.inOrder(), SkillType.WOODCUTTING);
        Leaderboard.leaderWrite(Repair2.inOrder(), SkillType.REPAIR);
        Leaderboard.leaderWrite(Unarmed2.inOrder(), SkillType.UNARMED);
        Leaderboard.leaderWrite(Herbalism2.inOrder(), SkillType.HERBALISM);
        Leaderboard.leaderWrite(Excavation2.inOrder(), SkillType.EXCAVATION);
        Leaderboard.leaderWrite(Archery2.inOrder(), SkillType.ARCHERY);
        Leaderboard.leaderWrite(Swords2.inOrder(), SkillType.SWORDS);
        Leaderboard.leaderWrite(Axes2.inOrder(), SkillType.AXES);
        Leaderboard.leaderWrite(Acrobatics2.inOrder(), SkillType.ACROBATICS);
        Leaderboard.leaderWrite(Taming2.inOrder(), SkillType.TAMING);
        Leaderboard.leaderWrite(PowerLevel.inOrder(), SkillType.ALL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void leaderWrite(PlayerStat[] ps, SkillType skillType) {
        String theLocation = "plugins/mcMMO/FlatFileStuff/Leaderboards/" + (Object)((Object)skillType) + ".mcmmo";
        File theDir = new File(theLocation);
        if (!theDir.exists()) {
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(theLocation);
                    return;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Exception while creating " + theLocation, e);
                    try {
                        if (writer == null) return;
                        writer.close();
                        return;
                    }
                    catch (IOException e2) {
                        log.log(Level.SEVERE, "Exception while closing writer for " + theLocation, e2);
                    }
                }
                return;
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Exception while closing writer for " + theLocation, e);
                }
            }
        }
        try {
            FileReader file = new FileReader(theLocation);
            BufferedReader in = new BufferedReader(file);
            StringBuilder writer = new StringBuilder();
            PlayerStat[] playerStatArray = ps;
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                PlayerStat p = playerStatArray[n2];
                if (!p.name.equals("$mcMMO_DummyInfo") && p.statVal != 0) {
                    writer.append(String.valueOf(p.name) + ":" + p.statVal);
                    writer.append("\r\n");
                }
                ++n2;
            }
            in.close();
            FileWriter out = new FileWriter(theLocation);
            out.write(writer.toString());
            out.close();
            return;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception while writing to " + theLocation + " (Are you sure you formatted it correctly?)", e);
        }
    }

    public static String[] retrieveInfo(String skillName, int pagenumber) {
        String theLocation = "plugins/mcMMO/FlatFileStuff/Leaderboards/" + skillName + ".mcmmo";
        try {
            FileReader file = new FileReader(theLocation);
            BufferedReader in = new BufferedReader(file);
            int destination = (pagenumber - 1) * 10;
            int x = 0;
            int y = 0;
            String line = "";
            String[] info = new String[10];
            while ((line = in.readLine()) != null && y < 10) {
                if (++x < destination || y >= 10) continue;
                info[y] = line.toString();
                ++y;
            }
            in.close();
            return info;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception while reading " + theLocation + " (Are you sure you formatted it correctly?)", e);
            return null;
        }
    }

    public static void updateLeaderboard(PlayerStat ps, SkillType skillType) {
        if (LoadProperties.useMySQL.booleanValue()) {
            return;
        }
        String theLocation = "plugins/mcMMO/FlatFileStuff/Leaderboards/" + (Object)((Object)skillType) + ".mcmmo";
        try {
            FileReader file = new FileReader(theLocation);
            BufferedReader in = new BufferedReader(file);
            StringBuilder writer = new StringBuilder();
            String line = "";
            Boolean inserted = false;
            while ((line = in.readLine()) != null) {
                if (Integer.valueOf(line.split(":")[1]) < ps.statVal && !inserted.booleanValue()) {
                    writer.append(String.valueOf(ps.name) + ":" + ps.statVal).append("\r\n");
                    inserted = true;
                }
                if (line.split(":")[0].equalsIgnoreCase(ps.name)) continue;
                writer.append(line).append("\r\n");
            }
            if (!inserted.booleanValue()) {
                writer.append(String.valueOf(ps.name) + ":" + ps.statVal).append("\r\n");
            }
            in.close();
            FileWriter out = new FileWriter(theLocation);
            out.write(writer.toString());
            out.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception while writing to " + theLocation + " (Are you sure you formatted it correctly?)", e);
        }
    }
}

