/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes;

import com.gmail.nossr50.config.LoadProperties;
import com.gmail.nossr50.datatypes.SkillType;
import com.gmail.nossr50.m;
import com.gmail.nossr50.mcMMO;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerProfile {
    protected final Logger log = Logger.getLogger("Minecraft");
    private String party;
    private String myspawn;
    private String myspawnworld;
    private String invite;
    private boolean placedAnvil = false;
    private boolean partyChatMode = false;
    private boolean adminChatMode = false;
    private boolean godMode = false;
    private boolean greenTerraMode;
    private boolean partyChatOnly = false;
    private boolean greenTerraInformed = true;
    private boolean berserkInformed = true;
    private boolean skullSplitterInformed = true;
    private boolean gigaDrillBreakerInformed = true;
    private boolean superBreakerInformed = true;
    private boolean serratedStrikesInformed = true;
    private boolean treeFellerInformed = true;
    private boolean dead;
    private boolean abilityuse = true;
    private boolean treeFellerMode;
    private boolean superBreakerMode;
    private boolean gigaDrillBreakerMode;
    private boolean serratedStrikesMode;
    private boolean hoePreparationMode = false;
    private boolean shovelPreparationMode = false;
    private boolean swordsPreparationMode = false;
    private boolean fistsPreparationMode = false;
    private boolean pickaxePreparationMode = false;
    private boolean axePreparationMode = false;
    private boolean skullSplitterMode;
    private boolean berserkMode;
    private long recentlyHurt = 0L;
    private long archeryShotATS = 0L;
    private long berserkATS = 0L;
    private long berserkDATS = 0L;
    private long gigaDrillBreakerATS = 0L;
    private long gigaDrillBreakerDATS = 0L;
    private long respawnATS = 0L;
    private long mySpawnATS = 0L;
    private long greenTerraATS = 0L;
    private long greenTerraDATS = 0L;
    private long superBreakerATS = 0L;
    private long superBreakerDATS = 0L;
    private long serratedStrikesATS = 0L;
    private long serratedStrikesDATS = 0L;
    private long treeFellerATS = 0L;
    private long treeFellerDATS = 0L;
    private long skullSplitterATS = 0L;
    private long skullSplitterDATS = 0L;
    private long hoePreparationATS = 0L;
    private long axePreparationATS = 0L;
    private long pickaxePreparationATS = 0L;
    private long fistsPreparationATS = 0L;
    private long shovelPreparationATS = 0L;
    private long swordsPreparationATS = 0L;
    private int lastlogin = 0;
    private int userid = 0;
    private int bleedticks = 0;
    private int mana = 0;
    private int greenDyeCycleSel = 0;
    private int greenDyeCycle = 0;
    private int blueDyeCycle = 0;
    private int blueDyeCycleSel = 0;
    public boolean dyeChanged = false;
    private String playername;
    HashMap<SkillType, Integer> skills = new HashMap();
    HashMap<SkillType, Integer> skillsXp = new HashMap();
    String location = "plugins/mcMMO/FlatFileStuff/mcmmo.users";

    public PlayerProfile(Player player) {
        this.skills.put(SkillType.SORCERY, 0);
        this.skillsXp.put(SkillType.SORCERY, 0);
        this.skills.put(SkillType.UNARMED, 0);
        this.skillsXp.put(SkillType.UNARMED, 0);
        this.skills.put(SkillType.TAMING, 0);
        this.skillsXp.put(SkillType.TAMING, 0);
        this.skills.put(SkillType.MINING, 0);
        this.skillsXp.put(SkillType.MINING, 0);
        this.skills.put(SkillType.WOODCUTTING, 0);
        this.skillsXp.put(SkillType.WOODCUTTING, 0);
        this.skills.put(SkillType.REPAIR, 0);
        this.skillsXp.put(SkillType.REPAIR, 0);
        this.skills.put(SkillType.HERBALISM, 0);
        this.skillsXp.put(SkillType.HERBALISM, 0);
        this.skills.put(SkillType.EXCAVATION, 0);
        this.skillsXp.put(SkillType.EXCAVATION, 0);
        this.skills.put(SkillType.ARCHERY, 0);
        this.skillsXp.put(SkillType.ARCHERY, 0);
        this.skills.put(SkillType.SWORDS, 0);
        this.skillsXp.put(SkillType.SWORDS, 0);
        this.skills.put(SkillType.AXES, 0);
        this.skillsXp.put(SkillType.AXES, 0);
        this.skills.put(SkillType.ACROBATICS, 0);
        this.skillsXp.put(SkillType.ACROBATICS, 0);
        this.mana = this.getMaxMana();
        this.playername = player.getName();
        if (LoadProperties.useMySQL.booleanValue()) {
            if (!this.loadMySQL(player)) {
                this.addMySQLPlayer(player);
                this.loadMySQL(player);
            }
        } else if (!this.load()) {
            this.addPlayer();
        }
        this.lastlogin = Long.valueOf(System.currentTimeMillis() / 1000L).intValue();
    }

    public int getLastLogin() {
        return this.lastlogin;
    }

    public int getMySQLuserId() {
        return this.userid;
    }

    public boolean loadMySQL(Player p) {
        Integer id = 0;
        id = mcMMO.database.GetInt("SELECT id FROM " + LoadProperties.MySQLtablePrefix + "users WHERE user = '" + p.getName() + "'");
        if (id == 0) {
            return false;
        }
        this.userid = id;
        if (id > 0) {
            HashMap<Integer, ArrayList<String>> users = mcMMO.database.Read("SELECT lastlogin, party FROM " + LoadProperties.MySQLtablePrefix + "users WHERE id = " + id);
            this.party = users.get(1).get(1);
            HashMap<Integer, ArrayList<String>> spawn = mcMMO.database.Read("SELECT world, x, y, z FROM " + LoadProperties.MySQLtablePrefix + "spawn WHERE user_id = " + id);
            this.myspawnworld = spawn.get(1).get(0);
            this.myspawn = String.valueOf(spawn.get(1).get(1)) + "," + spawn.get(1).get(2) + "," + spawn.get(1).get(3);
            HashMap<Integer, ArrayList<String>> cooldowns = mcMMO.database.Read("SELECT mining, woodcutting, unarmed, herbalism, excavation, swords, axes FROM " + LoadProperties.MySQLtablePrefix + "cooldowns WHERE user_id = " + id);
            if (cooldowns.get(1) == null) {
                mcMMO.database.Write("INSERT INTO " + LoadProperties.MySQLtablePrefix + "cooldowns (user_id) VALUES (" + id + ")");
            } else {
                this.superBreakerDATS = Long.valueOf(cooldowns.get(1).get(0)) * 1000L;
                this.treeFellerDATS = Long.valueOf(cooldowns.get(1).get(1)) * 1000L;
                this.berserkDATS = Long.valueOf(cooldowns.get(1).get(2)) * 1000L;
                this.greenTerraDATS = Long.valueOf(cooldowns.get(1).get(3)) * 1000L;
                this.gigaDrillBreakerDATS = Long.valueOf(cooldowns.get(1).get(4)) * 1000L;
                this.serratedStrikesDATS = Long.valueOf(cooldowns.get(1).get(5)) * 1000L;
                this.skullSplitterDATS = Long.valueOf(cooldowns.get(1).get(6)) * 1000L;
            }
            HashMap<Integer, ArrayList<String>> stats = mcMMO.database.Read("SELECT taming, mining, repair, woodcutting, unarmed, herbalism, excavation, archery, swords, axes, acrobatics FROM " + LoadProperties.MySQLtablePrefix + "skills WHERE user_id = " + id);
            this.skills.put(SkillType.TAMING, Integer.valueOf(stats.get(1).get(0)));
            this.skills.put(SkillType.MINING, Integer.valueOf(stats.get(1).get(1)));
            this.skills.put(SkillType.REPAIR, Integer.valueOf(stats.get(1).get(2)));
            this.skills.put(SkillType.WOODCUTTING, Integer.valueOf(stats.get(1).get(3)));
            this.skills.put(SkillType.UNARMED, Integer.valueOf(stats.get(1).get(4)));
            this.skills.put(SkillType.HERBALISM, Integer.valueOf(stats.get(1).get(5)));
            this.skills.put(SkillType.EXCAVATION, Integer.valueOf(stats.get(1).get(6)));
            this.skills.put(SkillType.ARCHERY, Integer.valueOf(stats.get(1).get(7)));
            this.skills.put(SkillType.SWORDS, Integer.valueOf(stats.get(1).get(8)));
            this.skills.put(SkillType.AXES, Integer.valueOf(stats.get(1).get(9)));
            this.skills.put(SkillType.ACROBATICS, Integer.valueOf(stats.get(1).get(10)));
            HashMap<Integer, ArrayList<String>> experience = mcMMO.database.Read("SELECT taming, mining, repair, woodcutting, unarmed, herbalism, excavation, archery, swords, axes, acrobatics FROM " + LoadProperties.MySQLtablePrefix + "experience WHERE user_id = " + id);
            this.skillsXp.put(SkillType.TAMING, Integer.valueOf(experience.get(1).get(0)));
            this.skillsXp.put(SkillType.MINING, Integer.valueOf(experience.get(1).get(1)));
            this.skillsXp.put(SkillType.REPAIR, Integer.valueOf(experience.get(1).get(2)));
            this.skillsXp.put(SkillType.WOODCUTTING, Integer.valueOf(experience.get(1).get(3)));
            this.skillsXp.put(SkillType.UNARMED, Integer.valueOf(experience.get(1).get(4)));
            this.skillsXp.put(SkillType.HERBALISM, Integer.valueOf(experience.get(1).get(5)));
            this.skillsXp.put(SkillType.EXCAVATION, Integer.valueOf(experience.get(1).get(6)));
            this.skillsXp.put(SkillType.ARCHERY, Integer.valueOf(experience.get(1).get(7)));
            this.skillsXp.put(SkillType.SWORDS, Integer.valueOf(experience.get(1).get(8)));
            this.skillsXp.put(SkillType.AXES, Integer.valueOf(experience.get(1).get(9)));
            this.skillsXp.put(SkillType.ACROBATICS, Integer.valueOf(experience.get(1).get(10)));
            return true;
        }
        return false;
    }

    public void addMySQLPlayer(Player p) {
        Integer id = 0;
        mcMMO.database.Write("INSERT INTO " + LoadProperties.MySQLtablePrefix + "users (user, lastlogin) VALUES ('" + p.getName() + "'," + System.currentTimeMillis() / 1000L + ")");
        id = mcMMO.database.GetInt("SELECT id FROM " + LoadProperties.MySQLtablePrefix + "users WHERE user = '" + p.getName() + "'");
        mcMMO.database.Write("INSERT INTO " + LoadProperties.MySQLtablePrefix + "cooldowns (user_id) VALUES (" + id + ")");
        mcMMO.database.Write("INSERT INTO " + LoadProperties.MySQLtablePrefix + "spawn (user_id) VALUES (" + id + ")");
        mcMMO.database.Write("INSERT INTO " + LoadProperties.MySQLtablePrefix + "skills (user_id) VALUES (" + id + ")");
        mcMMO.database.Write("INSERT INTO " + LoadProperties.MySQLtablePrefix + "experience (user_id) VALUES (" + id + ")");
        this.userid = id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load() {
        try {
            String[] character;
            FileReader file = new FileReader(this.location);
            BufferedReader in = new BufferedReader(file);
            String line = "";
            do {
                if ((line = in.readLine()) != null) continue;
                in.close();
                return false;
            } while (!(character = line.split(":"))[0].equals(this.playername));
            if (character.length > 1 && m.isInt(character[1])) {
                this.skills.put(SkillType.MINING, Integer.valueOf(character[1]));
            }
            if (character.length > 2) {
                this.myspawn = character[2];
            }
            if (character.length > 3) {
                this.party = character[3];
            }
            if (character.length > 4 && m.isInt(character[4])) {
                this.skillsXp.put(SkillType.MINING, Integer.valueOf(character[4]));
            }
            if (character.length > 5 && m.isInt(character[5])) {
                this.skills.put(SkillType.WOODCUTTING, Integer.valueOf(character[5]));
            }
            if (character.length > 6 && m.isInt(character[6])) {
                this.skillsXp.put(SkillType.WOODCUTTING, Integer.valueOf(character[6]));
            }
            if (character.length > 7 && m.isInt(character[7])) {
                this.skills.put(SkillType.REPAIR, Integer.valueOf(character[7]));
            }
            if (character.length > 8 && m.isInt(character[8])) {
                this.skills.put(SkillType.UNARMED, Integer.valueOf(character[8]));
            }
            if (character.length > 9 && m.isInt(character[9])) {
                this.skills.put(SkillType.HERBALISM, Integer.valueOf(character[9]));
            }
            if (character.length > 10 && m.isInt(character[10])) {
                this.skills.put(SkillType.EXCAVATION, Integer.valueOf(character[10]));
            }
            if (character.length > 11 && m.isInt(character[11])) {
                this.skills.put(SkillType.ARCHERY, Integer.valueOf(character[11]));
            }
            if (character.length > 12 && m.isInt(character[12])) {
                this.skills.put(SkillType.SWORDS, Integer.valueOf(character[12]));
            }
            if (character.length > 13 && m.isInt(character[13])) {
                this.skills.put(SkillType.AXES, Integer.valueOf(character[13]));
            }
            if (character.length > 14 && m.isInt(character[14])) {
                this.skills.put(SkillType.ACROBATICS, Integer.valueOf(character[14]));
            }
            if (character.length > 15 && m.isInt(character[15])) {
                this.skillsXp.put(SkillType.REPAIR, Integer.valueOf(character[15]));
            }
            if (character.length > 16 && m.isInt(character[16])) {
                this.skillsXp.put(SkillType.UNARMED, Integer.valueOf(character[16]));
            }
            if (character.length > 17 && m.isInt(character[17])) {
                this.skillsXp.put(SkillType.HERBALISM, Integer.valueOf(character[17]));
            }
            if (character.length > 18 && m.isInt(character[18])) {
                this.skillsXp.put(SkillType.EXCAVATION, Integer.valueOf(character[18]));
            }
            if (character.length > 19 && m.isInt(character[19])) {
                this.skillsXp.put(SkillType.ARCHERY, Integer.valueOf(character[19]));
            }
            if (character.length > 20 && m.isInt(character[20])) {
                this.skillsXp.put(SkillType.SWORDS, Integer.valueOf(character[20]));
            }
            if (character.length > 21 && m.isInt(character[21])) {
                this.skillsXp.put(SkillType.AXES, Integer.valueOf(character[21]));
            }
            if (character.length > 22 && m.isInt(character[22])) {
                this.skillsXp.put(SkillType.ACROBATICS, Integer.valueOf(character[22]));
            }
            if (character.length > 23 && m.isInt(character[23])) {
                this.myspawnworld = character[23];
            }
            if (character.length > 24 && m.isInt(character[24])) {
                this.skills.put(SkillType.TAMING, Integer.valueOf(character[24]));
            }
            if (character.length > 25 && m.isInt(character[25])) {
                this.skillsXp.put(SkillType.TAMING, Integer.valueOf(character[25]));
            }
            if (character.length > 26) {
                this.berserkDATS = Long.valueOf(character[26]) * 1000L;
            }
            if (character.length > 27) {
                this.gigaDrillBreakerDATS = Long.valueOf(character[27]) * 1000L;
            }
            if (character.length > 28) {
                this.treeFellerDATS = Long.valueOf(character[28]) * 1000L;
            }
            if (character.length > 29) {
                this.greenTerraDATS = Long.valueOf(character[29]) * 1000L;
            }
            if (character.length > 30) {
                this.serratedStrikesDATS = Long.valueOf(character[30]) * 1000L;
            }
            if (character.length > 31) {
                this.skullSplitterDATS = Long.valueOf(character[31]) * 1000L;
            }
            if (character.length > 32) {
                this.superBreakerDATS = Long.valueOf(character[32]) * 1000L;
            }
            in.close();
            return true;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Exception while reading " + this.location + " (Are you sure you formatted it correctly?)", e);
        }
        return false;
    }

    public void save() {
        Long timestamp = System.currentTimeMillis() / 1000L;
        if (LoadProperties.useMySQL.booleanValue()) {
            mcMMO.database.Write("UPDATE " + LoadProperties.MySQLtablePrefix + "users SET lastlogin = " + timestamp.intValue() + " WHERE id = " + this.userid);
            mcMMO.database.Write("UPDATE " + LoadProperties.MySQLtablePrefix + "users SET party = '" + this.party + "' WHERE id = " + this.userid);
            mcMMO.database.Write("UPDATE " + LoadProperties.MySQLtablePrefix + "spawn SET world = '" + this.myspawnworld + "', x = " + this.getX() + ", y = " + this.getY() + ", z = " + this.getZ() + " WHERE user_id = " + this.userid);
            mcMMO.database.Write("UPDATE " + LoadProperties.MySQLtablePrefix + "cooldowns SET " + " mining = " + this.superBreakerDATS / 1000L + ", woodcutting = " + this.treeFellerDATS / 1000L + ", unarmed = " + this.berserkDATS / 1000L + ", herbalism = " + this.greenTerraDATS / 1000L + ", excavation = " + this.gigaDrillBreakerDATS / 1000L + ", swords = " + this.serratedStrikesDATS / 1000L + ", axes = " + this.skullSplitterDATS / 1000L + " WHERE user_id = " + this.userid);
            mcMMO.database.Write("UPDATE " + LoadProperties.MySQLtablePrefix + "skills SET " + "  taming = " + this.skills.get((Object)SkillType.TAMING) + ", mining = " + this.skills.get((Object)SkillType.MINING) + ", repair = " + this.skills.get((Object)SkillType.REPAIR) + ", woodcutting = " + this.skills.get((Object)SkillType.WOODCUTTING) + ", unarmed = " + this.skills.get((Object)SkillType.UNARMED) + ", herbalism = " + this.skills.get((Object)SkillType.HERBALISM) + ", excavation = " + this.skills.get((Object)SkillType.EXCAVATION) + ", archery = " + this.skills.get((Object)SkillType.ARCHERY) + ", swords = " + this.skills.get((Object)SkillType.SWORDS) + ", axes = " + this.skills.get((Object)SkillType.AXES) + ", acrobatics = " + this.skills.get((Object)SkillType.ACROBATICS) + " WHERE user_id = " + this.userid);
            mcMMO.database.Write("UPDATE " + LoadProperties.MySQLtablePrefix + "experience SET " + "  taming = " + this.skillsXp.get((Object)SkillType.TAMING) + ", mining = " + this.skillsXp.get((Object)SkillType.MINING) + ", repair = " + this.skillsXp.get((Object)SkillType.REPAIR) + ", woodcutting = " + this.skillsXp.get((Object)SkillType.WOODCUTTING) + ", unarmed = " + this.skillsXp.get((Object)SkillType.UNARMED) + ", herbalism = " + this.skillsXp.get((Object)SkillType.HERBALISM) + ", excavation = " + this.skillsXp.get((Object)SkillType.EXCAVATION) + ", archery = " + this.skillsXp.get((Object)SkillType.ARCHERY) + ", swords = " + this.skillsXp.get((Object)SkillType.SWORDS) + ", axes = " + this.skillsXp.get((Object)SkillType.AXES) + ", acrobatics = " + this.skillsXp.get((Object)SkillType.ACROBATICS) + " WHERE user_id = " + this.userid);
        } else {
            try {
                FileReader file = new FileReader(this.location);
                BufferedReader in = new BufferedReader(file);
                StringBuilder writer = new StringBuilder();
                String line = "";
                while ((line = in.readLine()) != null) {
                    if (!line.split(":")[0].equalsIgnoreCase(this.playername)) {
                        writer.append(line).append("\r\n");
                        continue;
                    }
                    writer.append(String.valueOf(this.playername) + ":");
                    writer.append(this.skills.get((Object)SkillType.MINING) + ":");
                    writer.append(String.valueOf(this.myspawn) + ":");
                    writer.append(String.valueOf(this.party) + ":");
                    writer.append(this.skillsXp.get((Object)SkillType.MINING) + ":");
                    writer.append(this.skills.get((Object)SkillType.WOODCUTTING) + ":");
                    writer.append(this.skillsXp.get((Object)SkillType.WOODCUTTING) + ":");
                    writer.append(this.skills.get((Object)SkillType.REPAIR) + ":");
                    writer.append(this.skills.get((Object)SkillType.UNARMED) + ":");
                    writer.append(this.skills.get((Object)SkillType.HERBALISM) + ":");
                    writer.append(this.skills.get((Object)SkillType.EXCAVATION) + ":");
                    writer.append(this.skills.get((Object)SkillType.ARCHERY) + ":");
                    writer.append(this.skills.get((Object)SkillType.SWORDS) + ":");
                    writer.append(this.skills.get((Object)SkillType.AXES) + ":");
                    writer.append(this.skills.get((Object)SkillType.ACROBATICS) + ":");
                    writer.append(this.skillsXp.get((Object)SkillType.REPAIR) + ":");
                    writer.append(this.skillsXp.get((Object)SkillType.UNARMED) + ":");
                    writer.append(this.skillsXp.get((Object)SkillType.HERBALISM) + ":");
                    writer.append(this.skillsXp.get((Object)SkillType.EXCAVATION) + ":");
                    writer.append(this.skillsXp.get((Object)SkillType.ARCHERY) + ":");
                    writer.append(this.skillsXp.get((Object)SkillType.SWORDS) + ":");
                    writer.append(this.skillsXp.get((Object)SkillType.AXES) + ":");
                    writer.append(this.skillsXp.get((Object)SkillType.ACROBATICS) + ":");
                    writer.append(String.valueOf(this.myspawnworld) + ":");
                    writer.append(this.skills.get((Object)SkillType.TAMING) + ":");
                    writer.append(this.skillsXp.get((Object)SkillType.TAMING) + ":");
                    writer.append(String.valueOf(String.valueOf(this.berserkDATS / 1000L)) + ":");
                    writer.append(String.valueOf(String.valueOf(this.gigaDrillBreakerDATS / 1000L)) + ":");
                    writer.append(String.valueOf(String.valueOf(this.treeFellerDATS / 1000L)) + ":");
                    writer.append(String.valueOf(String.valueOf(this.greenTerraDATS / 1000L)) + ":");
                    writer.append(String.valueOf(String.valueOf(this.serratedStrikesDATS / 1000L)) + ":");
                    writer.append(String.valueOf(String.valueOf(this.skullSplitterDATS / 1000L)) + ":");
                    writer.append(String.valueOf(String.valueOf(this.superBreakerDATS / 1000L)) + ":");
                    writer.append("\r\n");
                }
                in.close();
                FileWriter out = new FileWriter(this.location);
                out.write(writer.toString());
                out.close();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Exception while writing to " + this.location + " (Are you sure you formatted it correctly?)", e);
            }
        }
    }

    public void addPlayer() {
        try {
            FileWriter file = new FileWriter(this.location, true);
            BufferedWriter out = new BufferedWriter(file);
            out.append(String.valueOf(this.playername) + ":");
            out.append("0:");
            out.append(String.valueOf(this.myspawn) + ":");
            out.append(String.valueOf(this.party) + ":");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append(String.valueOf(this.myspawnworld) + ":");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.append("0:");
            out.newLine();
            out.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Exception while writing to " + this.location + " (Are you sure you formatted it correctly?)", e);
        }
    }

    public boolean getAdminChatMode() {
        return this.adminChatMode;
    }

    public boolean getPartyChatMode() {
        return this.partyChatMode;
    }

    public boolean getGodMode() {
        return this.godMode;
    }

    public void togglePlacedAnvil() {
        this.placedAnvil = !this.placedAnvil;
    }

    public Boolean getPlacedAnvil() {
        return this.placedAnvil;
    }

    public void toggleAdminChat() {
        this.adminChatMode = !this.adminChatMode;
    }

    public void toggleGodMode() {
        this.godMode = !this.godMode;
    }

    public void togglePartyChat() {
        this.partyChatMode = !this.partyChatMode;
    }

    public void setMana(int newvalue) {
        this.mana = newvalue;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public int getMaxMana() {
        if (this.skills.get((Object)SkillType.SORCERY) < 50) {
            return 5;
        }
        return this.skills.get((Object)SkillType.SORCERY) / 10;
    }

    public void setDyeChanged(Boolean bool) {
        this.dyeChanged = bool;
    }

    public boolean getDyeChanged() {
        return this.dyeChanged;
    }

    public void setBlueDyeCycle(int newvalue) {
        this.blueDyeCycle = newvalue;
    }

    public int getBlueDyeCycle() {
        return this.blueDyeCycle;
    }

    public void setBlueDyeCycleSel(int newvalue) {
        this.blueDyeCycleSel = newvalue;
    }

    public int getBlueDyeCycleSel() {
        return this.blueDyeCycleSel;
    }

    public void setGreenDyeCycle(int newvalue) {
        this.greenDyeCycle = newvalue;
    }

    public int getGreenDyeCycle() {
        return this.greenDyeCycle;
    }

    public void setGreenDyeCycleSel(int newvalue) {
        this.greenDyeCycleSel = newvalue;
    }

    public int getGreenDyeCycleSel() {
        return this.greenDyeCycleSel;
    }

    public boolean isPlayer(String player) {
        return player.equals(this.playername);
    }

    public boolean getPartyChatOnlyToggle() {
        return this.partyChatOnly;
    }

    public void togglePartyChatOnly() {
        this.partyChatOnly = !this.partyChatOnly;
    }

    public boolean getAbilityUse() {
        return this.abilityuse;
    }

    public void toggleAbilityUse() {
        this.abilityuse = !this.abilityuse;
    }

    public long getMySpawnATS() {
        return this.mySpawnATS;
    }

    public void setMySpawnATS(long newvalue) {
        this.mySpawnATS = newvalue;
    }

    public void decreaseBleedTicks() {
        --this.bleedticks;
    }

    public Integer getBleedTicks() {
        return this.bleedticks;
    }

    public void setBleedTicks(Integer newvalue) {
        this.bleedticks = newvalue;
    }

    public void addBleedTicks(Integer newvalue) {
        this.bleedticks += newvalue.intValue();
    }

    public long getRespawnATS() {
        return this.respawnATS;
    }

    public void setRespawnATS(long newvalue) {
        this.respawnATS = newvalue;
    }

    public long getArcheryShotATS() {
        return this.archeryShotATS;
    }

    public void setArcheryShotATS(long newvalue) {
        this.archeryShotATS = newvalue;
    }

    public boolean getHoePreparationMode() {
        return this.hoePreparationMode;
    }

    public void setHoePreparationMode(Boolean bool) {
        this.hoePreparationMode = bool;
    }

    public long getHoePreparationATS() {
        return this.hoePreparationATS;
    }

    public void setHoePreparationATS(long newvalue) {
        this.hoePreparationATS = newvalue;
    }

    public boolean getSwordsPreparationMode() {
        return this.swordsPreparationMode;
    }

    public void setSwordsPreparationMode(Boolean bool) {
        this.swordsPreparationMode = bool;
    }

    public long getSwordsPreparationATS() {
        return this.swordsPreparationATS;
    }

    public void setSwordsPreparationATS(long newvalue) {
        this.swordsPreparationATS = newvalue;
    }

    public boolean getShovelPreparationMode() {
        return this.shovelPreparationMode;
    }

    public void setShovelPreparationMode(Boolean bool) {
        this.shovelPreparationMode = bool;
    }

    public long getShovelPreparationATS() {
        return this.shovelPreparationATS;
    }

    public void setShovelPreparationATS(long newvalue) {
        this.shovelPreparationATS = newvalue;
    }

    public boolean getFistsPreparationMode() {
        return this.fistsPreparationMode;
    }

    public void setFistsPreparationMode(Boolean bool) {
        this.fistsPreparationMode = bool;
    }

    public long getFistsPreparationATS() {
        return this.fistsPreparationATS;
    }

    public void setFistsPreparationATS(long newvalue) {
        this.fistsPreparationATS = newvalue;
    }

    public boolean getAxePreparationMode() {
        return this.axePreparationMode;
    }

    public void setAxePreparationMode(Boolean bool) {
        this.axePreparationMode = bool;
    }

    public long getAxePreparationATS() {
        return this.axePreparationATS;
    }

    public void setAxePreparationATS(long newvalue) {
        this.axePreparationATS = newvalue;
    }

    public boolean getPickaxePreparationMode() {
        return this.pickaxePreparationMode;
    }

    public void setPickaxePreparationMode(Boolean bool) {
        this.pickaxePreparationMode = bool;
    }

    public long getPickaxePreparationATS() {
        return this.pickaxePreparationATS;
    }

    public void setPickaxePreparationATS(long newvalue) {
        this.pickaxePreparationATS = newvalue;
    }

    public boolean getGreenTerraInformed() {
        return this.greenTerraInformed;
    }

    public void setGreenTerraInformed(Boolean bool) {
        this.greenTerraInformed = bool;
    }

    public boolean getGreenTerraMode() {
        return this.greenTerraMode;
    }

    public void setGreenTerraMode(Boolean bool) {
        this.greenTerraMode = bool;
    }

    public long getGreenTerraActivatedTimeStamp() {
        return this.greenTerraATS;
    }

    public void setGreenTerraActivatedTimeStamp(Long newvalue) {
        this.greenTerraATS = newvalue;
    }

    public long getGreenTerraDeactivatedTimeStamp() {
        return this.greenTerraDATS;
    }

    public void setGreenTerraDeactivatedTimeStamp(Long newvalue) {
        this.greenTerraDATS = newvalue;
        this.save();
    }

    public boolean getBerserkInformed() {
        return this.berserkInformed;
    }

    public void setBerserkInformed(Boolean bool) {
        this.berserkInformed = bool;
    }

    public boolean getBerserkMode() {
        return this.berserkMode;
    }

    public void setBerserkMode(Boolean bool) {
        this.berserkMode = bool;
    }

    public long getBerserkActivatedTimeStamp() {
        return this.berserkATS;
    }

    public void setBerserkActivatedTimeStamp(Long newvalue) {
        this.berserkATS = newvalue;
    }

    public long getBerserkDeactivatedTimeStamp() {
        return this.berserkDATS;
    }

    public void setBerserkDeactivatedTimeStamp(Long newvalue) {
        this.berserkDATS = newvalue;
        this.save();
    }

    public boolean getSkullSplitterInformed() {
        return this.skullSplitterInformed;
    }

    public void setSkullSplitterInformed(Boolean bool) {
        this.skullSplitterInformed = bool;
    }

    public boolean getSkullSplitterMode() {
        return this.skullSplitterMode;
    }

    public void setSkullSplitterMode(Boolean bool) {
        this.skullSplitterMode = bool;
    }

    public long getSkullSplitterActivatedTimeStamp() {
        return this.skullSplitterATS;
    }

    public void setSkullSplitterActivatedTimeStamp(Long newvalue) {
        this.skullSplitterATS = newvalue;
    }

    public long getSkullSplitterDeactivatedTimeStamp() {
        return this.skullSplitterDATS;
    }

    public void setSkullSplitterDeactivatedTimeStamp(Long newvalue) {
        this.skullSplitterDATS = newvalue;
        this.save();
    }

    public boolean getSerratedStrikesInformed() {
        return this.serratedStrikesInformed;
    }

    public void setSerratedStrikesInformed(Boolean bool) {
        this.serratedStrikesInformed = bool;
    }

    public boolean getSerratedStrikesMode() {
        return this.serratedStrikesMode;
    }

    public void setSerratedStrikesMode(Boolean bool) {
        this.serratedStrikesMode = bool;
    }

    public long getSerratedStrikesActivatedTimeStamp() {
        return this.serratedStrikesATS;
    }

    public void setSerratedStrikesActivatedTimeStamp(Long newvalue) {
        this.serratedStrikesATS = newvalue;
    }

    public long getSerratedStrikesDeactivatedTimeStamp() {
        return this.serratedStrikesDATS;
    }

    public void setSerratedStrikesDeactivatedTimeStamp(Long newvalue) {
        this.serratedStrikesDATS = newvalue;
        this.save();
    }

    public boolean getGigaDrillBreakerInformed() {
        return this.gigaDrillBreakerInformed;
    }

    public void setGigaDrillBreakerInformed(Boolean bool) {
        this.gigaDrillBreakerInformed = bool;
    }

    public boolean getGigaDrillBreakerMode() {
        return this.gigaDrillBreakerMode;
    }

    public void setGigaDrillBreakerMode(Boolean bool) {
        this.gigaDrillBreakerMode = bool;
    }

    public long getGigaDrillBreakerActivatedTimeStamp() {
        return this.gigaDrillBreakerATS;
    }

    public void setGigaDrillBreakerActivatedTimeStamp(Long newvalue) {
        this.gigaDrillBreakerATS = newvalue;
    }

    public long getGigaDrillBreakerDeactivatedTimeStamp() {
        return this.gigaDrillBreakerDATS;
    }

    public void setGigaDrillBreakerDeactivatedTimeStamp(Long newvalue) {
        this.gigaDrillBreakerDATS = newvalue;
        this.save();
    }

    public boolean getTreeFellerInformed() {
        return this.treeFellerInformed;
    }

    public void setTreeFellerInformed(Boolean bool) {
        this.treeFellerInformed = bool;
    }

    public boolean getTreeFellerMode() {
        return this.treeFellerMode;
    }

    public void setTreeFellerMode(Boolean bool) {
        this.treeFellerMode = bool;
    }

    public long getTreeFellerActivatedTimeStamp() {
        return this.treeFellerATS;
    }

    public void setTreeFellerActivatedTimeStamp(Long newvalue) {
        this.treeFellerATS = newvalue;
    }

    public long getTreeFellerDeactivatedTimeStamp() {
        return this.treeFellerDATS;
    }

    public void setTreeFellerDeactivatedTimeStamp(Long newvalue) {
        this.treeFellerDATS = newvalue;
        this.save();
    }

    public boolean getSuperBreakerInformed() {
        return this.superBreakerInformed;
    }

    public void setSuperBreakerInformed(Boolean bool) {
        this.superBreakerInformed = bool;
    }

    public boolean getSuperBreakerMode() {
        return this.superBreakerMode;
    }

    public void setSuperBreakerMode(Boolean bool) {
        this.superBreakerMode = bool;
    }

    public long getSuperBreakerActivatedTimeStamp() {
        return this.superBreakerATS;
    }

    public void setSuperBreakerActivatedTimeStamp(Long newvalue) {
        this.superBreakerATS = newvalue;
    }

    public long getSuperBreakerDeactivatedTimeStamp() {
        return this.superBreakerDATS;
    }

    public void setSuperBreakerDeactivatedTimeStamp(Long newvalue) {
        this.superBreakerDATS = newvalue;
        this.save();
    }

    public long getRecentlyHurt() {
        return this.recentlyHurt;
    }

    public void setRecentlyHurt(long newvalue) {
        this.recentlyHurt = newvalue;
    }

    public void skillUp(SkillType skillType, int newvalue) {
        this.skills.put(skillType, this.skills.get((Object)skillType) + newvalue);
        this.save();
    }

    public Integer getSkillLevel(SkillType skillType) {
        return this.skills.get((Object)skillType);
    }

    public Integer getSkillXpLevel(SkillType skillType) {
        return this.skillsXp.get((Object)skillType);
    }

    public void resetSkillXp(SkillType skillType) {
        this.skills.put(skillType, 0);
    }

    public void addXP(SkillType skillType, int newvalue) {
        if (skillType == SkillType.ALL) {
            this.skillsXp.put(SkillType.TAMING, this.skillsXp.get((Object)SkillType.TAMING) + newvalue);
            this.skillsXp.put(SkillType.MINING, this.skillsXp.get((Object)SkillType.MINING) + newvalue);
            this.skillsXp.put(SkillType.WOODCUTTING, this.skillsXp.get((Object)SkillType.WOODCUTTING) + newvalue);
            this.skillsXp.put(SkillType.REPAIR, this.skillsXp.get((Object)SkillType.REPAIR) + newvalue);
            this.skillsXp.put(SkillType.HERBALISM, this.skillsXp.get((Object)SkillType.HERBALISM) + newvalue);
            this.skillsXp.put(SkillType.ACROBATICS, this.skillsXp.get((Object)SkillType.ACROBATICS) + newvalue);
            this.skillsXp.put(SkillType.SWORDS, this.skillsXp.get((Object)SkillType.SWORDS) + newvalue);
            this.skillsXp.put(SkillType.ARCHERY, this.skillsXp.get((Object)SkillType.ARCHERY) + newvalue);
            this.skillsXp.put(SkillType.UNARMED, this.skillsXp.get((Object)SkillType.UNARMED) + newvalue);
            this.skillsXp.put(SkillType.EXCAVATION, this.skillsXp.get((Object)SkillType.EXCAVATION) + newvalue);
            this.skillsXp.put(SkillType.AXES, this.skillsXp.get((Object)SkillType.AXES) + newvalue);
            this.skillsXp.put(SkillType.SORCERY, this.skillsXp.get((Object)SkillType.SORCERY) + newvalue);
        } else {
            this.skillsXp.put(skillType, this.skillsXp.get((Object)skillType) + newvalue);
        }
    }

    public void removeXP(SkillType skillType, int newvalue) {
        if (skillType == SkillType.ALL) {
            this.skillsXp.put(SkillType.TAMING, this.skillsXp.get((Object)SkillType.TAMING) - newvalue);
            this.skillsXp.put(SkillType.MINING, this.skillsXp.get((Object)SkillType.MINING) - newvalue);
            this.skillsXp.put(SkillType.WOODCUTTING, this.skillsXp.get((Object)SkillType.WOODCUTTING) - newvalue);
            this.skillsXp.put(SkillType.REPAIR, this.skillsXp.get((Object)SkillType.REPAIR) - newvalue);
            this.skillsXp.put(SkillType.HERBALISM, this.skillsXp.get((Object)SkillType.HERBALISM) - newvalue);
            this.skillsXp.put(SkillType.ACROBATICS, this.skillsXp.get((Object)SkillType.ACROBATICS) - newvalue);
            this.skillsXp.put(SkillType.SWORDS, this.skillsXp.get((Object)SkillType.SWORDS) - newvalue);
            this.skillsXp.put(SkillType.ARCHERY, this.skillsXp.get((Object)SkillType.ARCHERY) - newvalue);
            this.skillsXp.put(SkillType.UNARMED, this.skillsXp.get((Object)SkillType.UNARMED) - newvalue);
            this.skillsXp.put(SkillType.EXCAVATION, this.skillsXp.get((Object)SkillType.EXCAVATION) - newvalue);
            this.skillsXp.put(SkillType.AXES, this.skillsXp.get((Object)SkillType.AXES) - newvalue);
            this.skillsXp.put(SkillType.SORCERY, this.skillsXp.get((Object)SkillType.SORCERY) - newvalue);
        } else {
            this.skillsXp.put(skillType, this.skillsXp.get((Object)skillType) - newvalue);
        }
        this.save();
    }

    public void acceptInvite() {
        this.party = this.invite;
        this.invite = "";
    }

    public void modifyInvite(String invitename) {
        this.invite = invitename;
    }

    public String getInvite() {
        return this.invite;
    }

    public void modifyskill(SkillType skillType, int newvalue) {
        if (skillType == SkillType.ALL) {
            this.skills.put(SkillType.TAMING, newvalue);
            this.skills.put(SkillType.MINING, newvalue);
            this.skills.put(SkillType.WOODCUTTING, newvalue);
            this.skills.put(SkillType.REPAIR, newvalue);
            this.skills.put(SkillType.HERBALISM, newvalue);
            this.skills.put(SkillType.ACROBATICS, newvalue);
            this.skills.put(SkillType.SWORDS, newvalue);
            this.skills.put(SkillType.ARCHERY, newvalue);
            this.skills.put(SkillType.UNARMED, newvalue);
            this.skills.put(SkillType.EXCAVATION, newvalue);
            this.skills.put(SkillType.AXES, newvalue);
            this.skills.put(SkillType.SORCERY, newvalue);
            this.skillsXp.put(SkillType.TAMING, 0);
            this.skillsXp.put(SkillType.MINING, 0);
            this.skillsXp.put(SkillType.WOODCUTTING, 0);
            this.skillsXp.put(SkillType.REPAIR, 0);
            this.skillsXp.put(SkillType.HERBALISM, 0);
            this.skillsXp.put(SkillType.ACROBATICS, 0);
            this.skillsXp.put(SkillType.SWORDS, 0);
            this.skillsXp.put(SkillType.ARCHERY, 0);
            this.skillsXp.put(SkillType.UNARMED, 0);
            this.skillsXp.put(SkillType.EXCAVATION, 0);
            this.skillsXp.put(SkillType.AXES, 0);
            this.skillsXp.put(SkillType.SORCERY, 0);
        } else {
            this.skills.put(skillType, newvalue);
            this.skillsXp.put(skillType, newvalue);
        }
        this.save();
    }

    public Integer getXpToLevel(SkillType skillType) {
        switch (skillType) {
            case SORCERY: {
                return 100 + this.skills.get((Object)skillType) * LoadProperties.sorceryxpmodifier * LoadProperties.globalxpmodifier;
            }
            case TAMING: {
                return 100 + this.skills.get((Object)skillType) * LoadProperties.tamingxpmodifier * LoadProperties.globalxpmodifier;
            }
            case MINING: {
                return 100 + this.skills.get((Object)skillType) * LoadProperties.miningxpmodifier * LoadProperties.globalxpmodifier;
            }
            case WOODCUTTING: {
                return 100 + this.skills.get((Object)skillType) * LoadProperties.woodcuttingxpmodifier * LoadProperties.globalxpmodifier;
            }
            case REPAIR: {
                return 100 + this.skills.get((Object)skillType) * LoadProperties.repairxpmodifier * LoadProperties.globalxpmodifier;
            }
            case HERBALISM: {
                return 100 + this.skills.get((Object)skillType) * LoadProperties.herbalismxpmodifier * LoadProperties.globalxpmodifier;
            }
            case ACROBATICS: {
                return 100 + this.skills.get((Object)skillType) * LoadProperties.acrobaticsxpmodifier * LoadProperties.globalxpmodifier;
            }
            case SWORDS: {
                return 100 + this.skills.get((Object)skillType) * LoadProperties.swordsxpmodifier * LoadProperties.globalxpmodifier;
            }
            case ARCHERY: {
                return 100 + this.skills.get((Object)skillType) * LoadProperties.archeryxpmodifier * LoadProperties.globalxpmodifier;
            }
            case UNARMED: {
                return 100 + this.skills.get((Object)skillType) * LoadProperties.unarmedxpmodifier * LoadProperties.globalxpmodifier;
            }
            case EXCAVATION: {
                return 100 + this.skills.get((Object)skillType) * LoadProperties.excavationxpmodifier * LoadProperties.globalxpmodifier;
            }
            case AXES: {
                return 100 + this.skills.get((Object)skillType) * LoadProperties.axesxpmodifier * LoadProperties.globalxpmodifier;
            }
        }
        return null;
    }

    public void setParty(String newParty) {
        this.party = newParty;
        this.save();
    }

    public String getParty() {
        return this.party;
    }

    public void removeParty() {
        this.party = null;
        this.save();
    }

    public boolean inParty() {
        return this.party != null && !this.party.equals("") && !this.party.equals("null");
    }

    public boolean hasPartyInvite() {
        return this.invite != null && !this.invite.equals("") && !this.invite.equals("null");
    }

    public String getMySpawnWorld(Plugin plugin) {
        if (this.myspawnworld != null && !this.myspawnworld.equals("") && !this.myspawnworld.equals("null")) {
            return this.myspawnworld;
        }
        return ((World)plugin.getServer().getWorlds().get(0)).toString();
    }

    public void setMySpawn(double x, double y, double z, String myspawnworldlocation) {
        this.myspawn = String.valueOf(x) + "," + y + "," + z;
        this.myspawnworld = myspawnworldlocation;
        this.save();
    }

    public String getX() {
        if (this.myspawn != null) {
            String[] split = this.myspawn.split(",");
            return split[0];
        }
        return null;
    }

    public String getY() {
        if (this.myspawn != null) {
            String[] split = this.myspawn.split(",");
            return split[1];
        }
        return null;
    }

    public String getZ() {
        if (this.myspawn != null) {
            String[] split = this.myspawn.split(",");
            return split[2];
        }
        return null;
    }

    public boolean isDead() {
        return this.dead;
    }

    public Location getMySpawn(Player player) {
        Location loc = null;
        if (this.myspawn != null) {
            if (!(m.isDouble(this.getX()) && m.isDouble(this.getY()) && m.isDouble(this.getZ()))) {
                return null;
            }
        } else {
            return null;
        }
        loc = new Location(player.getWorld(), Double.parseDouble(this.getX()), Double.parseDouble(this.getY()), Double.parseDouble(this.getZ()));
        loc.setYaw(0.0f);
        loc.setPitch(0.0f);
        if (loc.getX() != 0.0 && loc.getY() != 0.0 && loc.getZ() != 0.0 && loc.getWorld() != null) {
            return loc;
        }
        return null;
    }
}

