/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.Item;
import com.gmail.nossr50.Users;
import com.gmail.nossr50.config.LoadProperties;
import com.gmail.nossr50.datatypes.PlayerProfile;
import com.gmail.nossr50.datatypes.SkillType;
import com.gmail.nossr50.locale.mcLocale;
import com.gmail.nossr50.m;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.mcPermissions;
import com.gmail.nossr50.party.Party;
import com.gmail.nossr50.skills.Herbalism;
import com.gmail.nossr50.skills.Repair;
import com.gmail.nossr50.skills.Skills;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class mcPlayerListener
extends PlayerListener {
    protected static final Logger log = Logger.getLogger("Minecraft");
    public Location spawn = null;
    private mcMMO plugin;

    public mcPlayerListener(mcMMO instance) {
        this.plugin = instance;
    }

    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        if (Users.getProfile(event.getPlayer()).getBerserkMode()) {
            event.setCancelled(true);
        }
    }

    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (LoadProperties.enableMySpawn.booleanValue() && mcPermissions.getInstance().mySpawn(player)) {
            PlayerProfile PP = Users.getProfile(player);
            if (player != null && PP != null) {
                PP.setRespawnATS(System.currentTimeMillis());
                Location mySpawn = PP.getMySpawn(player);
                if (mySpawn != null && this.plugin.getServer().getWorld(PP.getMySpawnWorld((Plugin)this.plugin)) != null) {
                    mySpawn.setWorld(this.plugin.getServer().getWorld(PP.getMySpawnWorld((Plugin)this.plugin)));
                }
                if (mySpawn != null) {
                    event.setRespawnLocation(mySpawn);
                }
            }
        }
    }

    public void onPlayerLogin(PlayerLoginEvent event) {
        Users.addUser(event.getPlayer());
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        Users.removeUser(event.getPlayer());
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (mcPermissions.getInstance().motd(player) && LoadProperties.enableMotd.booleanValue()) {
            player.sendMessage(mcLocale.getString("mcPlayerListener.MOTD", new Object[]{this.plugin.getDescription().getVersion(), LoadProperties.mcmmo}));
            player.sendMessage(mcLocale.getString("mcPlayerListener.WIKI"));
        }
        if (this.plugin.xpevent) {
            player.sendMessage(ChatColor.GOLD + "mcMMO is currently in an XP rate event! XP rate is " + LoadProperties.xpGainMultiplier + "x!");
        }
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        PlayerProfile PP = Users.getProfile(player);
        Action action = event.getAction();
        Block block = event.getClickedBlock();
        if (player.getItemInHand().getTypeId() == 261 && LoadProperties.archeryFireRateLimit.booleanValue()) {
            if (System.currentTimeMillis() < PP.getArcheryShotATS() + (long)LoadProperties.archeryLimit) {
                player.updateInventory();
                event.setCancelled(true);
            } else {
                PP.setArcheryShotATS(System.currentTimeMillis());
            }
        }
        if (action == Action.RIGHT_CLICK_BLOCK) {
            ItemStack is = player.getItemInHand();
            if (LoadProperties.enableMySpawn.booleanValue() && block != null && player != null && block.getTypeId() == 26 && mcPermissions.getInstance().setMySpawn(player)) {
                Location loc = player.getLocation();
                if (mcPermissions.getInstance().setMySpawn(player)) {
                    PP.setMySpawn(loc.getX(), loc.getY(), loc.getZ(), loc.getWorld().getName());
                }
                player.sendMessage(mcLocale.getString("mcPlayerListener.MyspawnSet"));
            }
            if (block != null && player != null && mcPermissions.getInstance().repair(player) && event.getClickedBlock().getTypeId() == 42) {
                Repair.repairCheck(player, is, event.getClickedBlock());
            }
            if (m.abilityBlockCheck(block)) {
                if (block != null && m.isHoe(player.getItemInHand()) && block.getTypeId() != 3 && block.getTypeId() != 2 && block.getTypeId() != 60) {
                    Skills.hoeReadinessCheck(player);
                }
                Skills.abilityActivationCheck(player);
            }
            if (block != null && (block.getType() == Material.COBBLESTONE || block.getType() == Material.DIRT) && player.getItemInHand().getType() == Material.SEEDS) {
                boolean pass = false;
                if (Herbalism.hasSeeds(player) && mcPermissions.getInstance().herbalism(player)) {
                    Herbalism.removeSeeds(player);
                    if (LoadProperties.enableCobbleToMossy.booleanValue() && m.blockBreakSimulate(block, player, (Plugin)this.plugin) && block.getType() == Material.COBBLESTONE && Math.random() * 1500.0 <= (double)PP.getSkillLevel(SkillType.HERBALISM).intValue()) {
                        player.sendMessage(mcLocale.getString("mcPlayerListener.GreenThumb"));
                        block.setType(Material.MOSSY_COBBLESTONE);
                        pass = true;
                    }
                    if (block.getType() == Material.DIRT && m.blockBreakSimulate(block, player, (Plugin)this.plugin) && Math.random() * 1500.0 <= (double)PP.getSkillLevel(SkillType.HERBALISM).intValue()) {
                        player.sendMessage(mcLocale.getString("mcPlayerListener.GreenThumb"));
                        block.setType(Material.GRASS);
                        pass = true;
                    }
                    if (!pass) {
                        player.sendMessage(mcLocale.getString("mcPlayerListener.GreenThumbFail"));
                    }
                }
                return;
            }
        }
        if (action == Action.RIGHT_CLICK_AIR) {
            Skills.hoeReadinessCheck(player);
            Skills.abilityActivationCheck(player);
            if (mcPermissions.getInstance().herbalism(player)) {
                Herbalism.breadCheck(player, player.getItemInHand());
                Herbalism.stewCheck(player, player.getItemInHand());
            }
        }
        if (action == Action.RIGHT_CLICK_AIR) {
            Item.itemchecks(player, (Plugin)this.plugin);
        }
        if (action == Action.RIGHT_CLICK_BLOCK && m.abilityBlockCheck(event.getClickedBlock())) {
            Item.itemchecks(player, (Plugin)this.plugin);
        }
    }

    public void onPlayerChat(PlayerChatEvent event) {
        Player player = event.getPlayer();
        PlayerProfile PP = Users.getProfile(player);
        String x = ChatColor.GREEN + "(" + ChatColor.WHITE + player.getName() + ChatColor.GREEN + ") ";
        String y = ChatColor.AQUA + "{" + ChatColor.WHITE + player.getName() + ChatColor.AQUA + "} ";
        if (PP.getPartyChatMode()) {
            event.setCancelled(true);
            log.log(Level.INFO, "[P](" + PP.getParty() + ")" + "<" + player.getName() + "> " + event.getMessage());
            Player[] playerArray = this.plugin.getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player herp = playerArray[n2];
                if (Users.getProfile(herp).inParty() && Party.getInstance().inSameParty(herp, player)) {
                    herp.sendMessage(String.valueOf(x) + event.getMessage());
                }
                ++n2;
            }
            return;
        }
        if ((player.isOp() || mcPermissions.getInstance().adminChat(player)) && PP.getAdminChatMode()) {
            log.log(Level.INFO, "[A]<" + player.getName() + "> " + event.getMessage());
            event.setCancelled(true);
            Player[] playerArray = this.plugin.getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n3 = 0;
            while (n3 < n) {
                Player herp = playerArray[n3];
                if (herp.isOp() || mcPermissions.getInstance().adminChat(herp)) {
                    herp.sendMessage(String.valueOf(y) + event.getMessage());
                }
                ++n3;
            }
            return;
        }
    }
}

