/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills;

import com.gmail.nossr50.Users;
import com.gmail.nossr50.config.LoadProperties;
import com.gmail.nossr50.datatypes.PlayerProfile;
import com.gmail.nossr50.datatypes.SkillType;
import com.gmail.nossr50.locale.mcLocale;
import com.gmail.nossr50.m;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.Skills;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Herbalism {
    public static void greenTerraWheat(Player player, Block block, BlockBreakEvent event, mcMMO plugin) {
        if (block.getType() == Material.WHEAT && block.getData() == 7) {
            event.setCancelled(true);
            PlayerProfile PP = Users.getProfile(player);
            Material mat = Material.getMaterial((int)296);
            Location loc = block.getLocation();
            ItemStack is = new ItemStack(mat, 1, 0, Byte.valueOf((byte)0));
            PP.addXP(SkillType.HERBALISM, 5 * LoadProperties.xpGainMultiplier);
            loc.getWorld().dropItemNaturally(loc, is);
            mat = Material.SEEDS;
            is = new ItemStack(mat, 1, 0, Byte.valueOf((byte)0));
            loc.getWorld().dropItemNaturally(loc, is);
            Herbalism.herbalismProcCheck(block, player, event, plugin);
            Herbalism.herbalismProcCheck(block, player, event, plugin);
            block.setData((byte)3);
        }
    }

    public static void greenTerra(Player player, Block block) {
        if (block.getType() == Material.COBBLESTONE || block.getType() == Material.DIRT) {
            if (!Herbalism.hasSeeds(player)) {
                player.sendMessage("You need more seeds to spread Green Terra");
            }
            if (Herbalism.hasSeeds(player) && block.getType() != Material.WHEAT) {
                Herbalism.removeSeeds(player);
                if (block.getType() == Material.DIRT) {
                    block.setType(Material.GRASS);
                }
                if (LoadProperties.enableCobbleToMossy.booleanValue() && block.getType() == Material.COBBLESTONE) {
                    block.setType(Material.MOSSY_COBBLESTONE);
                }
            }
        }
    }

    public static Boolean canBeGreenTerra(Block block) {
        int t = block.getTypeId();
        if (t == 4 || t == 3 || t == 59 || t == 81 || t == 83 || t == 91 || t == 86 || t == 39 || t == 46 || t == 37 || t == 38) {
            return true;
        }
        return false;
    }

    public static boolean hasSeeds(Player player) {
        ItemStack[] inventory;
        ItemStack[] itemStackArray = inventory = player.getInventory().getContents();
        int n = inventory.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack x = itemStackArray[n2];
            if (x != null && x.getTypeId() == 295) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void removeSeeds(Player player) {
        ItemStack[] inventory;
        ItemStack[] itemStackArray = inventory = player.getInventory().getContents();
        int n = inventory.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack x = itemStackArray[n2];
            if (x != null && x.getTypeId() == 295) {
                if (x.getAmount() == 1) {
                    x.setTypeId(0);
                    x.setAmount(0);
                    player.getInventory().setContents(inventory);
                } else {
                    x.setAmount(x.getAmount() - 1);
                    player.getInventory().setContents(inventory);
                }
                return;
            }
            ++n2;
        }
    }

    public static void greenTerraCheck(Player player, Block block, Plugin pluginx) {
        PlayerProfile PP = Users.getProfile(player);
        if (m.isHoe(player.getItemInHand())) {
            if (block != null && !m.abilityBlockCheck(block)) {
                return;
            }
            if (PP.getHoePreparationMode()) {
                PP.setHoePreparationMode(false);
            }
            int ticks = 2;
            int x = PP.getSkillLevel(SkillType.HERBALISM);
            while (x >= 50) {
                x -= 50;
                ++ticks;
            }
            if (!PP.getGreenTerraMode() && Skills.cooldownOver(player, PP.getGreenTerraDeactivatedTimeStamp(), LoadProperties.greenTerraCooldown)) {
                player.sendMessage(mcLocale.getString("Skills.GreenTerraOn"));
                Player[] playerArray = pluginx.getServer().getOnlinePlayers();
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player y = playerArray[n2];
                    if (y != null && y != player && m.getDistance(player.getLocation(), y.getLocation()) < 10.0) {
                        y.sendMessage(mcLocale.getString("Skills.GreenTerraPlayer", new Object[]{player.getName()}));
                    }
                    ++n2;
                }
                PP.setGreenTerraActivatedTimeStamp(System.currentTimeMillis());
                PP.setGreenTerraDeactivatedTimeStamp(System.currentTimeMillis() + (long)(ticks * 1000));
                PP.setGreenTerraMode(true);
            }
        }
    }

    public static void herbalismProcCheck(Block block, Player player, BlockBreakEvent event, mcMMO plugin) {
        PlayerProfile PP = Users.getProfile(player);
        int type = block.getTypeId();
        Location loc = block.getLocation();
        ItemStack is = null;
        Material mat = null;
        if (plugin.misc.blockWatchList.contains(block)) {
            return;
        }
        if (type == 59 && block.getData() == 7) {
            mat = Material.getMaterial((int)296);
            is = new ItemStack(mat, 1, 0, Byte.valueOf((byte)0));
            PP.addXP(SkillType.HERBALISM, LoadProperties.mwheat * LoadProperties.xpGainMultiplier);
            if (player != null && Math.random() * 1000.0 <= (double)PP.getSkillLevel(SkillType.HERBALISM).intValue()) {
                loc.getWorld().dropItemNaturally(loc, is);
            }
            if (Math.random() * 1500.0 <= (double)PP.getSkillLevel(SkillType.HERBALISM).intValue()) {
                event.setCancelled(true);
                loc.getWorld().dropItemNaturally(loc, is);
                mat = Material.SEEDS;
                is = new ItemStack(mat, 1, 0, Byte.valueOf((byte)0));
                loc.getWorld().dropItemNaturally(loc, is);
                block.setData((byte)1);
                int bonus = 0;
                if (PP.getSkillLevel(SkillType.HERBALISM) >= 200) {
                    ++bonus;
                }
                if (PP.getSkillLevel(SkillType.HERBALISM) >= 400) {
                    ++bonus;
                }
                if (PP.getSkillLevel(SkillType.HERBALISM) >= 600) {
                    ++bonus;
                }
                if (bonus == 1) {
                    block.setData((byte)2);
                }
                if (bonus == 2) {
                    block.setData((byte)3);
                }
                if (bonus == 3) {
                    block.setData((byte)4);
                }
            }
        }
        if (block.getData() != 5) {
            Block target;
            int n;
            int n2;
            Block[] blockArray;
            int x;
            byte[] byteArray;
            Material[] materialArray;
            Block[] blockArray2;
            if (type == 81) {
                World world = block.getWorld();
                blockArray2 = new Block[]{block, world.getBlockAt(block.getX(), block.getY() + 1, block.getZ()), world.getBlockAt(block.getX(), block.getY() + 2, block.getZ())};
                materialArray = new Material[]{blockArray2[0].getType(), blockArray2[1].getType(), blockArray2[2].getType()};
                byteArray = new byte[]{blockArray2[0].getData(), blockArray2[0].getData(), blockArray2[0].getData()};
                x = 0;
                blockArray = blockArray2;
                n2 = blockArray2.length;
                n = 0;
                while (n < n2) {
                    target = blockArray[n];
                    if (materialArray[x] == Material.CACTUS) {
                        is = new ItemStack(Material.CACTUS, 1, 0, Byte.valueOf((byte)0));
                        if (byteArray[x] != 5) {
                            if (Math.random() * 1000.0 <= (double)PP.getSkillLevel(SkillType.HERBALISM).intValue()) {
                                loc.getWorld().dropItemNaturally(target.getLocation(), is);
                            }
                            PP.addXP(SkillType.HERBALISM, LoadProperties.mcactus * LoadProperties.xpGainMultiplier);
                        }
                    }
                    ++x;
                    ++n;
                }
            }
            if (type == 83) {
                World world = block.getWorld();
                blockArray2 = new Block[]{block, world.getBlockAt(block.getX(), block.getY() + 1, block.getZ()), world.getBlockAt(block.getX(), block.getY() + 2, block.getZ())};
                materialArray = new Material[]{blockArray2[0].getType(), blockArray2[1].getType(), blockArray2[2].getType()};
                byteArray = new byte[]{blockArray2[0].getData(), blockArray2[0].getData(), blockArray2[0].getData()};
                x = 0;
                blockArray = blockArray2;
                n2 = blockArray2.length;
                n = 0;
                while (n < n2) {
                    target = blockArray[n];
                    if (materialArray[x] == Material.SUGAR_CANE_BLOCK) {
                        is = new ItemStack(Material.SUGAR_CANE, 1, 0, Byte.valueOf((byte)0));
                        if (byteArray[x] != 5) {
                            if (Math.random() * 1000.0 <= (double)PP.getSkillLevel(SkillType.HERBALISM).intValue()) {
                                loc.getWorld().dropItemNaturally(target.getLocation(), is);
                            }
                            PP.addXP(SkillType.HERBALISM, LoadProperties.msugar * LoadProperties.xpGainMultiplier);
                        }
                    }
                    ++x;
                    ++n;
                }
            }
            if (type == 91 || type == 86) {
                mat = Material.getMaterial((int)block.getTypeId());
                is = new ItemStack(mat, 1, 0, Byte.valueOf((byte)0));
                if (player != null && Math.random() * 1000.0 <= (double)PP.getSkillLevel(SkillType.HERBALISM).intValue()) {
                    loc.getWorld().dropItemNaturally(loc, is);
                }
                PP.addXP(SkillType.HERBALISM, LoadProperties.mpumpkin * LoadProperties.xpGainMultiplier);
            }
            if (type == 39 || type == 40) {
                mat = Material.getMaterial((int)block.getTypeId());
                is = new ItemStack(mat, 1, 0, Byte.valueOf((byte)0));
                if (player != null && Math.random() * 1000.0 <= (double)PP.getSkillLevel(SkillType.HERBALISM).intValue()) {
                    loc.getWorld().dropItemNaturally(loc, is);
                }
                PP.addXP(SkillType.HERBALISM, LoadProperties.mmushroom * LoadProperties.xpGainMultiplier);
            }
            if (type == 37 || type == 38) {
                mat = Material.getMaterial((int)block.getTypeId());
                is = new ItemStack(mat, 1, 0, Byte.valueOf((byte)0));
                if (player != null && Math.random() * 1000.0 <= (double)PP.getSkillLevel(SkillType.HERBALISM).intValue()) {
                    loc.getWorld().dropItemNaturally(loc, is);
                }
                PP.addXP(SkillType.HERBALISM, LoadProperties.mflower * LoadProperties.xpGainMultiplier);
            }
        }
        Skills.XpCheckSkill(SkillType.HERBALISM, player);
    }

    public static void breadCheck(Player player, ItemStack is) {
        PlayerProfile PP = Users.getProfile(player);
        int herbalism = PP.getSkillLevel(SkillType.HERBALISM);
        if (is.getTypeId() == 297) {
            if (herbalism >= 50 && herbalism < 150) {
                player.setHealth(player.getHealth() + 1);
            } else if (herbalism >= 150 && herbalism < 250) {
                player.setHealth(player.getHealth() + 2);
            } else if (herbalism >= 250 && herbalism < 350) {
                player.setHealth(player.getHealth() + 3);
            } else if (herbalism >= 350 && herbalism < 450) {
                player.setHealth(player.getHealth() + 4);
            } else if (herbalism >= 450 && herbalism < 550) {
                player.setHealth(player.getHealth() + 5);
            } else if (herbalism >= 550 && herbalism < 650) {
                player.setHealth(player.getHealth() + 6);
            } else if (herbalism >= 650 && herbalism < 750) {
                player.setHealth(player.getHealth() + 7);
            } else if (herbalism >= 750) {
                player.setHealth(player.getHealth() + 8);
            }
        }
    }

    public static void stewCheck(Player player, ItemStack is) {
        PlayerProfile PP = Users.getProfile(player);
        int herbalism = PP.getSkillLevel(SkillType.HERBALISM);
        if (is.getTypeId() == 282) {
            if (herbalism >= 50 && herbalism < 150) {
                player.setHealth(player.getHealth() + 1);
            } else if (herbalism >= 150 && herbalism < 250) {
                player.setHealth(player.getHealth() + 2);
            } else if (herbalism >= 250 && herbalism < 350) {
                player.setHealth(player.getHealth() + 3);
            } else if (herbalism >= 350 && herbalism < 450) {
                player.setHealth(player.getHealth() + 4);
            } else if (herbalism >= 450 && herbalism < 550) {
                player.setHealth(player.getHealth() + 5);
            } else if (herbalism >= 550 && herbalism < 650) {
                player.setHealth(player.getHealth() + 6);
            } else if (herbalism >= 650 && herbalism < 750) {
                player.setHealth(player.getHealth() + 7);
            } else if (herbalism >= 750) {
                player.setHealth(player.getHealth() + 8);
            }
        }
    }
}

