/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills;

import com.gmail.nossr50.Users;
import com.gmail.nossr50.config.LoadProperties;
import com.gmail.nossr50.datatypes.PlayerProfile;
import com.gmail.nossr50.locale.mcLocale;
import com.gmail.nossr50.m;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.mcPermissions;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class Sorcery {
    mcMMO plugin = null;

    public Sorcery(mcMMO pluginx) {
        this.plugin = pluginx;
    }

    public Block getSpellTargetBlock(Player player) {
        List blocks = player.getLineOfSight(null, 25);
        for (Block x : blocks) {
            Material y = Material.AIR;
            if (x.getType() == y) continue;
            return x;
        }
        return null;
    }

    public void informSelected(String spellname, int cost, Player player) {
        player.sendMessage(mcLocale.getString("Sorcery.SpellSelected", new Object[]{spellname, cost}));
    }

    public void informSpell(String spellname, Player player) {
        PlayerProfile PP = Users.getProfile(player);
        player.sendMessage(String.valueOf(mcLocale.getString("Sorcery.HasCast")) + " " + spellname + " " + mcLocale.getString("Sorcery.Current_Mana") + ChatColor.YELLOW + "(" + ChatColor.GRAY + PP.getCurrentMana() + ChatColor.YELLOW + "/" + ChatColor.GREEN + PP.getMaxMana() + ChatColor.YELLOW + ")");
    }

    public void shoutSpell(String spellname, Player player) {
        Player[] playerArray = this.plugin.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player x = playerArray[n2];
            if (x != player && m.getDistance(x.getLocation(), player.getLocation()) < 35.0) {
                x.sendMessage(ChatColor.GREEN + "-" + ChatColor.DARK_AQUA + "=" + ChatColor.GOLD + spellname + ChatColor.DARK_AQUA + "=" + ChatColor.GREEN + "-" + " " + ChatColor.YELLOW + "[" + ChatColor.DARK_RED + player.getName() + ChatColor.YELLOW + "]");
            }
            ++n2;
        }
    }

    public void handleGreenDyeCycle(Player player) {
        PlayerProfile PP = Users.getProfile(player);
        if (!this.hasCurativeSpellPermission(player)) {
            PP.setDyeChanged(true);
        }
        switch (PP.getGreenDyeCycleSel()) {
            case 0: {
                if (mcPermissions.getInstance().sorceryCurativeHealSelf(player)) {
                    PP.setDyeChanged(true);
                    PP.setGreenDyeCycleSel(1);
                    PP.setGreenDyeCycle(0);
                    this.informSelected(mcLocale.getString("Sorcery.Curative.Self"), LoadProperties.cure_self, player);
                    break;
                }
                PP.setGreenDyeCycleSel(1);
            }
            case 1: {
                if (mcPermissions.getInstance().sorceryCurativeHealOther(player)) {
                    PP.setDyeChanged(true);
                    PP.setGreenDyeCycleSel(0);
                    PP.setGreenDyeCycle(1);
                    this.informSelected(mcLocale.getString("Sorcery.Curative.Other"), LoadProperties.cure_other, player);
                    break;
                }
                PP.setGreenDyeCycleSel(0);
            }
        }
    }

    public boolean hasCurativeSpellPermission(Player player) {
        return mcPermissions.getInstance().sorceryCurativeHealOther(player) || mcPermissions.getInstance().sorceryCurativeHealSelf(player);
    }
}

