/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills;

import com.gmail.nossr50.Users;
import com.gmail.nossr50.config.LoadProperties;
import com.gmail.nossr50.datatypes.PlayerProfile;
import com.gmail.nossr50.datatypes.SkillType;
import com.gmail.nossr50.locale.mcLocale;
import com.gmail.nossr50.m;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.Skills;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class WoodCutting {
    static int w = 0;
    private static boolean isdone = false;

    public static void woodCuttingProcCheck(Player player, Block block) {
        PlayerProfile PP = Users.getProfile(player);
        byte type = block.getData();
        Material mat = Material.getMaterial((int)block.getTypeId());
        if (player != null && Math.random() * 1000.0 <= (double)PP.getSkillLevel(SkillType.WOODCUTTING).intValue()) {
            ItemStack item = new ItemStack(mat, 1, 0, Byte.valueOf(type));
            block.getWorld().dropItemNaturally(block.getLocation(), item);
        }
    }

    public static void treeFellerCheck(Player player, Block block, Plugin pluginx) {
        PlayerProfile PP = Users.getProfile(player);
        if (m.isAxes(player.getItemInHand())) {
            if (block != null && !m.abilityBlockCheck(block)) {
                return;
            }
            if (PP.getAxePreparationMode()) {
                PP.setAxePreparationMode(false);
            }
            int ticks = 2;
            int x = PP.getSkillLevel(SkillType.WOODCUTTING);
            while (x >= 50) {
                x -= 50;
                ++ticks;
            }
            if (!PP.getTreeFellerMode() && Skills.cooldownOver(player, PP.getTreeFellerDeactivatedTimeStamp(), LoadProperties.treeFellerCooldown)) {
                player.sendMessage(mcLocale.getString("Skills.TreeFellerOn"));
                Player[] playerArray = pluginx.getServer().getOnlinePlayers();
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player y = playerArray[n2];
                    if (y != null && y != player && m.getDistance(player.getLocation(), y.getLocation()) < 10.0) {
                        y.sendMessage(mcLocale.getString("Skills.TreeFellerPlayer", new Object[]{player.getName()}));
                    }
                    ++n2;
                }
                PP.setTreeFellerActivatedTimeStamp(System.currentTimeMillis());
                PP.setTreeFellerDeactivatedTimeStamp(System.currentTimeMillis() + (long)(ticks * 1000));
                PP.setTreeFellerMode(true);
            }
            if (!PP.getTreeFellerMode() && !Skills.cooldownOver(player, PP.getTreeFellerDeactivatedTimeStamp(), LoadProperties.treeFellerCooldown)) {
                player.sendMessage(ChatColor.RED + "You are too tired to use that ability again." + ChatColor.YELLOW + " (" + Skills.calculateTimeLeft(player, PP.getTreeFellerDeactivatedTimeStamp(), LoadProperties.treeFellerCooldown) + "s)");
            }
        }
    }

    public static void treeFeller(Block block, Player player, mcMMO plugin) {
        PlayerProfile PP = Users.getProfile(player);
        int radius = 1;
        if (PP.getSkillLevel(SkillType.WOODCUTTING) >= 500) {
            ++radius;
        }
        if (PP.getSkillLevel(SkillType.WOODCUTTING) >= 950) {
            ++radius;
        }
        ArrayList<Block> blocklist = new ArrayList<Block>();
        ArrayList<Block> toAdd = new ArrayList<Block>();
        if (block != null) {
            blocklist.add(block);
        }
        while (!isdone) {
            WoodCutting.addBlocksToTreeFelling(blocklist, toAdd, radius);
        }
        isdone = false;
        for (Block x : toAdd) {
            if (plugin.misc.treeFeller.contains(x)) continue;
            plugin.misc.treeFeller.add(x);
        }
        toAdd.clear();
    }

    public static void addBlocksToTreeFelling(ArrayList<Block> blocklist, ArrayList<Block> toAdd, Integer radius) {
        int u = 0;
        for (Block x : blocklist) {
            ++u;
            if (toAdd.contains(x)) continue;
            w = 0;
            Location loc = x.getLocation();
            int vx = x.getX();
            int vy = x.getY();
            int vz = x.getZ();
            int cx = -radius.intValue();
            while (cx <= radius) {
                int cy = -radius.intValue();
                while (cy <= radius) {
                    int cz = -radius.intValue();
                    while (cz <= radius) {
                        Block blocktarget = loc.getWorld().getBlockAt(vx + cx, vy + cy, vz + cz);
                        if (!(blocklist.contains(blocktarget) || toAdd.contains(blocktarget) || blocktarget.getTypeId() != 17 && blocktarget.getTypeId() != 18)) {
                            toAdd.add(blocktarget);
                            ++w;
                        }
                        ++cz;
                    }
                    ++cy;
                }
                ++cx;
            }
        }
        for (Block xx : toAdd) {
            if (blocklist.contains(xx)) continue;
            blocklist.add(xx);
        }
        isdone = u >= blocklist.size();
    }
}

