/*
 * Decompiled with CFR 0.152.
 */
package com.niccholaspage.Vanilla;

import com.nijiko.permissions.PermissionHandler;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.config.Configuration;

public class Vanilla
extends JavaPlugin {
    public List<String> hiddenPlugins = new ArrayList<String>();
    public PermissionHandler Permissions;
    public boolean hidePluginCommand = false;
    public boolean hideVersionCommand = false;

    public void onDisable() {
        System.out.println("Vanilla Disabled");
    }

    private boolean createFile(String file) {
        File f = new File(file);
        if (!f.exists()) {
            if (file.endsWith("/")) {
                f.mkdir();
            } else {
                try {
                    f.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    private void writeDefaultNode(String node, Object value, Configuration config) {
        if (config.getProperty(node) == null) {
            config.setProperty(node, value);
        }
    }

    private void setupPermissions() {
        Plugin test = this.getServer().getPluginManager().getPlugin("Permissions");
        if (this.Permissions == null) {
            if (test != null) {
                this.Permissions = ((Permissions)test).getHandler();
            } else {
                System.out.println("Permissions system not detected, only OPs will be able to use the command.");
            }
        }
    }

    private boolean hasPermission(CommandSender sender, String node) {
        if (sender instanceof Player) {
            if (this.Permissions == null) {
                return ((Player)sender).isOp();
            }
            return this.Permissions.has((Player)sender, node);
        }
        return true;
    }

    public void onEnable() {
        PlayerListener playerListener = new PlayerListener(){

            public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
                Player player = event.getPlayer();
                String cmdName = event.getMessage().split("\\s+")[0].substring(1);
                if (cmdName.equalsIgnoreCase("plugins") || cmdName.equalsIgnoreCase("pl")) {
                    event.setCancelled(true);
                    if (Vanilla.this.hidePluginCommand) {
                        return;
                    }
                    Plugin[] plugins = Vanilla.this.getServer().getPluginManager().getPlugins();
                    String list = "Plugins: ";
                    int i = 0;
                    while (i < plugins.length) {
                        if (!Vanilla.this.hiddenPlugins.contains(plugins[i].getDescription().getName().toLowerCase())) {
                            list = String.valueOf(list) + "\u00a7a" + plugins[i].getDescription().getName() + "\u00a7f, ";
                        }
                        ++i;
                    }
                    player.sendMessage(list.substring(0, list.length() - 2));
                } else if ((cmdName.equalsIgnoreCase("ver") || cmdName.equalsIgnoreCase("version")) && Vanilla.this.hideVersionCommand) {
                    event.setCancelled(true);
                }
            }
        };
        this.setupPermissions();
        this.readConfig();
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_COMMAND_PREPROCESS, (Listener)playerListener, Event.Priority.Normal, (Plugin)this);
        PluginDescriptionFile pdfFile = this.getDescription();
        System.out.println(String.valueOf(pdfFile.getName()) + " version " + pdfFile.getVersion() + " is enabled!");
    }

    private void readConfig() {
        this.createFile("plugins/Vanilla/");
        this.createFile("plugins/Vanilla/config.yml");
        Configuration config = new Configuration(new File("plugins/Vanilla/config.yml"));
        config.load();
        this.writeDefaultNode("Vanilla", "", config);
        this.writeDefaultNode("Vanilla.hiddenplugins", "", config);
        this.writeDefaultNode("Vanilla.hideplugincommand", false, config);
        this.writeDefaultNode("Vanilla.hideversioncommand", false, config);
        config.save();
        this.hideVersionCommand = config.getBoolean("Vanilla.hideversioncommand", false);
        this.hidePluginCommand = config.getBoolean("Vanilla.hideplugincommand", false);
        String[] split = config.getString("Vanilla.hiddenplugins", "").split(",");
        this.hiddenPlugins.clear();
        int i = 0;
        while (i < split.length) {
            this.hiddenPlugins.add(split[i].toLowerCase());
            ++i;
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (args.length < 1) {
            if (!this.hasPermission(sender, "Vanilla.version")) {
                return true;
            }
            sender.sendMessage(ChatColor.GREEN + "Vanilla version " + this.getDescription().getVersion());
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!this.hasPermission(sender, "Vanilla.reload")) {
                return true;
            }
            this.readConfig();
            sender.sendMessage(ChatColor.GREEN + "Vanilla configuration has been reloaded.");
        }
        return true;
    }
}

