/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.checks.moving;

import cc.co.evenprime.bukkit.nocheat.NoCheat;
import cc.co.evenprime.bukkit.nocheat.actions.ActionExecutor;
import cc.co.evenprime.bukkit.nocheat.actions.ActionExecutorWithHistory;
import cc.co.evenprime.bukkit.nocheat.config.cache.ConfigurationCache;
import cc.co.evenprime.bukkit.nocheat.data.MovingData;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class MorePacketsCheck {
    private final ActionExecutor action;
    private final long packetsPerTimeframe = 22L;
    private final double bufferLimit = 30.0;
    private final NoCheat plugin;

    public MorePacketsCheck(NoCheat plugin) {
        this.action = new ActionExecutorWithHistory(plugin);
        this.plugin = plugin;
    }

    public Location check(Player player, ConfigurationCache cc, MovingData data) {
        int ingameSeconds;
        Location newToLocation = null;
        ++data.morePacketsCounter;
        if (data.morePacketsSetbackPoint == null) {
            data.morePacketsSetbackPoint = player.getLocation();
        }
        if ((ingameSeconds = this.plugin.getIngameSeconds()) != data.lastElapsedIngameSeconds) {
            long limit = 22L * this.plugin.getIngameSecondDuration() / 1000L;
            long difference = limit - (long)data.morePacketsCounter;
            data.morePacketsBuffer += (double)difference;
            if (data.morePacketsBuffer > 30.0) {
                data.morePacketsBuffer = 30.0;
            }
            int packetsAboveLimit = (int)(-data.morePacketsBuffer);
            if (data.morePacketsBuffer < 0.0) {
                data.morePacketsBuffer = 0.0;
            }
            if (!this.plugin.skipCheck() && packetsAboveLimit > 0) {
                data.morePacketsViolationLevel += (double)packetsAboveLimit;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("\\[packets\\]", String.valueOf((long)data.morePacketsCounter - limit));
                params.put("\\[check\\]", "morepackets");
                boolean cancel = false;
                cancel = this.action.executeActions(player, cc.moving.morePacketsActions, (int)data.morePacketsViolationLevel, params, cc);
                if (cancel && player.getWorld().equals(data.morePacketsSetbackPoint.getWorld())) {
                    newToLocation = data.morePacketsSetbackPoint;
                }
            }
            if (newToLocation == null) {
                data.morePacketsSetbackPoint = player.getLocation();
            }
            if (data.morePacketsViolationLevel > 0.0) {
                data.morePacketsViolationLevel *= 0.8;
            }
            data.morePacketsCounter = 0;
            data.lastElapsedIngameSeconds = ingameSeconds;
        }
        return newToLocation;
    }
}

